<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Date StructType
 * @subpackage Structs
 */
class Date extends AbstractStructBase
{
    /**
     * The ANNOTATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ANNOTATION
     * @var \StructType\ANNOTATION
     */
    public $ANNOTATION;
    /**
     * The DAY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 31
     * - minInclusive: 1
     * - totalDigits: 2
     * @var int
     */
    public $DAY;
    /**
     * The MONTH
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 12
     * - minInclusive: 1
     * - totalDigits: 2
     * @var int
     */
    public $MONTH;
    /**
     * The VALUE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern:
     * ((31\/(0?[13578]|1[02]))|((29|30)\/(0?[1,3-9]|1[0-2])))\/((\d{0,2})?\d{2})|(29\/0?2)\/(((\d{0,2})?(0[48]|[2468][048]|[13579][26])|(([48]|1[26]|[2468][048]|[3579][26])00)))|(0?[1-9]|1\d|2[0-8])\/((0?[1-9])|(1[0-2]))\/((\d{0,2})?\d{2})\s([01][0-9]|2[0-
     * 3]):([0-5][0-9]):([0-5][0-9])
     * @var string
     */
    public $VALUE;
    /**
     * The YEAR
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $YEAR;
    /**
     * The TYPE
     * Meta informations extracted from the WSDL
     * - fixed: date
     * - use: optional
     * @var string
     */
    public $TYPE;
    /**
     * Constructor method for Date
     * @uses Date::setANNOTATION()
     * @uses Date::setDAY()
     * @uses Date::setMONTH()
     * @uses Date::setVALUE()
     * @uses Date::setYEAR()
     * @uses Date::setTYPE()
     * @param \StructType\ANNOTATION $aNNOTATION
     * @param int $dAY
     * @param int $mONTH
     * @param string $vALUE
     * @param string $yEAR
     * @param string $tYPE
     */
    public function __construct(\StructType\ANNOTATION $aNNOTATION = null, $dAY = null, $mONTH = null, $vALUE = null, $yEAR = null, $tYPE = null)
    {
        $this
            ->setANNOTATION($aNNOTATION)
            ->setDAY($dAY)
            ->setMONTH($mONTH)
            ->setVALUE($vALUE)
            ->setYEAR($yEAR)
            ->setTYPE($tYPE);
    }
    /**
     * Get ANNOTATION value
     * @return \StructType\ANNOTATION|null
     */
    public function getANNOTATION()
    {
        return $this->ANNOTATION;
    }
    /**
     * Set ANNOTATION value
     * @param \StructType\ANNOTATION $aNNOTATION
     * @return \StructType\Date
     */
    public function setANNOTATION(\StructType\ANNOTATION $aNNOTATION = null)
    {
        $this->ANNOTATION = $aNNOTATION;
        return $this;
    }
    /**
     * Get DAY value
     * @return int|null
     */
    public function getDAY()
    {
        return $this->DAY;
    }
    /**
     * Set DAY value
     * @param int $dAY
     * @return \StructType\Date
     */
    public function setDAY($dAY = null)
    {
        // validation for constraint: totalDigits
        if (is_float($dAY) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $dAY)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 digits, "%d" given', strlen(substr($dAY, strpos($dAY, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($dAY) && !is_numeric($dAY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dAY)), __LINE__);
        }
        $this->DAY = $dAY;
        return $this;
    }
    /**
     * Get MONTH value
     * @return int|null
     */
    public function getMONTH()
    {
        return $this->MONTH;
    }
    /**
     * Set MONTH value
     * @param int $mONTH
     * @return \StructType\Date
     */
    public function setMONTH($mONTH = null)
    {
        // validation for constraint: totalDigits
        if (is_float($mONTH) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $mONTH)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 digits, "%d" given', strlen(substr($mONTH, strpos($mONTH, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($mONTH) && !is_numeric($mONTH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mONTH)), __LINE__);
        }
        $this->MONTH = $mONTH;
        return $this;
    }
    /**
     * Get VALUE value
     * @return string|null
     */
    public function getVALUE()
    {
        return $this->VALUE;
    }
    /**
     * Set VALUE value
     * @param string $vALUE
     * @return \StructType\Date
     */
    public function setVALUE($vALUE = null)
    {
        // validation for constraint: pattern
        if (is_scalar($vALUE) && !preg_match('/((31\/(0?[13578]|1[02]))|((29|30)\/(0?[1,3-9]|1[0-2])))\/((\d{0,2})?\d{2})|(29\/0?2)\/(((\d{0,2})?(0[48]|[2468][048]|[13579][26])|(([48]|1[26]|[2468][048]|[3579][26])00)))|(0?[1-9]|1\d|2[0-8])\/((0?[1-9])|(1[0-2]))\/((\d{0,2})?\d{2})\s([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])/', $vALUE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "((31\/(0?[13578]|1[02]))|((29|30)\/(0?[1,3-9]|1[0-2])))\/((\d{0,2})?\d{2})|(29\/0?2)\/(((\d{0,2})?(0[48]|[2468][048]|[13579][26])|(([48]|1[26]|[2468][048]|[3579][26])00)))|(0?[1-9]|1\d|2[0-8])\/((0?[1-9])|(1[0-2]))\/((\d{0,2})?\d{2})\s([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])", "%s" given', var_export($vALUE, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vALUE) && !is_string($vALUE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vALUE)), __LINE__);
        }
        $this->VALUE = $vALUE;
        return $this;
    }
    /**
     * Get YEAR value
     * @return string|null
     */
    public function getYEAR()
    {
        return $this->YEAR;
    }
    /**
     * Set YEAR value
     * @param string $yEAR
     * @return \StructType\Date
     */
    public function setYEAR($yEAR = null)
    {
        // validation for constraint: string
        if (!is_null($yEAR) && !is_string($yEAR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($yEAR)), __LINE__);
        }
        $this->YEAR = $yEAR;
        return $this;
    }
    /**
     * Get TYPE value
     * @return string|null
     */
    public function getTYPE()
    {
        return $this->TYPE;
    }
    /**
     * Set TYPE value
     * @uses \EnumType\Type::valueIsValid()
     * @uses \EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tYPE
     * @return \StructType\Date
     */
    public function setTYPE($tYPE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Type::valueIsValid($tYPE)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tYPE, implode(', ', \EnumType\Type::getValidValues())), __LINE__);
        }
        $this->TYPE = $tYPE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Date
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
