<?php

namespace EnumType;

/**
 * This class stands for searchLanguageType EnumType
 * @subpackage Enumerations
 */
class SearchLanguageType
{
    /**
     * Constant for value 'bg'
     * @return string 'bg'
     */
    const VALUE_BG = 'bg';
    /**
     * Constant for value 'cs'
     * @return string 'cs'
     */
    const VALUE_CS = 'cs';
    /**
     * Constant for value 'da'
     * @return string 'da'
     */
    const VALUE_DA = 'da';
    /**
     * Constant for value 'nl'
     * @return string 'nl'
     */
    const VALUE_NL = 'nl';
    /**
     * Constant for value 'en'
     * @return string 'en'
     */
    const VALUE_EN = 'en';
    /**
     * Constant for value 'et'
     * @return string 'et'
     */
    const VALUE_ET = 'et';
    /**
     * Constant for value 'fi'
     * @return string 'fi'
     */
    const VALUE_FI = 'fi';
    /**
     * Constant for value 'fr'
     * @return string 'fr'
     */
    const VALUE_FR = 'fr';
    /**
     * Constant for value 'de'
     * @return string 'de'
     */
    const VALUE_DE = 'de';
    /**
     * Constant for value 'el'
     * @return string 'el'
     */
    const VALUE_EL = 'el';
    /**
     * Constant for value 'hu'
     * @return string 'hu'
     */
    const VALUE_HU = 'hu';
    /**
     * Constant for value 'ga'
     * @return string 'ga'
     */
    const VALUE_GA = 'ga';
    /**
     * Constant for value 'it'
     * @return string 'it'
     */
    const VALUE_IT = 'it';
    /**
     * Constant for value 'lv'
     * @return string 'lv'
     */
    const VALUE_LV = 'lv';
    /**
     * Constant for value 'lt'
     * @return string 'lt'
     */
    const VALUE_LT = 'lt';
    /**
     * Constant for value 'mt'
     * @return string 'mt'
     */
    const VALUE_MT = 'mt';
    /**
     * Constant for value 'pl'
     * @return string 'pl'
     */
    const VALUE_PL = 'pl';
    /**
     * Constant for value 'pt'
     * @return string 'pt'
     */
    const VALUE_PT = 'pt';
    /**
     * Constant for value 'ro'
     * @return string 'ro'
     */
    const VALUE_RO = 'ro';
    /**
     * Constant for value 'sk'
     * @return string 'sk'
     */
    const VALUE_SK = 'sk';
    /**
     * Constant for value 'sl'
     * @return string 'sl'
     */
    const VALUE_SL = 'sl';
    /**
     * Constant for value 'es'
     * @return string 'es'
     */
    const VALUE_ES = 'es';
    /**
     * Constant for value 'sv'
     * @return string 'sv'
     */
    const VALUE_SV = 'sv';
    /**
     * Constant for value 'hr'
     * @return string 'hr'
     */
    const VALUE_HR = 'hr';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BG
     * @uses self::VALUE_CS
     * @uses self::VALUE_DA
     * @uses self::VALUE_NL
     * @uses self::VALUE_EN
     * @uses self::VALUE_ET
     * @uses self::VALUE_FI
     * @uses self::VALUE_FR
     * @uses self::VALUE_DE
     * @uses self::VALUE_EL
     * @uses self::VALUE_HU
     * @uses self::VALUE_GA
     * @uses self::VALUE_IT
     * @uses self::VALUE_LV
     * @uses self::VALUE_LT
     * @uses self::VALUE_MT
     * @uses self::VALUE_PL
     * @uses self::VALUE_PT
     * @uses self::VALUE_RO
     * @uses self::VALUE_SK
     * @uses self::VALUE_SL
     * @uses self::VALUE_ES
     * @uses self::VALUE_SV
     * @uses self::VALUE_HR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BG,
            self::VALUE_CS,
            self::VALUE_DA,
            self::VALUE_NL,
            self::VALUE_EN,
            self::VALUE_ET,
            self::VALUE_FI,
            self::VALUE_FR,
            self::VALUE_DE,
            self::VALUE_EL,
            self::VALUE_HU,
            self::VALUE_GA,
            self::VALUE_IT,
            self::VALUE_LV,
            self::VALUE_LT,
            self::VALUE_MT,
            self::VALUE_PL,
            self::VALUE_PT,
            self::VALUE_RO,
            self::VALUE_SK,
            self::VALUE_SL,
            self::VALUE_ES,
            self::VALUE_SV,
            self::VALUE_HR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
