<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'dateType' => '\\StructType\\DateType',
            'conceptType' => '\\StructType\\ConceptType',
            'fallbackLabel' => '\\StructType\\FallbackLabel',
            'referenceType' => '\\StructType\\ReferenceType',
            'documentType' => '\\StructType\\DocumentType',
            'CONTENT_URL' => '\\StructType\\CONTENT_URL',
            'NOTICE' => '\\StructType\\NOTICE',
            'workType' => '\\StructType\\WorkType',
            'manifestationType' => '\\StructType\\ManifestationType',
            'expressionType' => '\\StructType\\ExpressionType',
            'inverseType' => '\\StructType\\InverseType',
            'dossierType' => '\\StructType\\DossierType',
            'eventType' => '\\StructType\\EventType',
            'URI' => '\\StructType\\URI',
            'EMBEDDED_NOTICEType' => '\\StructType\\EMBEDDED_NOTICEType',
            'embeddedExpressionType' => '\\StructType\\EmbeddedExpressionType',
            'embeddedAgentType' => '\\StructType\\EmbeddedAgentType',
            'embeddedDossierType' => '\\StructType\\EmbeddedDossierType',
            'embeddedManifestationType' => '\\StructType\\EmbeddedManifestationType',
            'embeddedWorkType' => '\\StructType\\EmbeddedWorkType',
            'Literal' => '\\StructType\\Literal',
            'Date' => '\\StructType\\Date',
            'Concept' => '\\StructType\\Concept',
            'FALLBACK' => '\\StructType\\FALLBACK',
            'SAMEAS' => '\\StructType\\SAMEAS',
            'Relation' => '\\StructType\\Relation',
            'ANNOTATION' => '\\StructType\\ANNOTATION',
            'MANIFESTATION_HAS_ITEM' => '\\StructType\\MANIFESTATION_HAS_ITEM',
            'WORK_IS_ABOUT_CONCEPT_EUROVOC' => '\\StructType\\WORK_IS_ABOUT_CONCEPT_EUROVOC',
            'RESOURCE_LEGAL_IS_ABOUT_SUBJECT-MATTER' => '\\StructType\\RESOURCE_LEGAL_IS_ABOUT_SUBJECT_MATTER',
            'RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY-CODE' => '\\StructType\\RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE',
            'CASE-LAW_IS_ABOUT_CONCEPT.MEMBERLIST' => '\\StructType\\CASE_LAW_IS_ABOUT_CONCEPT_MEMBERLIST',
            'CASE-LAW_IS_ABOUT_CONCEPT' => '\\StructType\\CASE_LAW_IS_ABOUT_CONCEPT',
            'CASE-LAW_IS_ABOUT_CONCEPT_NEW_CASE-LAW' => '\\StructType\\CASE_LAW_IS_ABOUT_CONCEPT_NEW_CASE_LAW',
            'CASE-LAW_IS_ABOUT_CONCEPT_CASE-LAW' => '\\StructType\\CASE_LAW_IS_ABOUT_CONCEPT_CASE_LAW',
            'DOSSIER_IS_ABOUT_CONCEPT_DIRECTORY-CODE' => '\\StructType\\DOSSIER_IS_ABOUT_CONCEPT_DIRECTORY_CODE',
            'DOSSIER_IS_ABOUT_CONCEPT_EUROVOC' => '\\StructType\\DOSSIER_IS_ABOUT_CONCEPT_EUROVOC',
            'faultBean' => '\\StructType\\FaultBean',
            'searchRequest' => '\\StructType\\SearchRequest',
            'searchResults' => '\\StructType\\SearchResults',
            'resultType' => '\\StructType\\ResultType',
            'document_link' => '\\StructType\\Document_link',
            'resultWarning' => '\\StructType\\ResultWarning',
            'fault' => '\\StructType\\Fault',
        );
    }
}
