<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OkToProceed StructType
 * @subpackage Structs
 */
class OkToProceed extends AbstractStructBase
{
    /**
     * The RequestId
     * Meta informations extracted from the WSDL
     * - documentation: Request id
     * - maxLength: 13
     * @var string
     */
    public $RequestId;
    /**
     * The ZIDVER
     * Meta informations extracted from the WSDL
     * - maxLength: 3
     * @var string
     */
    public $ZIDVER;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxLength: 1
     * @var string
     */
    public $Type;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The RequestDT
     * Meta informations extracted from the WSDL
     * - length: 8
     * @var string
     */
    public $RequestDT;
    /**
     * The RequestTM
     * Meta informations extracted from the WSDL
     * - length: 6
     * @var string
     */
    public $RequestTM;
    /**
     * Constructor method for OkToProceed
     * @uses OkToProceed::setRequestId()
     * @uses OkToProceed::setZIDVER()
     * @uses OkToProceed::setType()
     * @uses OkToProceed::setComment()
     * @uses OkToProceed::setRequestDT()
     * @uses OkToProceed::setRequestTM()
     * @param string $requestId
     * @param string $zIDVER
     * @param string $type
     * @param string $comment
     * @param string $requestDT
     * @param string $requestTM
     */
    public function __construct($requestId = null, $zIDVER = null, $type = null, $comment = null, $requestDT = null, $requestTM = null)
    {
        $this
            ->setRequestId($requestId)
            ->setZIDVER($zIDVER)
            ->setType($type)
            ->setComment($comment)
            ->setRequestDT($requestDT)
            ->setRequestTM($requestTM);
    }
    /**
     * Get RequestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->RequestId;
    }
    /**
     * Set RequestId value
     * @param string $requestId
     * @return \StructType\OkToProceed
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestId) && strlen($requestId) > 13) || (is_array($requestId) && count($requestId) > 13)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at most, "%d" length given', is_scalar($requestId) ? strlen($requestId) : count($requestId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->RequestId = $requestId;
        return $this;
    }
    /**
     * Get ZIDVER value
     * @return string|null
     */
    public function getZIDVER()
    {
        return $this->ZIDVER;
    }
    /**
     * Set ZIDVER value
     * @param string $zIDVER
     * @return \StructType\OkToProceed
     */
    public function setZIDVER($zIDVER = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zIDVER) && strlen($zIDVER) > 3) || (is_array($zIDVER) && count($zIDVER) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($zIDVER) ? strlen($zIDVER) : count($zIDVER)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zIDVER) && !is_string($zIDVER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zIDVER)), __LINE__);
        }
        $this->ZIDVER = $zIDVER;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\OkToProceed
     */
    public function setType($type = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($type) && strlen($type) > 1) || (is_array($type) && count($type) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($type) ? strlen($type) : count($type)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\OkToProceed
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get RequestDT value
     * @return string|null
     */
    public function getRequestDT()
    {
        return $this->RequestDT;
    }
    /**
     * Set RequestDT value
     * @param string $requestDT
     * @return \StructType\OkToProceed
     */
    public function setRequestDT($requestDT = null)
    {
        // validation for constraint: length
        if ((is_scalar($requestDT) && strlen($requestDT) !== 8) || (is_array($requestDT) && count($requestDT) !== 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestDT) && !is_string($requestDT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestDT)), __LINE__);
        }
        $this->RequestDT = $requestDT;
        return $this;
    }
    /**
     * Get RequestTM value
     * @return string|null
     */
    public function getRequestTM()
    {
        return $this->RequestTM;
    }
    /**
     * Set RequestTM value
     * @param string $requestTM
     * @return \StructType\OkToProceed
     */
    public function setRequestTM($requestTM = null)
    {
        // validation for constraint: length
        if ((is_scalar($requestTM) && strlen($requestTM) !== 6) || (is_array($requestTM) && count($requestTM) !== 6)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTM) && !is_string($requestTM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTM)), __LINE__);
        }
        $this->RequestTM = $requestTM;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OkToProceed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
