<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ok ServiceType
 * @subpackage Services
 */
class Ok extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OkToProceed
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OkToProceed $okToProceed_msg
     * @return void|bool
     */
    public function OkToProceed(\StructType\OkToProceed $okToProceed_msg)
    {
        try {
            $this->setResult(self::getSoapClient()->OkToProceed($okToProceed_msg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
