<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Initial ServiceType
 * @subpackage Services
 */
class Initial extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InitialRequest_outAsyn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InitialRequest $initialRequest_msg
     * @return void|bool
     */
    public function InitialRequest_outAsyn(\StructType\InitialRequest $initialRequest_msg)
    {
        try {
            $this->setResult(self::getSoapClient()->InitialRequest_outAsyn($initialRequest_msg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
