<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistributionList StructType
 * @subpackage Structs
 */
class DistributionList extends AbstractStructBase
{
    /**
     * The item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Emailitem[]
     */
    public $item;
    /**
     * Constructor method for DistributionList
     * @uses DistributionList::setItem()
     * @param \StructType\Emailitem[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get item value
     * @return \StructType\Emailitem[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\Emailitem[] $item
     * @return \StructType\DistributionList
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $distributionListItemItem) {
            // validation for constraint: itemType
            if (!$distributionListItemItem instanceof \StructType\Emailitem) {
                throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\Emailitem, "%s" given', is_object($distributionListItemItem) ? get_class($distributionListItemItem) : gettype($distributionListItemItem)), __LINE__);
            }
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\Emailitem $item
     * @return \StructType\DistributionList
     */
    public function addToItem(\StructType\Emailitem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Emailitem) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\Emailitem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistributionList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
