<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketHistoryGet StructType
 * Meta informations extracted from the WSDL
 * - documentation: UserLogin or SessionID is mandatory
 * @subpackage Structs
 */
class TicketHistoryGet extends AbstractStructBase
{
    /**
     * The TicketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var int[]
     */
    public $TicketID;
    /**
     * The UserLogin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UserLogin;
    /**
     * The SessionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SessionID;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for TicketHistoryGet
     * @uses TicketHistoryGet::setTicketID()
     * @uses TicketHistoryGet::setUserLogin()
     * @uses TicketHistoryGet::setSessionID()
     * @uses TicketHistoryGet::setPassword()
     * @param int[] $ticketID
     * @param string $userLogin
     * @param string $sessionID
     * @param string $password
     */
    public function __construct(array $ticketID = array(), $userLogin = null, $sessionID = null, $password = null)
    {
        $this
            ->setTicketID($ticketID)
            ->setUserLogin($userLogin)
            ->setSessionID($sessionID)
            ->setPassword($password);
    }
    /**
     * Get TicketID value
     * @return int[]
     */
    public function getTicketID()
    {
        return $this->TicketID;
    }
    /**
     * Set TicketID value
     * @throws \InvalidArgumentException
     * @param int[] $ticketID
     * @return \StructType\TicketHistoryGet
     */
    public function setTicketID(array $ticketID = array())
    {
        foreach ($ticketID as $ticketHistoryGetTicketIDItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketHistoryGetTicketIDItem)) {
                throw new \InvalidArgumentException(sprintf('The TicketID property can only contain items of positiveInteger, "%s" given', is_object($ticketHistoryGetTicketIDItem) ? get_class($ticketHistoryGetTicketIDItem) : gettype($ticketHistoryGetTicketIDItem)), __LINE__);
            }
        }
        $this->TicketID = $ticketID;
        return $this;
    }
    /**
     * Add item to TicketID value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketHistoryGet
     */
    public function addToTicketID($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The TicketID property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketID[] = $item;
        return $this;
    }
    /**
     * Get UserLogin value
     * @return string|null
     */
    public function getUserLogin()
    {
        return $this->UserLogin;
    }
    /**
     * Set UserLogin value
     * @param string $userLogin
     * @return \StructType\TicketHistoryGet
     */
    public function setUserLogin($userLogin = null)
    {
        // validation for constraint: string
        if (!is_null($userLogin) && !is_string($userLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLogin)), __LINE__);
        }
        $this->UserLogin = $userLogin;
        return $this;
    }
    /**
     * Get SessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->SessionID;
    }
    /**
     * Set SessionID value
     * @param string $sessionID
     * @return \StructType\TicketHistoryGet
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionID)), __LINE__);
        }
        $this->SessionID = $sessionID;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\TicketHistoryGet
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketHistoryGet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
