<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketGet StructType
 * Meta informations extracted from the WSDL
 * - documentation: UserLogin, CustomerUserLogin or SessionID is mandatory
 * @subpackage Structs
 */
class TicketGet extends AbstractStructBase
{
    /**
     * The TicketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var int[]
     */
    public $TicketID;
    /**
     * The UserLogin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UserLogin;
    /**
     * The CustomerUserLogin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerUserLogin;
    /**
     * The SessionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SessionID;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The DynamicFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $DynamicFields;
    /**
     * The Extended
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Extended;
    /**
     * The AllArticles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AllArticles;
    /**
     * The ArticleSenderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArticleSenderType;
    /**
     * The ArticleOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArticleOrder;
    /**
     * The ArticleLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ArticleLimit;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Attachments;
    /**
     * The GetAttachmentContents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $GetAttachmentContents;
    /**
     * The HTMLBodyAsAttachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $HTMLBodyAsAttachment;
    /**
     * Constructor method for TicketGet
     * @uses TicketGet::setTicketID()
     * @uses TicketGet::setUserLogin()
     * @uses TicketGet::setCustomerUserLogin()
     * @uses TicketGet::setSessionID()
     * @uses TicketGet::setPassword()
     * @uses TicketGet::setDynamicFields()
     * @uses TicketGet::setExtended()
     * @uses TicketGet::setAllArticles()
     * @uses TicketGet::setArticleSenderType()
     * @uses TicketGet::setArticleOrder()
     * @uses TicketGet::setArticleLimit()
     * @uses TicketGet::setAttachments()
     * @uses TicketGet::setGetAttachmentContents()
     * @uses TicketGet::setHTMLBodyAsAttachment()
     * @param int[] $ticketID
     * @param string $userLogin
     * @param string $customerUserLogin
     * @param string $sessionID
     * @param string $password
     * @param int $dynamicFields
     * @param int $extended
     * @param int $allArticles
     * @param string $articleSenderType
     * @param string $articleOrder
     * @param int $articleLimit
     * @param int $attachments
     * @param int $getAttachmentContents
     * @param int $hTMLBodyAsAttachment
     */
    public function __construct(array $ticketID = array(), $userLogin = null, $customerUserLogin = null, $sessionID = null, $password = null, $dynamicFields = null, $extended = null, $allArticles = null, $articleSenderType = null, $articleOrder = null, $articleLimit = null, $attachments = null, $getAttachmentContents = null, $hTMLBodyAsAttachment = null)
    {
        $this
            ->setTicketID($ticketID)
            ->setUserLogin($userLogin)
            ->setCustomerUserLogin($customerUserLogin)
            ->setSessionID($sessionID)
            ->setPassword($password)
            ->setDynamicFields($dynamicFields)
            ->setExtended($extended)
            ->setAllArticles($allArticles)
            ->setArticleSenderType($articleSenderType)
            ->setArticleOrder($articleOrder)
            ->setArticleLimit($articleLimit)
            ->setAttachments($attachments)
            ->setGetAttachmentContents($getAttachmentContents)
            ->setHTMLBodyAsAttachment($hTMLBodyAsAttachment);
    }
    /**
     * Get TicketID value
     * @return int[]
     */
    public function getTicketID()
    {
        return $this->TicketID;
    }
    /**
     * Set TicketID value
     * @throws \InvalidArgumentException
     * @param int[] $ticketID
     * @return \StructType\TicketGet
     */
    public function setTicketID(array $ticketID = array())
    {
        foreach ($ticketID as $ticketGetTicketIDItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketGetTicketIDItem)) {
                throw new \InvalidArgumentException(sprintf('The TicketID property can only contain items of positiveInteger, "%s" given', is_object($ticketGetTicketIDItem) ? get_class($ticketGetTicketIDItem) : gettype($ticketGetTicketIDItem)), __LINE__);
            }
        }
        $this->TicketID = $ticketID;
        return $this;
    }
    /**
     * Add item to TicketID value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketGet
     */
    public function addToTicketID($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The TicketID property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketID[] = $item;
        return $this;
    }
    /**
     * Get UserLogin value
     * @return string|null
     */
    public function getUserLogin()
    {
        return $this->UserLogin;
    }
    /**
     * Set UserLogin value
     * @param string $userLogin
     * @return \StructType\TicketGet
     */
    public function setUserLogin($userLogin = null)
    {
        // validation for constraint: string
        if (!is_null($userLogin) && !is_string($userLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLogin)), __LINE__);
        }
        $this->UserLogin = $userLogin;
        return $this;
    }
    /**
     * Get CustomerUserLogin value
     * @return string|null
     */
    public function getCustomerUserLogin()
    {
        return $this->CustomerUserLogin;
    }
    /**
     * Set CustomerUserLogin value
     * @param string $customerUserLogin
     * @return \StructType\TicketGet
     */
    public function setCustomerUserLogin($customerUserLogin = null)
    {
        // validation for constraint: string
        if (!is_null($customerUserLogin) && !is_string($customerUserLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerUserLogin)), __LINE__);
        }
        $this->CustomerUserLogin = $customerUserLogin;
        return $this;
    }
    /**
     * Get SessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->SessionID;
    }
    /**
     * Set SessionID value
     * @param string $sessionID
     * @return \StructType\TicketGet
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionID)), __LINE__);
        }
        $this->SessionID = $sessionID;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\TicketGet
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get DynamicFields value
     * @return int|null
     */
    public function getDynamicFields()
    {
        return $this->DynamicFields;
    }
    /**
     * Set DynamicFields value
     * @param int $dynamicFields
     * @return \StructType\TicketGet
     */
    public function setDynamicFields($dynamicFields = null)
    {
        // validation for constraint: int
        if (!is_null($dynamicFields) && !is_numeric($dynamicFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dynamicFields)), __LINE__);
        }
        $this->DynamicFields = $dynamicFields;
        return $this;
    }
    /**
     * Get Extended value
     * @return int|null
     */
    public function getExtended()
    {
        return $this->Extended;
    }
    /**
     * Set Extended value
     * @param int $extended
     * @return \StructType\TicketGet
     */
    public function setExtended($extended = null)
    {
        // validation for constraint: int
        if (!is_null($extended) && !is_numeric($extended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($extended)), __LINE__);
        }
        $this->Extended = $extended;
        return $this;
    }
    /**
     * Get AllArticles value
     * @return int|null
     */
    public function getAllArticles()
    {
        return $this->AllArticles;
    }
    /**
     * Set AllArticles value
     * @param int $allArticles
     * @return \StructType\TicketGet
     */
    public function setAllArticles($allArticles = null)
    {
        // validation for constraint: int
        if (!is_null($allArticles) && !is_numeric($allArticles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($allArticles)), __LINE__);
        }
        $this->AllArticles = $allArticles;
        return $this;
    }
    /**
     * Get ArticleSenderType value
     * @return string|null
     */
    public function getArticleSenderType()
    {
        return $this->ArticleSenderType;
    }
    /**
     * Set ArticleSenderType value
     * @param string $articleSenderType
     * @return \StructType\TicketGet
     */
    public function setArticleSenderType($articleSenderType = null)
    {
        // validation for constraint: string
        if (!is_null($articleSenderType) && !is_string($articleSenderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($articleSenderType)), __LINE__);
        }
        $this->ArticleSenderType = $articleSenderType;
        return $this;
    }
    /**
     * Get ArticleOrder value
     * @return string|null
     */
    public function getArticleOrder()
    {
        return $this->ArticleOrder;
    }
    /**
     * Set ArticleOrder value
     * @param string $articleOrder
     * @return \StructType\TicketGet
     */
    public function setArticleOrder($articleOrder = null)
    {
        // validation for constraint: string
        if (!is_null($articleOrder) && !is_string($articleOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($articleOrder)), __LINE__);
        }
        $this->ArticleOrder = $articleOrder;
        return $this;
    }
    /**
     * Get ArticleLimit value
     * @return int|null
     */
    public function getArticleLimit()
    {
        return $this->ArticleLimit;
    }
    /**
     * Set ArticleLimit value
     * @param int $articleLimit
     * @return \StructType\TicketGet
     */
    public function setArticleLimit($articleLimit = null)
    {
        // validation for constraint: int
        if (!is_null($articleLimit) && !is_numeric($articleLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($articleLimit)), __LINE__);
        }
        $this->ArticleLimit = $articleLimit;
        return $this;
    }
    /**
     * Get Attachments value
     * @return int|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @param int $attachments
     * @return \StructType\TicketGet
     */
    public function setAttachments($attachments = null)
    {
        // validation for constraint: int
        if (!is_null($attachments) && !is_numeric($attachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($attachments)), __LINE__);
        }
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Get GetAttachmentContents value
     * @return int|null
     */
    public function getGetAttachmentContents()
    {
        return $this->GetAttachmentContents;
    }
    /**
     * Set GetAttachmentContents value
     * @param int $getAttachmentContents
     * @return \StructType\TicketGet
     */
    public function setGetAttachmentContents($getAttachmentContents = null)
    {
        // validation for constraint: int
        if (!is_null($getAttachmentContents) && !is_numeric($getAttachmentContents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($getAttachmentContents)), __LINE__);
        }
        $this->GetAttachmentContents = $getAttachmentContents;
        return $this;
    }
    /**
     * Get HTMLBodyAsAttachment value
     * @return int|null
     */
    public function getHTMLBodyAsAttachment()
    {
        return $this->HTMLBodyAsAttachment;
    }
    /**
     * Set HTMLBodyAsAttachment value
     * @param int $hTMLBodyAsAttachment
     * @return \StructType\TicketGet
     */
    public function setHTMLBodyAsAttachment($hTMLBodyAsAttachment = null)
    {
        // validation for constraint: int
        if (!is_null($hTMLBodyAsAttachment) && !is_numeric($hTMLBodyAsAttachment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hTMLBodyAsAttachment)), __LINE__);
        }
        $this->HTMLBodyAsAttachment = $hTMLBodyAsAttachment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketGet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
