<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketCreateResponse StructType
 * @subpackage Structs
 */
class TicketCreateResponse extends AbstractStructBase
{
    /**
     * The TicketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketID;
    /**
     * The TicketNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $TicketNumber;
    /**
     * The ArticleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ArticleID;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OTRS_Error
     */
    public $Error;
    /**
     * Constructor method for TicketCreateResponse
     * @uses TicketCreateResponse::setTicketID()
     * @uses TicketCreateResponse::setTicketNumber()
     * @uses TicketCreateResponse::setArticleID()
     * @uses TicketCreateResponse::setError()
     * @param int $ticketID
     * @param string $ticketNumber
     * @param int $articleID
     * @param \StructType\OTRS_Error $error
     */
    public function __construct($ticketID = null, $ticketNumber = null, $articleID = null, \StructType\OTRS_Error $error = null)
    {
        $this
            ->setTicketID($ticketID)
            ->setTicketNumber($ticketNumber)
            ->setArticleID($articleID)
            ->setError($error);
    }
    /**
     * Get TicketID value
     * @return int
     */
    public function getTicketID()
    {
        return $this->TicketID;
    }
    /**
     * Set TicketID value
     * @param int $ticketID
     * @return \StructType\TicketCreateResponse
     */
    public function setTicketID($ticketID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketID) && !is_numeric($ticketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketID)), __LINE__);
        }
        $this->TicketID = $ticketID;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \StructType\TicketCreateResponse
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get ArticleID value
     * @return int
     */
    public function getArticleID()
    {
        return $this->ArticleID;
    }
    /**
     * Set ArticleID value
     * @param int $articleID
     * @return \StructType\TicketCreateResponse
     */
    public function setArticleID($articleID = null)
    {
        // validation for constraint: int
        if (!is_null($articleID) && !is_numeric($articleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($articleID)), __LINE__);
        }
        $this->ArticleID = $articleID;
        return $this;
    }
    /**
     * Get Error value
     * @return \StructType\OTRS_Error|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param \StructType\OTRS_Error $error
     * @return \StructType\TicketCreateResponse
     */
    public function setError(\StructType\OTRS_Error $error = null)
    {
        $this->Error = $error;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketCreateResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
