<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketCreate StructType
 * Meta informations extracted from the WSDL
 * - documentation: UserLogin, CustomerUserLogin or SessionID is mandatory
 * @subpackage Structs
 */
class TicketCreate extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OTRS_TicketCreate_Ticket
     */
    public $Ticket;
    /**
     * The Article
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OTRS_Article
     */
    public $Article;
    /**
     * The UserLogin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UserLogin;
    /**
     * The CustomerUserLogin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerUserLogin;
    /**
     * The SessionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SessionID;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The DynamicField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OTRS_DynamicField[]
     */
    public $DynamicField;
    /**
     * The Attachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OTRS_Attachment[]
     */
    public $Attachment;
    /**
     * Constructor method for TicketCreate
     * @uses TicketCreate::setTicket()
     * @uses TicketCreate::setArticle()
     * @uses TicketCreate::setUserLogin()
     * @uses TicketCreate::setCustomerUserLogin()
     * @uses TicketCreate::setSessionID()
     * @uses TicketCreate::setPassword()
     * @uses TicketCreate::setDynamicField()
     * @uses TicketCreate::setAttachment()
     * @param \StructType\OTRS_TicketCreate_Ticket $ticket
     * @param \StructType\OTRS_Article $article
     * @param string $userLogin
     * @param string $customerUserLogin
     * @param string $sessionID
     * @param string $password
     * @param \StructType\OTRS_DynamicField[] $dynamicField
     * @param \StructType\OTRS_Attachment[] $attachment
     */
    public function __construct(\StructType\OTRS_TicketCreate_Ticket $ticket = null, \StructType\OTRS_Article $article = null, $userLogin = null, $customerUserLogin = null, $sessionID = null, $password = null, array $dynamicField = array(), array $attachment = array())
    {
        $this
            ->setTicket($ticket)
            ->setArticle($article)
            ->setUserLogin($userLogin)
            ->setCustomerUserLogin($customerUserLogin)
            ->setSessionID($sessionID)
            ->setPassword($password)
            ->setDynamicField($dynamicField)
            ->setAttachment($attachment);
    }
    /**
     * Get Ticket value
     * @return \StructType\OTRS_TicketCreate_Ticket
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param \StructType\OTRS_TicketCreate_Ticket $ticket
     * @return \StructType\TicketCreate
     */
    public function setTicket(\StructType\OTRS_TicketCreate_Ticket $ticket = null)
    {
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get Article value
     * @return \StructType\OTRS_Article
     */
    public function getArticle()
    {
        return $this->Article;
    }
    /**
     * Set Article value
     * @param \StructType\OTRS_Article $article
     * @return \StructType\TicketCreate
     */
    public function setArticle(\StructType\OTRS_Article $article = null)
    {
        $this->Article = $article;
        return $this;
    }
    /**
     * Get UserLogin value
     * @return string|null
     */
    public function getUserLogin()
    {
        return $this->UserLogin;
    }
    /**
     * Set UserLogin value
     * @param string $userLogin
     * @return \StructType\TicketCreate
     */
    public function setUserLogin($userLogin = null)
    {
        // validation for constraint: string
        if (!is_null($userLogin) && !is_string($userLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLogin)), __LINE__);
        }
        $this->UserLogin = $userLogin;
        return $this;
    }
    /**
     * Get CustomerUserLogin value
     * @return string|null
     */
    public function getCustomerUserLogin()
    {
        return $this->CustomerUserLogin;
    }
    /**
     * Set CustomerUserLogin value
     * @param string $customerUserLogin
     * @return \StructType\TicketCreate
     */
    public function setCustomerUserLogin($customerUserLogin = null)
    {
        // validation for constraint: string
        if (!is_null($customerUserLogin) && !is_string($customerUserLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerUserLogin)), __LINE__);
        }
        $this->CustomerUserLogin = $customerUserLogin;
        return $this;
    }
    /**
     * Get SessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->SessionID;
    }
    /**
     * Set SessionID value
     * @param string $sessionID
     * @return \StructType\TicketCreate
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionID)), __LINE__);
        }
        $this->SessionID = $sessionID;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\TicketCreate
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get DynamicField value
     * @return \StructType\OTRS_DynamicField[]|null
     */
    public function getDynamicField()
    {
        return $this->DynamicField;
    }
    /**
     * Set DynamicField value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_DynamicField[] $dynamicField
     * @return \StructType\TicketCreate
     */
    public function setDynamicField(array $dynamicField = array())
    {
        foreach ($dynamicField as $ticketCreateDynamicFieldItem) {
            // validation for constraint: itemType
            if (!$ticketCreateDynamicFieldItem instanceof \StructType\OTRS_DynamicField) {
                throw new \InvalidArgumentException(sprintf('The DynamicField property can only contain items of \StructType\OTRS_DynamicField, "%s" given', is_object($ticketCreateDynamicFieldItem) ? get_class($ticketCreateDynamicFieldItem) : gettype($ticketCreateDynamicFieldItem)), __LINE__);
            }
        }
        $this->DynamicField = $dynamicField;
        return $this;
    }
    /**
     * Add item to DynamicField value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_DynamicField $item
     * @return \StructType\TicketCreate
     */
    public function addToDynamicField(\StructType\OTRS_DynamicField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OTRS_DynamicField) {
            throw new \InvalidArgumentException(sprintf('The DynamicField property can only contain items of \StructType\OTRS_DynamicField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DynamicField[] = $item;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \StructType\OTRS_Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_Attachment[] $attachment
     * @return \StructType\TicketCreate
     */
    public function setAttachment(array $attachment = array())
    {
        foreach ($attachment as $ticketCreateAttachmentItem) {
            // validation for constraint: itemType
            if (!$ticketCreateAttachmentItem instanceof \StructType\OTRS_Attachment) {
                throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of \StructType\OTRS_Attachment, "%s" given', is_object($ticketCreateAttachmentItem) ? get_class($ticketCreateAttachmentItem) : gettype($ticketCreateAttachmentItem)), __LINE__);
            }
        }
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Add item to Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_Attachment $item
     * @return \StructType\TicketCreate
     */
    public function addToAttachment(\StructType\OTRS_Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OTRS_Attachment) {
            throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of \StructType\OTRS_Attachment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attachment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketCreate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
