<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SessionCreateResponse StructType
 * @subpackage Structs
 */
class SessionCreateResponse extends AbstractStructBase
{
    /**
     * The SessionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SessionID;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OTRS_Error
     */
    public $Error;
    /**
     * Constructor method for SessionCreateResponse
     * @uses SessionCreateResponse::setSessionID()
     * @uses SessionCreateResponse::setError()
     * @param string $sessionID
     * @param \StructType\OTRS_Error $error
     */
    public function __construct($sessionID = null, \StructType\OTRS_Error $error = null)
    {
        $this
            ->setSessionID($sessionID)
            ->setError($error);
    }
    /**
     * Get SessionID value
     * @return string
     */
    public function getSessionID()
    {
        return $this->SessionID;
    }
    /**
     * Set SessionID value
     * @param string $sessionID
     * @return \StructType\SessionCreateResponse
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionID)), __LINE__);
        }
        $this->SessionID = $sessionID;
        return $this;
    }
    /**
     * Get Error value
     * @return \StructType\OTRS_Error|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param \StructType\OTRS_Error $error
     * @return \StructType\SessionCreateResponse
     */
    public function setError(\StructType\OTRS_Error $error = null)
    {
        $this->Error = $error;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SessionCreateResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
