<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SessionCreate StructType
 * Meta informations extracted from the WSDL
 * - documentation: UserLogin or CustomerUserLogin is mandatory.
 * @subpackage Structs
 */
class SessionCreate extends AbstractStructBase
{
    /**
     * The UserLogin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UserLogin;
    /**
     * The CustomerUserLogin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerUserLogin;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for SessionCreate
     * @uses SessionCreate::setUserLogin()
     * @uses SessionCreate::setCustomerUserLogin()
     * @uses SessionCreate::setPassword()
     * @param string $userLogin
     * @param string $customerUserLogin
     * @param string $password
     */
    public function __construct($userLogin = null, $customerUserLogin = null, $password = null)
    {
        $this
            ->setUserLogin($userLogin)
            ->setCustomerUserLogin($customerUserLogin)
            ->setPassword($password);
    }
    /**
     * Get UserLogin value
     * @return string|null
     */
    public function getUserLogin()
    {
        return $this->UserLogin;
    }
    /**
     * Set UserLogin value
     * @param string $userLogin
     * @return \StructType\SessionCreate
     */
    public function setUserLogin($userLogin = null)
    {
        // validation for constraint: string
        if (!is_null($userLogin) && !is_string($userLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLogin)), __LINE__);
        }
        $this->UserLogin = $userLogin;
        return $this;
    }
    /**
     * Get CustomerUserLogin value
     * @return string|null
     */
    public function getCustomerUserLogin()
    {
        return $this->CustomerUserLogin;
    }
    /**
     * Set CustomerUserLogin value
     * @param string $customerUserLogin
     * @return \StructType\SessionCreate
     */
    public function setCustomerUserLogin($customerUserLogin = null)
    {
        // validation for constraint: string
        if (!is_null($customerUserLogin) && !is_string($customerUserLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerUserLogin)), __LINE__);
        }
        $this->CustomerUserLogin = $customerUserLogin;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\SessionCreate
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SessionCreate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
