<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTRS_TicketGetResponse_Attachment StructType
 * @subpackage Structs
 */
class OTRS_TicketGetResponse_Attachment extends AbstractStructBase
{
    /**
     * The FileID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FileID;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Content;
    /**
     * The ContentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ContentType;
    /**
     * The Filename
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Filename;
    /**
     * The Filesize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Filesize;
    /**
     * The FilesizeRaw
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FilesizeRaw;
    /**
     * The ContentAlternative
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentAlternative;
    /**
     * The ContentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentID;
    /**
     * Constructor method for OTRS_TicketGetResponse_Attachment
     * @uses OTRS_TicketGetResponse_Attachment::setFileID()
     * @uses OTRS_TicketGetResponse_Attachment::setContent()
     * @uses OTRS_TicketGetResponse_Attachment::setContentType()
     * @uses OTRS_TicketGetResponse_Attachment::setFilename()
     * @uses OTRS_TicketGetResponse_Attachment::setFilesize()
     * @uses OTRS_TicketGetResponse_Attachment::setFilesizeRaw()
     * @uses OTRS_TicketGetResponse_Attachment::setContentAlternative()
     * @uses OTRS_TicketGetResponse_Attachment::setContentID()
     * @param int $fileID
     * @param string $content
     * @param string $contentType
     * @param string $filename
     * @param string $filesize
     * @param string $filesizeRaw
     * @param string $contentAlternative
     * @param string $contentID
     */
    public function __construct($fileID = null, $content = null, $contentType = null, $filename = null, $filesize = null, $filesizeRaw = null, $contentAlternative = null, $contentID = null)
    {
        $this
            ->setFileID($fileID)
            ->setContent($content)
            ->setContentType($contentType)
            ->setFilename($filename)
            ->setFilesize($filesize)
            ->setFilesizeRaw($filesizeRaw)
            ->setContentAlternative($contentAlternative)
            ->setContentID($contentID);
    }
    /**
     * Get FileID value
     * @return int
     */
    public function getFileID()
    {
        return $this->FileID;
    }
    /**
     * Set FileID value
     * @param int $fileID
     * @return \StructType\OTRS_TicketGetResponse_Attachment
     */
    public function setFileID($fileID = null)
    {
        // validation for constraint: int
        if (!is_null($fileID) && !is_numeric($fileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fileID)), __LINE__);
        }
        $this->FileID = $fileID;
        return $this;
    }
    /**
     * Get Content value
     * @return string
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param string $content
     * @return \StructType\OTRS_TicketGetResponse_Attachment
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Get ContentType value
     * @return string
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \StructType\OTRS_TicketGetResponse_Attachment
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get Filename value
     * @return string
     */
    public function getFilename()
    {
        return $this->Filename;
    }
    /**
     * Set Filename value
     * @param string $filename
     * @return \StructType\OTRS_TicketGetResponse_Attachment
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filename)), __LINE__);
        }
        $this->Filename = $filename;
        return $this;
    }
    /**
     * Get Filesize value
     * @return string
     */
    public function getFilesize()
    {
        return $this->Filesize;
    }
    /**
     * Set Filesize value
     * @param string $filesize
     * @return \StructType\OTRS_TicketGetResponse_Attachment
     */
    public function setFilesize($filesize = null)
    {
        // validation for constraint: string
        if (!is_null($filesize) && !is_string($filesize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filesize)), __LINE__);
        }
        $this->Filesize = $filesize;
        return $this;
    }
    /**
     * Get FilesizeRaw value
     * @return string
     */
    public function getFilesizeRaw()
    {
        return $this->FilesizeRaw;
    }
    /**
     * Set FilesizeRaw value
     * @param string $filesizeRaw
     * @return \StructType\OTRS_TicketGetResponse_Attachment
     */
    public function setFilesizeRaw($filesizeRaw = null)
    {
        // validation for constraint: string
        if (!is_null($filesizeRaw) && !is_string($filesizeRaw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filesizeRaw)), __LINE__);
        }
        $this->FilesizeRaw = $filesizeRaw;
        return $this;
    }
    /**
     * Get ContentAlternative value
     * @return string|null
     */
    public function getContentAlternative()
    {
        return $this->ContentAlternative;
    }
    /**
     * Set ContentAlternative value
     * @param string $contentAlternative
     * @return \StructType\OTRS_TicketGetResponse_Attachment
     */
    public function setContentAlternative($contentAlternative = null)
    {
        // validation for constraint: string
        if (!is_null($contentAlternative) && !is_string($contentAlternative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentAlternative)), __LINE__);
        }
        $this->ContentAlternative = $contentAlternative;
        return $this;
    }
    /**
     * Get ContentID value
     * @return string|null
     */
    public function getContentID()
    {
        return $this->ContentID;
    }
    /**
     * Set ContentID value
     * @param string $contentID
     * @return \StructType\OTRS_TicketGetResponse_Attachment
     */
    public function setContentID($contentID = null)
    {
        // validation for constraint: string
        if (!is_null($contentID) && !is_string($contentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentID)), __LINE__);
        }
        $this->ContentID = $contentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTRS_TicketGetResponse_Attachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
