<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTRS_SessionGetResponse_SessionData StructType
 * @subpackage Structs
 */
class OTRS_SessionGetResponse_SessionData extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Value;
    /**
     * The Serialized
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Serialized;
    /**
     * Constructor method for OTRS_SessionGetResponse_SessionData
     * @uses OTRS_SessionGetResponse_SessionData::setName()
     * @uses OTRS_SessionGetResponse_SessionData::setValue()
     * @uses OTRS_SessionGetResponse_SessionData::setSerialized()
     * @param string $name
     * @param string $value
     * @param int $serialized
     */
    public function __construct($name = null, $value = null, $serialized = null)
    {
        $this
            ->setName($name)
            ->setValue($value)
            ->setSerialized($serialized);
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\OTRS_SessionGetResponse_SessionData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Value value
     * @return string
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\OTRS_SessionGetResponse_SessionData
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Serialized value
     * @return int|null
     */
    public function getSerialized()
    {
        return $this->Serialized;
    }
    /**
     * Set Serialized value
     * @param int $serialized
     * @return \StructType\OTRS_SessionGetResponse_SessionData
     */
    public function setSerialized($serialized = null)
    {
        // validation for constraint: int
        if (!is_null($serialized) && !is_numeric($serialized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serialized)), __LINE__);
        }
        $this->Serialized = $serialized;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTRS_SessionGetResponse_SessionData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
