<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Session ServiceType
 * @subpackage Services
 */
class Session extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SessionCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SessionCreate $parameters
     * @return \StructType\SessionCreateResponse|bool
     */
    public function SessionCreate(\StructType\SessionCreate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SessionCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SessionGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SessionGet $parameters
     * @return \StructType\SessionGetResponse|bool
     */
    public function SessionGet(\StructType\SessionGet $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SessionGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SessionCreateResponse|\StructType\SessionGetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
