<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://raw.githubusercontent.com/OTRS/otrs/master/development/webservices/GenericTicketConnectorSOAP.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://raw.githubusercontent.com/OTRS/otrs/master/development/webservices/GenericTicketConnectorSOAP.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Ticket ServiceType
 */
$ticket = new \ServiceType\Ticket($options);
/**
 * Sample call for TicketCreate operation/method
 */
if ($ticket->TicketCreate(new \StructType\TicketCreate()) !== false) {
    print_r($ticket->getResult());
} else {
    print_r($ticket->getLastError());
}
/**
 * Sample call for TicketUpdate operation/method
 */
if ($ticket->TicketUpdate(new \StructType\TicketUpdate()) !== false) {
    print_r($ticket->getResult());
} else {
    print_r($ticket->getLastError());
}
/**
 * Sample call for TicketGet operation/method
 */
if ($ticket->TicketGet(new \StructType\TicketGet()) !== false) {
    print_r($ticket->getResult());
} else {
    print_r($ticket->getLastError());
}
/**
 * Sample call for TicketSearch operation/method
 */
if ($ticket->TicketSearch(new \StructType\TicketSearch()) !== false) {
    print_r($ticket->getResult());
} else {
    print_r($ticket->getLastError());
}
/**
 * Sample call for TicketHistoryGet operation/method
 */
if ($ticket->TicketHistoryGet(new \StructType\TicketHistoryGet()) !== false) {
    print_r($ticket->getResult());
} else {
    print_r($ticket->getLastError());
}
/**
 * Samples for Session ServiceType
 */
$session = new \ServiceType\Session($options);
/**
 * Sample call for SessionCreate operation/method
 */
if ($session->SessionCreate(new \StructType\SessionCreate()) !== false) {
    print_r($session->getResult());
} else {
    print_r($session->getLastError());
}
/**
 * Sample call for SessionGet operation/method
 */
if ($session->SessionGet(new \StructType\SessionGet()) !== false) {
    print_r($session->getResult());
} else {
    print_r($session->getLastError());
}
