<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketUpdate StructType
 * Meta informations extracted from the WSDL
 * - documentation: UserLogin, CustomerUserLogin or SessionID is mandatory
 * @subpackage Structs
 */
class TicketUpdate extends AbstractStructBase
{
    /**
     * The TicketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketID;
    /**
     * The TicketNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TicketNumber;
    /**
     * The UserLogin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UserLogin;
    /**
     * The CustomerUserLogin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerUserLogin;
    /**
     * The SessionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SessionID;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The Ticket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OTRS_TicketUpdate_Ticket
     */
    public $Ticket;
    /**
     * The Article
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OTRS_Article
     */
    public $Article;
    /**
     * The DynamicField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OTRS_DynamicField[]
     */
    public $DynamicField;
    /**
     * The Attachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OTRS_Attachment[]
     */
    public $Attachment;
    /**
     * Constructor method for TicketUpdate
     * @uses TicketUpdate::setTicketID()
     * @uses TicketUpdate::setTicketNumber()
     * @uses TicketUpdate::setUserLogin()
     * @uses TicketUpdate::setCustomerUserLogin()
     * @uses TicketUpdate::setSessionID()
     * @uses TicketUpdate::setPassword()
     * @uses TicketUpdate::setTicket()
     * @uses TicketUpdate::setArticle()
     * @uses TicketUpdate::setDynamicField()
     * @uses TicketUpdate::setAttachment()
     * @param int $ticketID
     * @param string $ticketNumber
     * @param string $userLogin
     * @param string $customerUserLogin
     * @param string $sessionID
     * @param string $password
     * @param \StructType\OTRS_TicketUpdate_Ticket $ticket
     * @param \StructType\OTRS_Article $article
     * @param \StructType\OTRS_DynamicField[] $dynamicField
     * @param \StructType\OTRS_Attachment[] $attachment
     */
    public function __construct($ticketID = null, $ticketNumber = null, $userLogin = null, $customerUserLogin = null, $sessionID = null, $password = null, \StructType\OTRS_TicketUpdate_Ticket $ticket = null, \StructType\OTRS_Article $article = null, array $dynamicField = array(), array $attachment = array())
    {
        $this
            ->setTicketID($ticketID)
            ->setTicketNumber($ticketNumber)
            ->setUserLogin($userLogin)
            ->setCustomerUserLogin($customerUserLogin)
            ->setSessionID($sessionID)
            ->setPassword($password)
            ->setTicket($ticket)
            ->setArticle($article)
            ->setDynamicField($dynamicField)
            ->setAttachment($attachment);
    }
    /**
     * Get TicketID value
     * @return int
     */
    public function getTicketID()
    {
        return $this->TicketID;
    }
    /**
     * Set TicketID value
     * @param int $ticketID
     * @return \StructType\TicketUpdate
     */
    public function setTicketID($ticketID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketID) && !is_numeric($ticketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketID)), __LINE__);
        }
        $this->TicketID = $ticketID;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \StructType\TicketUpdate
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get UserLogin value
     * @return string|null
     */
    public function getUserLogin()
    {
        return $this->UserLogin;
    }
    /**
     * Set UserLogin value
     * @param string $userLogin
     * @return \StructType\TicketUpdate
     */
    public function setUserLogin($userLogin = null)
    {
        // validation for constraint: string
        if (!is_null($userLogin) && !is_string($userLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLogin)), __LINE__);
        }
        $this->UserLogin = $userLogin;
        return $this;
    }
    /**
     * Get CustomerUserLogin value
     * @return string|null
     */
    public function getCustomerUserLogin()
    {
        return $this->CustomerUserLogin;
    }
    /**
     * Set CustomerUserLogin value
     * @param string $customerUserLogin
     * @return \StructType\TicketUpdate
     */
    public function setCustomerUserLogin($customerUserLogin = null)
    {
        // validation for constraint: string
        if (!is_null($customerUserLogin) && !is_string($customerUserLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerUserLogin)), __LINE__);
        }
        $this->CustomerUserLogin = $customerUserLogin;
        return $this;
    }
    /**
     * Get SessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->SessionID;
    }
    /**
     * Set SessionID value
     * @param string $sessionID
     * @return \StructType\TicketUpdate
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionID)), __LINE__);
        }
        $this->SessionID = $sessionID;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\TicketUpdate
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Ticket value
     * @return \StructType\OTRS_TicketUpdate_Ticket|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param \StructType\OTRS_TicketUpdate_Ticket $ticket
     * @return \StructType\TicketUpdate
     */
    public function setTicket(\StructType\OTRS_TicketUpdate_Ticket $ticket = null)
    {
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get Article value
     * @return \StructType\OTRS_Article|null
     */
    public function getArticle()
    {
        return $this->Article;
    }
    /**
     * Set Article value
     * @param \StructType\OTRS_Article $article
     * @return \StructType\TicketUpdate
     */
    public function setArticle(\StructType\OTRS_Article $article = null)
    {
        $this->Article = $article;
        return $this;
    }
    /**
     * Get DynamicField value
     * @return \StructType\OTRS_DynamicField[]|null
     */
    public function getDynamicField()
    {
        return $this->DynamicField;
    }
    /**
     * Set DynamicField value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_DynamicField[] $dynamicField
     * @return \StructType\TicketUpdate
     */
    public function setDynamicField(array $dynamicField = array())
    {
        foreach ($dynamicField as $ticketUpdateDynamicFieldItem) {
            // validation for constraint: itemType
            if (!$ticketUpdateDynamicFieldItem instanceof \StructType\OTRS_DynamicField) {
                throw new \InvalidArgumentException(sprintf('The DynamicField property can only contain items of \StructType\OTRS_DynamicField, "%s" given', is_object($ticketUpdateDynamicFieldItem) ? get_class($ticketUpdateDynamicFieldItem) : gettype($ticketUpdateDynamicFieldItem)), __LINE__);
            }
        }
        $this->DynamicField = $dynamicField;
        return $this;
    }
    /**
     * Add item to DynamicField value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_DynamicField $item
     * @return \StructType\TicketUpdate
     */
    public function addToDynamicField(\StructType\OTRS_DynamicField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OTRS_DynamicField) {
            throw new \InvalidArgumentException(sprintf('The DynamicField property can only contain items of \StructType\OTRS_DynamicField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DynamicField[] = $item;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \StructType\OTRS_Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_Attachment[] $attachment
     * @return \StructType\TicketUpdate
     */
    public function setAttachment(array $attachment = array())
    {
        foreach ($attachment as $ticketUpdateAttachmentItem) {
            // validation for constraint: itemType
            if (!$ticketUpdateAttachmentItem instanceof \StructType\OTRS_Attachment) {
                throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of \StructType\OTRS_Attachment, "%s" given', is_object($ticketUpdateAttachmentItem) ? get_class($ticketUpdateAttachmentItem) : gettype($ticketUpdateAttachmentItem)), __LINE__);
            }
        }
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Add item to Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_Attachment $item
     * @return \StructType\TicketUpdate
     */
    public function addToAttachment(\StructType\OTRS_Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OTRS_Attachment) {
            throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of \StructType\OTRS_Attachment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attachment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketUpdate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
