<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketSearch StructType
 * Meta informations extracted from the WSDL
 * - documentation: UserLogin, CustomerUserLogin or SessionID is mandatory
 * @subpackage Structs
 */
class TicketSearch extends AbstractStructBase
{
    /**
     * The UserLogin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UserLogin;
    /**
     * The CustomerUserLogin
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CustomerUserLogin;
    /**
     * The SessionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SessionID;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The Limit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Limit;
    /**
     * The TicketNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TicketNumber;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Title;
    /**
     * The Queues
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Queues;
    /**
     * The QueueIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $QueueIDs;
    /**
     * The UseSubQueues
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $UseSubQueues;
    /**
     * The Types
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Types;
    /**
     * The TypeIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $TypeIDs;
    /**
     * The States
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $States;
    /**
     * The StateIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $StateIDs;
    /**
     * The StateType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $StateType;
    /**
     * The StateTypeIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $StateTypeIDs;
    /**
     * The Priorities
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Priorities;
    /**
     * The PriorityIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $PriorityIDs;
    /**
     * The Services
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Services;
    /**
     * The ServiceIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $ServiceIDs;
    /**
     * The SLAs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SLAs;
    /**
     * The SLAIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $SLAIDs;
    /**
     * The Locks
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Locks;
    /**
     * The LockIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $LockIDs;
    /**
     * The OwnerIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $OwnerIDs;
    /**
     * The ResponsibleIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $ResponsibleIDs;
    /**
     * The WatchUserIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $WatchUserIDs;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CustomerID;
    /**
     * The CreatedUserIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $CreatedUserIDs;
    /**
     * The CreatedTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CreatedTypes;
    /**
     * The CreatedTypeIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $CreatedTypeIDs;
    /**
     * The CreatedPriorities
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CreatedPriorities;
    /**
     * The CreatedPriorityIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $CreatedPriorityIDs;
    /**
     * The CreatedStates
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CreatedStates;
    /**
     * The CreatedStateIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $CreatedStateIDs;
    /**
     * The CreatedQueues
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $CreatedQueues;
    /**
     * The CreatedQueueIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $CreatedQueueIDs;
    /**
     * The DynamicField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OTRS_TicketSearch_DynamicField[]
     */
    public $DynamicField;
    /**
     * The Ticketflag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OTRS_TicketSearch_TicketFlag
     */
    public $Ticketflag;
    /**
     * The MIMEBase_From
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MIMEBase_From;
    /**
     * The MIMEBase_To
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MIMEBase_To;
    /**
     * The MIMEBase_Cc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MIMEBase_Cc;
    /**
     * The MIMEBase_Subject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MIMEBase_Subject;
    /**
     * The MIMEBase_Body
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MIMEBase_Body;
    /**
     * The FullTextIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $FullTextIndex;
    /**
     * The ContentSearch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentSearch;
    /**
     * The ConditionInline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ConditionInline;
    /**
     * The ArticleCreateTimeOlderMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ArticleCreateTimeOlderMinutes;
    /**
     * The ArticleCreateTimeNewerMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ArticleCreateTimeNewerMinutes;
    /**
     * The ArticleCreateTimeNewerDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArticleCreateTimeNewerDate;
    /**
     * The ArticleCreateTimeOlderDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArticleCreateTimeOlderDate;
    /**
     * The TicketCreateTimeOlderMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TicketCreateTimeOlderMinutes;
    /**
     * The TicketCreateTimeNewerMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TicketCreateTimeNewerMinutes;
    /**
     * The TicketCreateTimeNewerDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketCreateTimeNewerDate;
    /**
     * The TicketCreateTimeOlderDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketCreateTimeOlderDate;
    /**
     * The TicketChangeTimeOlderMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TicketChangeTimeOlderMinutes;
    /**
     * The TicketChangeTimeNewerMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TicketChangeTimeNewerMinutes;
    /**
     * The TicketChangeTimeNewerDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketChangeTimeNewerDate;
    /**
     * The TicketChangeTimeOlderDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketChangeTimeOlderDate;
    /**
     * The TicketLastChangeTimeOlderMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TicketLastChangeTimeOlderMinutes;
    /**
     * The TicketLastChangeTimeNewerMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TicketLastChangeTimeNewerMinutes;
    /**
     * The TicketLastChangeTimeNewerDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketLastChangeTimeNewerDate;
    /**
     * The TicketLastChangeTimeOlderDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketLastChangeTimeOlderDate;
    /**
     * The TicketCloseTimeOlderMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TicketCloseTimeOlderMinutes;
    /**
     * The TicketCloseTimeNewerMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TicketCloseTimeNewerMinutes;
    /**
     * The TicketCloseTimeNewerDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketCloseTimeNewerDate;
    /**
     * The TicketCloseTimeOlderDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketCloseTimeOlderDate;
    /**
     * The TicketPendingTimeOlderMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TicketPendingTimeOlderMinutes;
    /**
     * The TicketPendingTimeNewerMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TicketPendingTimeNewerMinutes;
    /**
     * The TicketPendingTimeNewerDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketPendingTimeNewerDate;
    /**
     * The TicketPendingTimeOlderDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketPendingTimeOlderDate;
    /**
     * The TicketEscalationTimeOlderMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TicketEscalationTimeOlderMinutes;
    /**
     * The TicketEscalationTimeNewerMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TicketEscalationTimeNewerMinutes;
    /**
     * The TicketEscalationTimeNewerDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketEscalationTimeNewerDate;
    /**
     * The TicketEscalationTimeOlderDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketEscalationTimeOlderDate;
    /**
     * The ArchiveFlags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArchiveFlags;
    /**
     * The OrderBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OrderBy;
    /**
     * The SortBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $SortBy;
    /**
     * The CustomerUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CustomerUserID;
    /**
     * Constructor method for TicketSearch
     * @uses TicketSearch::setUserLogin()
     * @uses TicketSearch::setCustomerUserLogin()
     * @uses TicketSearch::setSessionID()
     * @uses TicketSearch::setPassword()
     * @uses TicketSearch::setLimit()
     * @uses TicketSearch::setTicketNumber()
     * @uses TicketSearch::setTitle()
     * @uses TicketSearch::setQueues()
     * @uses TicketSearch::setQueueIDs()
     * @uses TicketSearch::setUseSubQueues()
     * @uses TicketSearch::setTypes()
     * @uses TicketSearch::setTypeIDs()
     * @uses TicketSearch::setStates()
     * @uses TicketSearch::setStateIDs()
     * @uses TicketSearch::setStateType()
     * @uses TicketSearch::setStateTypeIDs()
     * @uses TicketSearch::setPriorities()
     * @uses TicketSearch::setPriorityIDs()
     * @uses TicketSearch::setServices()
     * @uses TicketSearch::setServiceIDs()
     * @uses TicketSearch::setSLAs()
     * @uses TicketSearch::setSLAIDs()
     * @uses TicketSearch::setLocks()
     * @uses TicketSearch::setLockIDs()
     * @uses TicketSearch::setOwnerIDs()
     * @uses TicketSearch::setResponsibleIDs()
     * @uses TicketSearch::setWatchUserIDs()
     * @uses TicketSearch::setCustomerID()
     * @uses TicketSearch::setCreatedUserIDs()
     * @uses TicketSearch::setCreatedTypes()
     * @uses TicketSearch::setCreatedTypeIDs()
     * @uses TicketSearch::setCreatedPriorities()
     * @uses TicketSearch::setCreatedPriorityIDs()
     * @uses TicketSearch::setCreatedStates()
     * @uses TicketSearch::setCreatedStateIDs()
     * @uses TicketSearch::setCreatedQueues()
     * @uses TicketSearch::setCreatedQueueIDs()
     * @uses TicketSearch::setDynamicField()
     * @uses TicketSearch::setTicketflag()
     * @uses TicketSearch::setMIMEBase_From()
     * @uses TicketSearch::setMIMEBase_To()
     * @uses TicketSearch::setMIMEBase_Cc()
     * @uses TicketSearch::setMIMEBase_Subject()
     * @uses TicketSearch::setMIMEBase_Body()
     * @uses TicketSearch::setFullTextIndex()
     * @uses TicketSearch::setContentSearch()
     * @uses TicketSearch::setConditionInline()
     * @uses TicketSearch::setArticleCreateTimeOlderMinutes()
     * @uses TicketSearch::setArticleCreateTimeNewerMinutes()
     * @uses TicketSearch::setArticleCreateTimeNewerDate()
     * @uses TicketSearch::setArticleCreateTimeOlderDate()
     * @uses TicketSearch::setTicketCreateTimeOlderMinutes()
     * @uses TicketSearch::setTicketCreateTimeNewerMinutes()
     * @uses TicketSearch::setTicketCreateTimeNewerDate()
     * @uses TicketSearch::setTicketCreateTimeOlderDate()
     * @uses TicketSearch::setTicketChangeTimeOlderMinutes()
     * @uses TicketSearch::setTicketChangeTimeNewerMinutes()
     * @uses TicketSearch::setTicketChangeTimeNewerDate()
     * @uses TicketSearch::setTicketChangeTimeOlderDate()
     * @uses TicketSearch::setTicketLastChangeTimeOlderMinutes()
     * @uses TicketSearch::setTicketLastChangeTimeNewerMinutes()
     * @uses TicketSearch::setTicketLastChangeTimeNewerDate()
     * @uses TicketSearch::setTicketLastChangeTimeOlderDate()
     * @uses TicketSearch::setTicketCloseTimeOlderMinutes()
     * @uses TicketSearch::setTicketCloseTimeNewerMinutes()
     * @uses TicketSearch::setTicketCloseTimeNewerDate()
     * @uses TicketSearch::setTicketCloseTimeOlderDate()
     * @uses TicketSearch::setTicketPendingTimeOlderMinutes()
     * @uses TicketSearch::setTicketPendingTimeNewerMinutes()
     * @uses TicketSearch::setTicketPendingTimeNewerDate()
     * @uses TicketSearch::setTicketPendingTimeOlderDate()
     * @uses TicketSearch::setTicketEscalationTimeOlderMinutes()
     * @uses TicketSearch::setTicketEscalationTimeNewerMinutes()
     * @uses TicketSearch::setTicketEscalationTimeNewerDate()
     * @uses TicketSearch::setTicketEscalationTimeOlderDate()
     * @uses TicketSearch::setArchiveFlags()
     * @uses TicketSearch::setOrderBy()
     * @uses TicketSearch::setSortBy()
     * @uses TicketSearch::setCustomerUserID()
     * @param string $userLogin
     * @param string[] $customerUserLogin
     * @param string $sessionID
     * @param string $password
     * @param int $limit
     * @param string[] $ticketNumber
     * @param string[] $title
     * @param string[] $queues
     * @param int[] $queueIDs
     * @param int $useSubQueues
     * @param string[] $types
     * @param int[] $typeIDs
     * @param string[] $states
     * @param int[] $stateIDs
     * @param string[] $stateType
     * @param int[] $stateTypeIDs
     * @param string[] $priorities
     * @param int[] $priorityIDs
     * @param string[] $services
     * @param int[] $serviceIDs
     * @param string[] $sLAs
     * @param int[] $sLAIDs
     * @param string[] $locks
     * @param int[] $lockIDs
     * @param int[] $ownerIDs
     * @param int[] $responsibleIDs
     * @param int[] $watchUserIDs
     * @param string[] $customerID
     * @param int[] $createdUserIDs
     * @param string[] $createdTypes
     * @param int[] $createdTypeIDs
     * @param string[] $createdPriorities
     * @param int[] $createdPriorityIDs
     * @param string[] $createdStates
     * @param int[] $createdStateIDs
     * @param int[] $createdQueues
     * @param int[] $createdQueueIDs
     * @param \StructType\OTRS_TicketSearch_DynamicField[] $dynamicField
     * @param \StructType\OTRS_TicketSearch_TicketFlag $ticketflag
     * @param string $mIMEBase_From
     * @param string $mIMEBase_To
     * @param string $mIMEBase_Cc
     * @param string $mIMEBase_Subject
     * @param string $mIMEBase_Body
     * @param int $fullTextIndex
     * @param string $contentSearch
     * @param int $conditionInline
     * @param int $articleCreateTimeOlderMinutes
     * @param int $articleCreateTimeNewerMinutes
     * @param string $articleCreateTimeNewerDate
     * @param string $articleCreateTimeOlderDate
     * @param int $ticketCreateTimeOlderMinutes
     * @param int $ticketCreateTimeNewerMinutes
     * @param string $ticketCreateTimeNewerDate
     * @param string $ticketCreateTimeOlderDate
     * @param int $ticketChangeTimeOlderMinutes
     * @param int $ticketChangeTimeNewerMinutes
     * @param string $ticketChangeTimeNewerDate
     * @param string $ticketChangeTimeOlderDate
     * @param int $ticketLastChangeTimeOlderMinutes
     * @param int $ticketLastChangeTimeNewerMinutes
     * @param string $ticketLastChangeTimeNewerDate
     * @param string $ticketLastChangeTimeOlderDate
     * @param int $ticketCloseTimeOlderMinutes
     * @param int $ticketCloseTimeNewerMinutes
     * @param string $ticketCloseTimeNewerDate
     * @param string $ticketCloseTimeOlderDate
     * @param int $ticketPendingTimeOlderMinutes
     * @param int $ticketPendingTimeNewerMinutes
     * @param string $ticketPendingTimeNewerDate
     * @param string $ticketPendingTimeOlderDate
     * @param int $ticketEscalationTimeOlderMinutes
     * @param int $ticketEscalationTimeNewerMinutes
     * @param string $ticketEscalationTimeNewerDate
     * @param string $ticketEscalationTimeOlderDate
     * @param string $archiveFlags
     * @param string[] $orderBy
     * @param int[] $sortBy
     * @param string[] $customerUserID
     */
    public function __construct($userLogin = null, array $customerUserLogin = array(), $sessionID = null, $password = null, $limit = null, array $ticketNumber = array(), array $title = array(), array $queues = array(), array $queueIDs = array(), $useSubQueues = null, array $types = array(), array $typeIDs = array(), array $states = array(), array $stateIDs = array(), array $stateType = array(), array $stateTypeIDs = array(), array $priorities = array(), array $priorityIDs = array(), array $services = array(), array $serviceIDs = array(), array $sLAs = array(), array $sLAIDs = array(), array $locks = array(), array $lockIDs = array(), array $ownerIDs = array(), array $responsibleIDs = array(), array $watchUserIDs = array(), array $customerID = array(), array $createdUserIDs = array(), array $createdTypes = array(), array $createdTypeIDs = array(), array $createdPriorities = array(), array $createdPriorityIDs = array(), array $createdStates = array(), array $createdStateIDs = array(), array $createdQueues = array(), array $createdQueueIDs = array(), array $dynamicField = array(), \StructType\OTRS_TicketSearch_TicketFlag $ticketflag = null, $mIMEBase_From = null, $mIMEBase_To = null, $mIMEBase_Cc = null, $mIMEBase_Subject = null, $mIMEBase_Body = null, $fullTextIndex = null, $contentSearch = null, $conditionInline = null, $articleCreateTimeOlderMinutes = null, $articleCreateTimeNewerMinutes = null, $articleCreateTimeNewerDate = null, $articleCreateTimeOlderDate = null, $ticketCreateTimeOlderMinutes = null, $ticketCreateTimeNewerMinutes = null, $ticketCreateTimeNewerDate = null, $ticketCreateTimeOlderDate = null, $ticketChangeTimeOlderMinutes = null, $ticketChangeTimeNewerMinutes = null, $ticketChangeTimeNewerDate = null, $ticketChangeTimeOlderDate = null, $ticketLastChangeTimeOlderMinutes = null, $ticketLastChangeTimeNewerMinutes = null, $ticketLastChangeTimeNewerDate = null, $ticketLastChangeTimeOlderDate = null, $ticketCloseTimeOlderMinutes = null, $ticketCloseTimeNewerMinutes = null, $ticketCloseTimeNewerDate = null, $ticketCloseTimeOlderDate = null, $ticketPendingTimeOlderMinutes = null, $ticketPendingTimeNewerMinutes = null, $ticketPendingTimeNewerDate = null, $ticketPendingTimeOlderDate = null, $ticketEscalationTimeOlderMinutes = null, $ticketEscalationTimeNewerMinutes = null, $ticketEscalationTimeNewerDate = null, $ticketEscalationTimeOlderDate = null, $archiveFlags = null, array $orderBy = array(), array $sortBy = array(), array $customerUserID = array())
    {
        $this
            ->setUserLogin($userLogin)
            ->setCustomerUserLogin($customerUserLogin)
            ->setSessionID($sessionID)
            ->setPassword($password)
            ->setLimit($limit)
            ->setTicketNumber($ticketNumber)
            ->setTitle($title)
            ->setQueues($queues)
            ->setQueueIDs($queueIDs)
            ->setUseSubQueues($useSubQueues)
            ->setTypes($types)
            ->setTypeIDs($typeIDs)
            ->setStates($states)
            ->setStateIDs($stateIDs)
            ->setStateType($stateType)
            ->setStateTypeIDs($stateTypeIDs)
            ->setPriorities($priorities)
            ->setPriorityIDs($priorityIDs)
            ->setServices($services)
            ->setServiceIDs($serviceIDs)
            ->setSLAs($sLAs)
            ->setSLAIDs($sLAIDs)
            ->setLocks($locks)
            ->setLockIDs($lockIDs)
            ->setOwnerIDs($ownerIDs)
            ->setResponsibleIDs($responsibleIDs)
            ->setWatchUserIDs($watchUserIDs)
            ->setCustomerID($customerID)
            ->setCreatedUserIDs($createdUserIDs)
            ->setCreatedTypes($createdTypes)
            ->setCreatedTypeIDs($createdTypeIDs)
            ->setCreatedPriorities($createdPriorities)
            ->setCreatedPriorityIDs($createdPriorityIDs)
            ->setCreatedStates($createdStates)
            ->setCreatedStateIDs($createdStateIDs)
            ->setCreatedQueues($createdQueues)
            ->setCreatedQueueIDs($createdQueueIDs)
            ->setDynamicField($dynamicField)
            ->setTicketflag($ticketflag)
            ->setMIMEBase_From($mIMEBase_From)
            ->setMIMEBase_To($mIMEBase_To)
            ->setMIMEBase_Cc($mIMEBase_Cc)
            ->setMIMEBase_Subject($mIMEBase_Subject)
            ->setMIMEBase_Body($mIMEBase_Body)
            ->setFullTextIndex($fullTextIndex)
            ->setContentSearch($contentSearch)
            ->setConditionInline($conditionInline)
            ->setArticleCreateTimeOlderMinutes($articleCreateTimeOlderMinutes)
            ->setArticleCreateTimeNewerMinutes($articleCreateTimeNewerMinutes)
            ->setArticleCreateTimeNewerDate($articleCreateTimeNewerDate)
            ->setArticleCreateTimeOlderDate($articleCreateTimeOlderDate)
            ->setTicketCreateTimeOlderMinutes($ticketCreateTimeOlderMinutes)
            ->setTicketCreateTimeNewerMinutes($ticketCreateTimeNewerMinutes)
            ->setTicketCreateTimeNewerDate($ticketCreateTimeNewerDate)
            ->setTicketCreateTimeOlderDate($ticketCreateTimeOlderDate)
            ->setTicketChangeTimeOlderMinutes($ticketChangeTimeOlderMinutes)
            ->setTicketChangeTimeNewerMinutes($ticketChangeTimeNewerMinutes)
            ->setTicketChangeTimeNewerDate($ticketChangeTimeNewerDate)
            ->setTicketChangeTimeOlderDate($ticketChangeTimeOlderDate)
            ->setTicketLastChangeTimeOlderMinutes($ticketLastChangeTimeOlderMinutes)
            ->setTicketLastChangeTimeNewerMinutes($ticketLastChangeTimeNewerMinutes)
            ->setTicketLastChangeTimeNewerDate($ticketLastChangeTimeNewerDate)
            ->setTicketLastChangeTimeOlderDate($ticketLastChangeTimeOlderDate)
            ->setTicketCloseTimeOlderMinutes($ticketCloseTimeOlderMinutes)
            ->setTicketCloseTimeNewerMinutes($ticketCloseTimeNewerMinutes)
            ->setTicketCloseTimeNewerDate($ticketCloseTimeNewerDate)
            ->setTicketCloseTimeOlderDate($ticketCloseTimeOlderDate)
            ->setTicketPendingTimeOlderMinutes($ticketPendingTimeOlderMinutes)
            ->setTicketPendingTimeNewerMinutes($ticketPendingTimeNewerMinutes)
            ->setTicketPendingTimeNewerDate($ticketPendingTimeNewerDate)
            ->setTicketPendingTimeOlderDate($ticketPendingTimeOlderDate)
            ->setTicketEscalationTimeOlderMinutes($ticketEscalationTimeOlderMinutes)
            ->setTicketEscalationTimeNewerMinutes($ticketEscalationTimeNewerMinutes)
            ->setTicketEscalationTimeNewerDate($ticketEscalationTimeNewerDate)
            ->setTicketEscalationTimeOlderDate($ticketEscalationTimeOlderDate)
            ->setArchiveFlags($archiveFlags)
            ->setOrderBy($orderBy)
            ->setSortBy($sortBy)
            ->setCustomerUserID($customerUserID);
    }
    /**
     * Get UserLogin value
     * @return string|null
     */
    public function getUserLogin()
    {
        return $this->UserLogin;
    }
    /**
     * Set UserLogin value
     * @param string $userLogin
     * @return \StructType\TicketSearch
     */
    public function setUserLogin($userLogin = null)
    {
        // validation for constraint: string
        if (!is_null($userLogin) && !is_string($userLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLogin)), __LINE__);
        }
        $this->UserLogin = $userLogin;
        return $this;
    }
    /**
     * Get CustomerUserLogin value
     * @return string[]|null
     */
    public function getCustomerUserLogin()
    {
        return $this->CustomerUserLogin;
    }
    /**
     * Set CustomerUserLogin value
     * @throws \InvalidArgumentException
     * @param string[] $customerUserLogin
     * @return \StructType\TicketSearch
     */
    public function setCustomerUserLogin(array $customerUserLogin = array())
    {
        foreach ($customerUserLogin as $ticketSearchCustomerUserLoginItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchCustomerUserLoginItem)) {
                throw new \InvalidArgumentException(sprintf('The CustomerUserLogin property can only contain items of string, "%s" given', is_object($ticketSearchCustomerUserLoginItem) ? get_class($ticketSearchCustomerUserLoginItem) : gettype($ticketSearchCustomerUserLoginItem)), __LINE__);
            }
        }
        $this->CustomerUserLogin = $customerUserLogin;
        return $this;
    }
    /**
     * Add item to CustomerUserLogin value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToCustomerUserLogin($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CustomerUserLogin property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerUserLogin[] = $item;
        return $this;
    }
    /**
     * Get SessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->SessionID;
    }
    /**
     * Set SessionID value
     * @param string $sessionID
     * @return \StructType\TicketSearch
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionID)), __LINE__);
        }
        $this->SessionID = $sessionID;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\TicketSearch
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param int $limit
     * @return \StructType\TicketSearch
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string[]|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @throws \InvalidArgumentException
     * @param string[] $ticketNumber
     * @return \StructType\TicketSearch
     */
    public function setTicketNumber(array $ticketNumber = array())
    {
        foreach ($ticketNumber as $ticketSearchTicketNumberItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchTicketNumberItem)) {
                throw new \InvalidArgumentException(sprintf('The TicketNumber property can only contain items of string, "%s" given', is_object($ticketSearchTicketNumberItem) ? get_class($ticketSearchTicketNumberItem) : gettype($ticketSearchTicketNumberItem)), __LINE__);
            }
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Add item to TicketNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToTicketNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TicketNumber property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketNumber[] = $item;
        return $this;
    }
    /**
     * Get Title value
     * @return string[]|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @throws \InvalidArgumentException
     * @param string[] $title
     * @return \StructType\TicketSearch
     */
    public function setTitle(array $title = array())
    {
        foreach ($title as $ticketSearchTitleItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchTitleItem)) {
                throw new \InvalidArgumentException(sprintf('The Title property can only contain items of string, "%s" given', is_object($ticketSearchTitleItem) ? get_class($ticketSearchTitleItem) : gettype($ticketSearchTitleItem)), __LINE__);
            }
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Add item to Title value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToTitle($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Title property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Title[] = $item;
        return $this;
    }
    /**
     * Get Queues value
     * @return string[]|null
     */
    public function getQueues()
    {
        return $this->Queues;
    }
    /**
     * Set Queues value
     * @throws \InvalidArgumentException
     * @param string[] $queues
     * @return \StructType\TicketSearch
     */
    public function setQueues(array $queues = array())
    {
        foreach ($queues as $ticketSearchQueuesItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchQueuesItem)) {
                throw new \InvalidArgumentException(sprintf('The Queues property can only contain items of string, "%s" given', is_object($ticketSearchQueuesItem) ? get_class($ticketSearchQueuesItem) : gettype($ticketSearchQueuesItem)), __LINE__);
            }
        }
        $this->Queues = $queues;
        return $this;
    }
    /**
     * Add item to Queues value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToQueues($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Queues property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Queues[] = $item;
        return $this;
    }
    /**
     * Get QueueIDs value
     * @return int[]|null
     */
    public function getQueueIDs()
    {
        return $this->QueueIDs;
    }
    /**
     * Set QueueIDs value
     * @throws \InvalidArgumentException
     * @param int[] $queueIDs
     * @return \StructType\TicketSearch
     */
    public function setQueueIDs(array $queueIDs = array())
    {
        foreach ($queueIDs as $ticketSearchQueueIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchQueueIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The QueueIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchQueueIDsItem) ? get_class($ticketSearchQueueIDsItem) : gettype($ticketSearchQueueIDsItem)), __LINE__);
            }
        }
        $this->QueueIDs = $queueIDs;
        return $this;
    }
    /**
     * Add item to QueueIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToQueueIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The QueueIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->QueueIDs[] = $item;
        return $this;
    }
    /**
     * Get UseSubQueues value
     * @return int|null
     */
    public function getUseSubQueues()
    {
        return $this->UseSubQueues;
    }
    /**
     * Set UseSubQueues value
     * @param int $useSubQueues
     * @return \StructType\TicketSearch
     */
    public function setUseSubQueues($useSubQueues = null)
    {
        // validation for constraint: int
        if (!is_null($useSubQueues) && !is_numeric($useSubQueues)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($useSubQueues)), __LINE__);
        }
        $this->UseSubQueues = $useSubQueues;
        return $this;
    }
    /**
     * Get Types value
     * @return string[]|null
     */
    public function getTypes()
    {
        return $this->Types;
    }
    /**
     * Set Types value
     * @throws \InvalidArgumentException
     * @param string[] $types
     * @return \StructType\TicketSearch
     */
    public function setTypes(array $types = array())
    {
        foreach ($types as $ticketSearchTypesItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchTypesItem)) {
                throw new \InvalidArgumentException(sprintf('The Types property can only contain items of string, "%s" given', is_object($ticketSearchTypesItem) ? get_class($ticketSearchTypesItem) : gettype($ticketSearchTypesItem)), __LINE__);
            }
        }
        $this->Types = $types;
        return $this;
    }
    /**
     * Add item to Types value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToTypes($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Types property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Types[] = $item;
        return $this;
    }
    /**
     * Get TypeIDs value
     * @return int[]|null
     */
    public function getTypeIDs()
    {
        return $this->TypeIDs;
    }
    /**
     * Set TypeIDs value
     * @throws \InvalidArgumentException
     * @param int[] $typeIDs
     * @return \StructType\TicketSearch
     */
    public function setTypeIDs(array $typeIDs = array())
    {
        foreach ($typeIDs as $ticketSearchTypeIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchTypeIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The TypeIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchTypeIDsItem) ? get_class($ticketSearchTypeIDsItem) : gettype($ticketSearchTypeIDsItem)), __LINE__);
            }
        }
        $this->TypeIDs = $typeIDs;
        return $this;
    }
    /**
     * Add item to TypeIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToTypeIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The TypeIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TypeIDs[] = $item;
        return $this;
    }
    /**
     * Get States value
     * @return string[]|null
     */
    public function getStates()
    {
        return $this->States;
    }
    /**
     * Set States value
     * @throws \InvalidArgumentException
     * @param string[] $states
     * @return \StructType\TicketSearch
     */
    public function setStates(array $states = array())
    {
        foreach ($states as $ticketSearchStatesItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchStatesItem)) {
                throw new \InvalidArgumentException(sprintf('The States property can only contain items of string, "%s" given', is_object($ticketSearchStatesItem) ? get_class($ticketSearchStatesItem) : gettype($ticketSearchStatesItem)), __LINE__);
            }
        }
        $this->States = $states;
        return $this;
    }
    /**
     * Add item to States value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToStates($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The States property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->States[] = $item;
        return $this;
    }
    /**
     * Get StateIDs value
     * @return int[]|null
     */
    public function getStateIDs()
    {
        return $this->StateIDs;
    }
    /**
     * Set StateIDs value
     * @throws \InvalidArgumentException
     * @param int[] $stateIDs
     * @return \StructType\TicketSearch
     */
    public function setStateIDs(array $stateIDs = array())
    {
        foreach ($stateIDs as $ticketSearchStateIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchStateIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The StateIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchStateIDsItem) ? get_class($ticketSearchStateIDsItem) : gettype($ticketSearchStateIDsItem)), __LINE__);
            }
        }
        $this->StateIDs = $stateIDs;
        return $this;
    }
    /**
     * Add item to StateIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToStateIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The StateIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StateIDs[] = $item;
        return $this;
    }
    /**
     * Get StateType value
     * @return string[]|null
     */
    public function getStateType()
    {
        return $this->StateType;
    }
    /**
     * Set StateType value
     * @throws \InvalidArgumentException
     * @param string[] $stateType
     * @return \StructType\TicketSearch
     */
    public function setStateType(array $stateType = array())
    {
        foreach ($stateType as $ticketSearchStateTypeItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchStateTypeItem)) {
                throw new \InvalidArgumentException(sprintf('The StateType property can only contain items of string, "%s" given', is_object($ticketSearchStateTypeItem) ? get_class($ticketSearchStateTypeItem) : gettype($ticketSearchStateTypeItem)), __LINE__);
            }
        }
        $this->StateType = $stateType;
        return $this;
    }
    /**
     * Add item to StateType value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToStateType($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The StateType property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StateType[] = $item;
        return $this;
    }
    /**
     * Get StateTypeIDs value
     * @return int[]|null
     */
    public function getStateTypeIDs()
    {
        return $this->StateTypeIDs;
    }
    /**
     * Set StateTypeIDs value
     * @throws \InvalidArgumentException
     * @param int[] $stateTypeIDs
     * @return \StructType\TicketSearch
     */
    public function setStateTypeIDs(array $stateTypeIDs = array())
    {
        foreach ($stateTypeIDs as $ticketSearchStateTypeIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchStateTypeIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The StateTypeIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchStateTypeIDsItem) ? get_class($ticketSearchStateTypeIDsItem) : gettype($ticketSearchStateTypeIDsItem)), __LINE__);
            }
        }
        $this->StateTypeIDs = $stateTypeIDs;
        return $this;
    }
    /**
     * Add item to StateTypeIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToStateTypeIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The StateTypeIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StateTypeIDs[] = $item;
        return $this;
    }
    /**
     * Get Priorities value
     * @return string[]|null
     */
    public function getPriorities()
    {
        return $this->Priorities;
    }
    /**
     * Set Priorities value
     * @throws \InvalidArgumentException
     * @param string[] $priorities
     * @return \StructType\TicketSearch
     */
    public function setPriorities(array $priorities = array())
    {
        foreach ($priorities as $ticketSearchPrioritiesItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchPrioritiesItem)) {
                throw new \InvalidArgumentException(sprintf('The Priorities property can only contain items of string, "%s" given', is_object($ticketSearchPrioritiesItem) ? get_class($ticketSearchPrioritiesItem) : gettype($ticketSearchPrioritiesItem)), __LINE__);
            }
        }
        $this->Priorities = $priorities;
        return $this;
    }
    /**
     * Add item to Priorities value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToPriorities($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Priorities property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Priorities[] = $item;
        return $this;
    }
    /**
     * Get PriorityIDs value
     * @return int[]|null
     */
    public function getPriorityIDs()
    {
        return $this->PriorityIDs;
    }
    /**
     * Set PriorityIDs value
     * @throws \InvalidArgumentException
     * @param int[] $priorityIDs
     * @return \StructType\TicketSearch
     */
    public function setPriorityIDs(array $priorityIDs = array())
    {
        foreach ($priorityIDs as $ticketSearchPriorityIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchPriorityIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The PriorityIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchPriorityIDsItem) ? get_class($ticketSearchPriorityIDsItem) : gettype($ticketSearchPriorityIDsItem)), __LINE__);
            }
        }
        $this->PriorityIDs = $priorityIDs;
        return $this;
    }
    /**
     * Add item to PriorityIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToPriorityIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The PriorityIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PriorityIDs[] = $item;
        return $this;
    }
    /**
     * Get Services value
     * @return string[]|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @throws \InvalidArgumentException
     * @param string[] $services
     * @return \StructType\TicketSearch
     */
    public function setServices(array $services = array())
    {
        foreach ($services as $ticketSearchServicesItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchServicesItem)) {
                throw new \InvalidArgumentException(sprintf('The Services property can only contain items of string, "%s" given', is_object($ticketSearchServicesItem) ? get_class($ticketSearchServicesItem) : gettype($ticketSearchServicesItem)), __LINE__);
            }
        }
        $this->Services = $services;
        return $this;
    }
    /**
     * Add item to Services value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToServices($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Services property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Services[] = $item;
        return $this;
    }
    /**
     * Get ServiceIDs value
     * @return int[]|null
     */
    public function getServiceIDs()
    {
        return $this->ServiceIDs;
    }
    /**
     * Set ServiceIDs value
     * @throws \InvalidArgumentException
     * @param int[] $serviceIDs
     * @return \StructType\TicketSearch
     */
    public function setServiceIDs(array $serviceIDs = array())
    {
        foreach ($serviceIDs as $ticketSearchServiceIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchServiceIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The ServiceIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchServiceIDsItem) ? get_class($ticketSearchServiceIDsItem) : gettype($ticketSearchServiceIDsItem)), __LINE__);
            }
        }
        $this->ServiceIDs = $serviceIDs;
        return $this;
    }
    /**
     * Add item to ServiceIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToServiceIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The ServiceIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceIDs[] = $item;
        return $this;
    }
    /**
     * Get SLAs value
     * @return string[]|null
     */
    public function getSLAs()
    {
        return $this->SLAs;
    }
    /**
     * Set SLAs value
     * @throws \InvalidArgumentException
     * @param string[] $sLAs
     * @return \StructType\TicketSearch
     */
    public function setSLAs(array $sLAs = array())
    {
        foreach ($sLAs as $ticketSearchSLAsItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchSLAsItem)) {
                throw new \InvalidArgumentException(sprintf('The SLAs property can only contain items of string, "%s" given', is_object($ticketSearchSLAsItem) ? get_class($ticketSearchSLAsItem) : gettype($ticketSearchSLAsItem)), __LINE__);
            }
        }
        $this->SLAs = $sLAs;
        return $this;
    }
    /**
     * Add item to SLAs value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToSLAs($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SLAs property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SLAs[] = $item;
        return $this;
    }
    /**
     * Get SLAIDs value
     * @return int[]|null
     */
    public function getSLAIDs()
    {
        return $this->SLAIDs;
    }
    /**
     * Set SLAIDs value
     * @throws \InvalidArgumentException
     * @param int[] $sLAIDs
     * @return \StructType\TicketSearch
     */
    public function setSLAIDs(array $sLAIDs = array())
    {
        foreach ($sLAIDs as $ticketSearchSLAIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchSLAIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The SLAIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchSLAIDsItem) ? get_class($ticketSearchSLAIDsItem) : gettype($ticketSearchSLAIDsItem)), __LINE__);
            }
        }
        $this->SLAIDs = $sLAIDs;
        return $this;
    }
    /**
     * Add item to SLAIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToSLAIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The SLAIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SLAIDs[] = $item;
        return $this;
    }
    /**
     * Get Locks value
     * @return string[]|null
     */
    public function getLocks()
    {
        return $this->Locks;
    }
    /**
     * Set Locks value
     * @throws \InvalidArgumentException
     * @param string[] $locks
     * @return \StructType\TicketSearch
     */
    public function setLocks(array $locks = array())
    {
        foreach ($locks as $ticketSearchLocksItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchLocksItem)) {
                throw new \InvalidArgumentException(sprintf('The Locks property can only contain items of string, "%s" given', is_object($ticketSearchLocksItem) ? get_class($ticketSearchLocksItem) : gettype($ticketSearchLocksItem)), __LINE__);
            }
        }
        $this->Locks = $locks;
        return $this;
    }
    /**
     * Add item to Locks value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToLocks($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Locks property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Locks[] = $item;
        return $this;
    }
    /**
     * Get LockIDs value
     * @return int[]|null
     */
    public function getLockIDs()
    {
        return $this->LockIDs;
    }
    /**
     * Set LockIDs value
     * @throws \InvalidArgumentException
     * @param int[] $lockIDs
     * @return \StructType\TicketSearch
     */
    public function setLockIDs(array $lockIDs = array())
    {
        foreach ($lockIDs as $ticketSearchLockIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchLockIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The LockIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchLockIDsItem) ? get_class($ticketSearchLockIDsItem) : gettype($ticketSearchLockIDsItem)), __LINE__);
            }
        }
        $this->LockIDs = $lockIDs;
        return $this;
    }
    /**
     * Add item to LockIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToLockIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The LockIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LockIDs[] = $item;
        return $this;
    }
    /**
     * Get OwnerIDs value
     * @return int[]|null
     */
    public function getOwnerIDs()
    {
        return $this->OwnerIDs;
    }
    /**
     * Set OwnerIDs value
     * @throws \InvalidArgumentException
     * @param int[] $ownerIDs
     * @return \StructType\TicketSearch
     */
    public function setOwnerIDs(array $ownerIDs = array())
    {
        foreach ($ownerIDs as $ticketSearchOwnerIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchOwnerIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The OwnerIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchOwnerIDsItem) ? get_class($ticketSearchOwnerIDsItem) : gettype($ticketSearchOwnerIDsItem)), __LINE__);
            }
        }
        $this->OwnerIDs = $ownerIDs;
        return $this;
    }
    /**
     * Add item to OwnerIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToOwnerIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The OwnerIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OwnerIDs[] = $item;
        return $this;
    }
    /**
     * Get ResponsibleIDs value
     * @return int[]|null
     */
    public function getResponsibleIDs()
    {
        return $this->ResponsibleIDs;
    }
    /**
     * Set ResponsibleIDs value
     * @throws \InvalidArgumentException
     * @param int[] $responsibleIDs
     * @return \StructType\TicketSearch
     */
    public function setResponsibleIDs(array $responsibleIDs = array())
    {
        foreach ($responsibleIDs as $ticketSearchResponsibleIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchResponsibleIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The ResponsibleIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchResponsibleIDsItem) ? get_class($ticketSearchResponsibleIDsItem) : gettype($ticketSearchResponsibleIDsItem)), __LINE__);
            }
        }
        $this->ResponsibleIDs = $responsibleIDs;
        return $this;
    }
    /**
     * Add item to ResponsibleIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToResponsibleIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The ResponsibleIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ResponsibleIDs[] = $item;
        return $this;
    }
    /**
     * Get WatchUserIDs value
     * @return int[]|null
     */
    public function getWatchUserIDs()
    {
        return $this->WatchUserIDs;
    }
    /**
     * Set WatchUserIDs value
     * @throws \InvalidArgumentException
     * @param int[] $watchUserIDs
     * @return \StructType\TicketSearch
     */
    public function setWatchUserIDs(array $watchUserIDs = array())
    {
        foreach ($watchUserIDs as $ticketSearchWatchUserIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchWatchUserIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The WatchUserIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchWatchUserIDsItem) ? get_class($ticketSearchWatchUserIDsItem) : gettype($ticketSearchWatchUserIDsItem)), __LINE__);
            }
        }
        $this->WatchUserIDs = $watchUserIDs;
        return $this;
    }
    /**
     * Add item to WatchUserIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToWatchUserIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The WatchUserIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WatchUserIDs[] = $item;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return string[]|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @throws \InvalidArgumentException
     * @param string[] $customerID
     * @return \StructType\TicketSearch
     */
    public function setCustomerID(array $customerID = array())
    {
        foreach ($customerID as $ticketSearchCustomerIDItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchCustomerIDItem)) {
                throw new \InvalidArgumentException(sprintf('The CustomerID property can only contain items of string, "%s" given', is_object($ticketSearchCustomerIDItem) ? get_class($ticketSearchCustomerIDItem) : gettype($ticketSearchCustomerIDItem)), __LINE__);
            }
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Add item to CustomerID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToCustomerID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CustomerID property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerID[] = $item;
        return $this;
    }
    /**
     * Get CreatedUserIDs value
     * @return int[]|null
     */
    public function getCreatedUserIDs()
    {
        return $this->CreatedUserIDs;
    }
    /**
     * Set CreatedUserIDs value
     * @throws \InvalidArgumentException
     * @param int[] $createdUserIDs
     * @return \StructType\TicketSearch
     */
    public function setCreatedUserIDs(array $createdUserIDs = array())
    {
        foreach ($createdUserIDs as $ticketSearchCreatedUserIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchCreatedUserIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The CreatedUserIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchCreatedUserIDsItem) ? get_class($ticketSearchCreatedUserIDsItem) : gettype($ticketSearchCreatedUserIDsItem)), __LINE__);
            }
        }
        $this->CreatedUserIDs = $createdUserIDs;
        return $this;
    }
    /**
     * Add item to CreatedUserIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToCreatedUserIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The CreatedUserIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreatedUserIDs[] = $item;
        return $this;
    }
    /**
     * Get CreatedTypes value
     * @return string[]|null
     */
    public function getCreatedTypes()
    {
        return $this->CreatedTypes;
    }
    /**
     * Set CreatedTypes value
     * @throws \InvalidArgumentException
     * @param string[] $createdTypes
     * @return \StructType\TicketSearch
     */
    public function setCreatedTypes(array $createdTypes = array())
    {
        foreach ($createdTypes as $ticketSearchCreatedTypesItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchCreatedTypesItem)) {
                throw new \InvalidArgumentException(sprintf('The CreatedTypes property can only contain items of string, "%s" given', is_object($ticketSearchCreatedTypesItem) ? get_class($ticketSearchCreatedTypesItem) : gettype($ticketSearchCreatedTypesItem)), __LINE__);
            }
        }
        $this->CreatedTypes = $createdTypes;
        return $this;
    }
    /**
     * Add item to CreatedTypes value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToCreatedTypes($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CreatedTypes property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreatedTypes[] = $item;
        return $this;
    }
    /**
     * Get CreatedTypeIDs value
     * @return int[]|null
     */
    public function getCreatedTypeIDs()
    {
        return $this->CreatedTypeIDs;
    }
    /**
     * Set CreatedTypeIDs value
     * @throws \InvalidArgumentException
     * @param int[] $createdTypeIDs
     * @return \StructType\TicketSearch
     */
    public function setCreatedTypeIDs(array $createdTypeIDs = array())
    {
        foreach ($createdTypeIDs as $ticketSearchCreatedTypeIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchCreatedTypeIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The CreatedTypeIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchCreatedTypeIDsItem) ? get_class($ticketSearchCreatedTypeIDsItem) : gettype($ticketSearchCreatedTypeIDsItem)), __LINE__);
            }
        }
        $this->CreatedTypeIDs = $createdTypeIDs;
        return $this;
    }
    /**
     * Add item to CreatedTypeIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToCreatedTypeIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The CreatedTypeIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreatedTypeIDs[] = $item;
        return $this;
    }
    /**
     * Get CreatedPriorities value
     * @return string[]|null
     */
    public function getCreatedPriorities()
    {
        return $this->CreatedPriorities;
    }
    /**
     * Set CreatedPriorities value
     * @throws \InvalidArgumentException
     * @param string[] $createdPriorities
     * @return \StructType\TicketSearch
     */
    public function setCreatedPriorities(array $createdPriorities = array())
    {
        foreach ($createdPriorities as $ticketSearchCreatedPrioritiesItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchCreatedPrioritiesItem)) {
                throw new \InvalidArgumentException(sprintf('The CreatedPriorities property can only contain items of string, "%s" given', is_object($ticketSearchCreatedPrioritiesItem) ? get_class($ticketSearchCreatedPrioritiesItem) : gettype($ticketSearchCreatedPrioritiesItem)), __LINE__);
            }
        }
        $this->CreatedPriorities = $createdPriorities;
        return $this;
    }
    /**
     * Add item to CreatedPriorities value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToCreatedPriorities($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CreatedPriorities property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreatedPriorities[] = $item;
        return $this;
    }
    /**
     * Get CreatedPriorityIDs value
     * @return int[]|null
     */
    public function getCreatedPriorityIDs()
    {
        return $this->CreatedPriorityIDs;
    }
    /**
     * Set CreatedPriorityIDs value
     * @throws \InvalidArgumentException
     * @param int[] $createdPriorityIDs
     * @return \StructType\TicketSearch
     */
    public function setCreatedPriorityIDs(array $createdPriorityIDs = array())
    {
        foreach ($createdPriorityIDs as $ticketSearchCreatedPriorityIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchCreatedPriorityIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The CreatedPriorityIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchCreatedPriorityIDsItem) ? get_class($ticketSearchCreatedPriorityIDsItem) : gettype($ticketSearchCreatedPriorityIDsItem)), __LINE__);
            }
        }
        $this->CreatedPriorityIDs = $createdPriorityIDs;
        return $this;
    }
    /**
     * Add item to CreatedPriorityIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToCreatedPriorityIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The CreatedPriorityIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreatedPriorityIDs[] = $item;
        return $this;
    }
    /**
     * Get CreatedStates value
     * @return string[]|null
     */
    public function getCreatedStates()
    {
        return $this->CreatedStates;
    }
    /**
     * Set CreatedStates value
     * @throws \InvalidArgumentException
     * @param string[] $createdStates
     * @return \StructType\TicketSearch
     */
    public function setCreatedStates(array $createdStates = array())
    {
        foreach ($createdStates as $ticketSearchCreatedStatesItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchCreatedStatesItem)) {
                throw new \InvalidArgumentException(sprintf('The CreatedStates property can only contain items of string, "%s" given', is_object($ticketSearchCreatedStatesItem) ? get_class($ticketSearchCreatedStatesItem) : gettype($ticketSearchCreatedStatesItem)), __LINE__);
            }
        }
        $this->CreatedStates = $createdStates;
        return $this;
    }
    /**
     * Add item to CreatedStates value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToCreatedStates($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CreatedStates property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreatedStates[] = $item;
        return $this;
    }
    /**
     * Get CreatedStateIDs value
     * @return int[]|null
     */
    public function getCreatedStateIDs()
    {
        return $this->CreatedStateIDs;
    }
    /**
     * Set CreatedStateIDs value
     * @throws \InvalidArgumentException
     * @param int[] $createdStateIDs
     * @return \StructType\TicketSearch
     */
    public function setCreatedStateIDs(array $createdStateIDs = array())
    {
        foreach ($createdStateIDs as $ticketSearchCreatedStateIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchCreatedStateIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The CreatedStateIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchCreatedStateIDsItem) ? get_class($ticketSearchCreatedStateIDsItem) : gettype($ticketSearchCreatedStateIDsItem)), __LINE__);
            }
        }
        $this->CreatedStateIDs = $createdStateIDs;
        return $this;
    }
    /**
     * Add item to CreatedStateIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToCreatedStateIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The CreatedStateIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreatedStateIDs[] = $item;
        return $this;
    }
    /**
     * Get CreatedQueues value
     * @return int[]|null
     */
    public function getCreatedQueues()
    {
        return $this->CreatedQueues;
    }
    /**
     * Set CreatedQueues value
     * @throws \InvalidArgumentException
     * @param int[] $createdQueues
     * @return \StructType\TicketSearch
     */
    public function setCreatedQueues(array $createdQueues = array())
    {
        foreach ($createdQueues as $ticketSearchCreatedQueuesItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchCreatedQueuesItem)) {
                throw new \InvalidArgumentException(sprintf('The CreatedQueues property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchCreatedQueuesItem) ? get_class($ticketSearchCreatedQueuesItem) : gettype($ticketSearchCreatedQueuesItem)), __LINE__);
            }
        }
        $this->CreatedQueues = $createdQueues;
        return $this;
    }
    /**
     * Add item to CreatedQueues value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToCreatedQueues($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The CreatedQueues property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreatedQueues[] = $item;
        return $this;
    }
    /**
     * Get CreatedQueueIDs value
     * @return int[]|null
     */
    public function getCreatedQueueIDs()
    {
        return $this->CreatedQueueIDs;
    }
    /**
     * Set CreatedQueueIDs value
     * @throws \InvalidArgumentException
     * @param int[] $createdQueueIDs
     * @return \StructType\TicketSearch
     */
    public function setCreatedQueueIDs(array $createdQueueIDs = array())
    {
        foreach ($createdQueueIDs as $ticketSearchCreatedQueueIDsItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchCreatedQueueIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The CreatedQueueIDs property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchCreatedQueueIDsItem) ? get_class($ticketSearchCreatedQueueIDsItem) : gettype($ticketSearchCreatedQueueIDsItem)), __LINE__);
            }
        }
        $this->CreatedQueueIDs = $createdQueueIDs;
        return $this;
    }
    /**
     * Add item to CreatedQueueIDs value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToCreatedQueueIDs($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The CreatedQueueIDs property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreatedQueueIDs[] = $item;
        return $this;
    }
    /**
     * Get DynamicField value
     * @return \StructType\OTRS_TicketSearch_DynamicField[]|null
     */
    public function getDynamicField()
    {
        return $this->DynamicField;
    }
    /**
     * Set DynamicField value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_TicketSearch_DynamicField[] $dynamicField
     * @return \StructType\TicketSearch
     */
    public function setDynamicField(array $dynamicField = array())
    {
        foreach ($dynamicField as $ticketSearchDynamicFieldItem) {
            // validation for constraint: itemType
            if (!$ticketSearchDynamicFieldItem instanceof \StructType\OTRS_TicketSearch_DynamicField) {
                throw new \InvalidArgumentException(sprintf('The DynamicField property can only contain items of \StructType\OTRS_TicketSearch_DynamicField, "%s" given', is_object($ticketSearchDynamicFieldItem) ? get_class($ticketSearchDynamicFieldItem) : gettype($ticketSearchDynamicFieldItem)), __LINE__);
            }
        }
        $this->DynamicField = $dynamicField;
        return $this;
    }
    /**
     * Add item to DynamicField value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_TicketSearch_DynamicField $item
     * @return \StructType\TicketSearch
     */
    public function addToDynamicField(\StructType\OTRS_TicketSearch_DynamicField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OTRS_TicketSearch_DynamicField) {
            throw new \InvalidArgumentException(sprintf('The DynamicField property can only contain items of \StructType\OTRS_TicketSearch_DynamicField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DynamicField[] = $item;
        return $this;
    }
    /**
     * Get Ticketflag value
     * @return \StructType\OTRS_TicketSearch_TicketFlag|null
     */
    public function getTicketflag()
    {
        return $this->Ticketflag;
    }
    /**
     * Set Ticketflag value
     * @param \StructType\OTRS_TicketSearch_TicketFlag $ticketflag
     * @return \StructType\TicketSearch
     */
    public function setTicketflag(\StructType\OTRS_TicketSearch_TicketFlag $ticketflag = null)
    {
        $this->Ticketflag = $ticketflag;
        return $this;
    }
    /**
     * Get MIMEBase_From value
     * @return string|null
     */
    public function getMIMEBase_From()
    {
        return $this->MIMEBase_From;
    }
    /**
     * Set MIMEBase_From value
     * @param string $mIMEBase_From
     * @return \StructType\TicketSearch
     */
    public function setMIMEBase_From($mIMEBase_From = null)
    {
        // validation for constraint: string
        if (!is_null($mIMEBase_From) && !is_string($mIMEBase_From)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mIMEBase_From)), __LINE__);
        }
        $this->MIMEBase_From = $mIMEBase_From;
        return $this;
    }
    /**
     * Get MIMEBase_To value
     * @return string|null
     */
    public function getMIMEBase_To()
    {
        return $this->MIMEBase_To;
    }
    /**
     * Set MIMEBase_To value
     * @param string $mIMEBase_To
     * @return \StructType\TicketSearch
     */
    public function setMIMEBase_To($mIMEBase_To = null)
    {
        // validation for constraint: string
        if (!is_null($mIMEBase_To) && !is_string($mIMEBase_To)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mIMEBase_To)), __LINE__);
        }
        $this->MIMEBase_To = $mIMEBase_To;
        return $this;
    }
    /**
     * Get MIMEBase_Cc value
     * @return string|null
     */
    public function getMIMEBase_Cc()
    {
        return $this->MIMEBase_Cc;
    }
    /**
     * Set MIMEBase_Cc value
     * @param string $mIMEBase_Cc
     * @return \StructType\TicketSearch
     */
    public function setMIMEBase_Cc($mIMEBase_Cc = null)
    {
        // validation for constraint: string
        if (!is_null($mIMEBase_Cc) && !is_string($mIMEBase_Cc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mIMEBase_Cc)), __LINE__);
        }
        $this->MIMEBase_Cc = $mIMEBase_Cc;
        return $this;
    }
    /**
     * Get MIMEBase_Subject value
     * @return string|null
     */
    public function getMIMEBase_Subject()
    {
        return $this->MIMEBase_Subject;
    }
    /**
     * Set MIMEBase_Subject value
     * @param string $mIMEBase_Subject
     * @return \StructType\TicketSearch
     */
    public function setMIMEBase_Subject($mIMEBase_Subject = null)
    {
        // validation for constraint: string
        if (!is_null($mIMEBase_Subject) && !is_string($mIMEBase_Subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mIMEBase_Subject)), __LINE__);
        }
        $this->MIMEBase_Subject = $mIMEBase_Subject;
        return $this;
    }
    /**
     * Get MIMEBase_Body value
     * @return string|null
     */
    public function getMIMEBase_Body()
    {
        return $this->MIMEBase_Body;
    }
    /**
     * Set MIMEBase_Body value
     * @param string $mIMEBase_Body
     * @return \StructType\TicketSearch
     */
    public function setMIMEBase_Body($mIMEBase_Body = null)
    {
        // validation for constraint: string
        if (!is_null($mIMEBase_Body) && !is_string($mIMEBase_Body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mIMEBase_Body)), __LINE__);
        }
        $this->MIMEBase_Body = $mIMEBase_Body;
        return $this;
    }
    /**
     * Get FullTextIndex value
     * @return int|null
     */
    public function getFullTextIndex()
    {
        return $this->FullTextIndex;
    }
    /**
     * Set FullTextIndex value
     * @param int $fullTextIndex
     * @return \StructType\TicketSearch
     */
    public function setFullTextIndex($fullTextIndex = null)
    {
        // validation for constraint: int
        if (!is_null($fullTextIndex) && !is_numeric($fullTextIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fullTextIndex)), __LINE__);
        }
        $this->FullTextIndex = $fullTextIndex;
        return $this;
    }
    /**
     * Get ContentSearch value
     * @return string|null
     */
    public function getContentSearch()
    {
        return $this->ContentSearch;
    }
    /**
     * Set ContentSearch value
     * @param string $contentSearch
     * @return \StructType\TicketSearch
     */
    public function setContentSearch($contentSearch = null)
    {
        // validation for constraint: string
        if (!is_null($contentSearch) && !is_string($contentSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentSearch)), __LINE__);
        }
        $this->ContentSearch = $contentSearch;
        return $this;
    }
    /**
     * Get ConditionInline value
     * @return int|null
     */
    public function getConditionInline()
    {
        return $this->ConditionInline;
    }
    /**
     * Set ConditionInline value
     * @param int $conditionInline
     * @return \StructType\TicketSearch
     */
    public function setConditionInline($conditionInline = null)
    {
        // validation for constraint: int
        if (!is_null($conditionInline) && !is_numeric($conditionInline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($conditionInline)), __LINE__);
        }
        $this->ConditionInline = $conditionInline;
        return $this;
    }
    /**
     * Get ArticleCreateTimeOlderMinutes value
     * @return int|null
     */
    public function getArticleCreateTimeOlderMinutes()
    {
        return $this->ArticleCreateTimeOlderMinutes;
    }
    /**
     * Set ArticleCreateTimeOlderMinutes value
     * @param int $articleCreateTimeOlderMinutes
     * @return \StructType\TicketSearch
     */
    public function setArticleCreateTimeOlderMinutes($articleCreateTimeOlderMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($articleCreateTimeOlderMinutes) && !is_numeric($articleCreateTimeOlderMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($articleCreateTimeOlderMinutes)), __LINE__);
        }
        $this->ArticleCreateTimeOlderMinutes = $articleCreateTimeOlderMinutes;
        return $this;
    }
    /**
     * Get ArticleCreateTimeNewerMinutes value
     * @return int|null
     */
    public function getArticleCreateTimeNewerMinutes()
    {
        return $this->ArticleCreateTimeNewerMinutes;
    }
    /**
     * Set ArticleCreateTimeNewerMinutes value
     * @param int $articleCreateTimeNewerMinutes
     * @return \StructType\TicketSearch
     */
    public function setArticleCreateTimeNewerMinutes($articleCreateTimeNewerMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($articleCreateTimeNewerMinutes) && !is_numeric($articleCreateTimeNewerMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($articleCreateTimeNewerMinutes)), __LINE__);
        }
        $this->ArticleCreateTimeNewerMinutes = $articleCreateTimeNewerMinutes;
        return $this;
    }
    /**
     * Get ArticleCreateTimeNewerDate value
     * @return string|null
     */
    public function getArticleCreateTimeNewerDate()
    {
        return $this->ArticleCreateTimeNewerDate;
    }
    /**
     * Set ArticleCreateTimeNewerDate value
     * @param string $articleCreateTimeNewerDate
     * @return \StructType\TicketSearch
     */
    public function setArticleCreateTimeNewerDate($articleCreateTimeNewerDate = null)
    {
        // validation for constraint: string
        if (!is_null($articleCreateTimeNewerDate) && !is_string($articleCreateTimeNewerDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($articleCreateTimeNewerDate)), __LINE__);
        }
        $this->ArticleCreateTimeNewerDate = $articleCreateTimeNewerDate;
        return $this;
    }
    /**
     * Get ArticleCreateTimeOlderDate value
     * @return string|null
     */
    public function getArticleCreateTimeOlderDate()
    {
        return $this->ArticleCreateTimeOlderDate;
    }
    /**
     * Set ArticleCreateTimeOlderDate value
     * @param string $articleCreateTimeOlderDate
     * @return \StructType\TicketSearch
     */
    public function setArticleCreateTimeOlderDate($articleCreateTimeOlderDate = null)
    {
        // validation for constraint: string
        if (!is_null($articleCreateTimeOlderDate) && !is_string($articleCreateTimeOlderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($articleCreateTimeOlderDate)), __LINE__);
        }
        $this->ArticleCreateTimeOlderDate = $articleCreateTimeOlderDate;
        return $this;
    }
    /**
     * Get TicketCreateTimeOlderMinutes value
     * @return int|null
     */
    public function getTicketCreateTimeOlderMinutes()
    {
        return $this->TicketCreateTimeOlderMinutes;
    }
    /**
     * Set TicketCreateTimeOlderMinutes value
     * @param int $ticketCreateTimeOlderMinutes
     * @return \StructType\TicketSearch
     */
    public function setTicketCreateTimeOlderMinutes($ticketCreateTimeOlderMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($ticketCreateTimeOlderMinutes) && !is_numeric($ticketCreateTimeOlderMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketCreateTimeOlderMinutes)), __LINE__);
        }
        $this->TicketCreateTimeOlderMinutes = $ticketCreateTimeOlderMinutes;
        return $this;
    }
    /**
     * Get TicketCreateTimeNewerMinutes value
     * @return int|null
     */
    public function getTicketCreateTimeNewerMinutes()
    {
        return $this->TicketCreateTimeNewerMinutes;
    }
    /**
     * Set TicketCreateTimeNewerMinutes value
     * @param int $ticketCreateTimeNewerMinutes
     * @return \StructType\TicketSearch
     */
    public function setTicketCreateTimeNewerMinutes($ticketCreateTimeNewerMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($ticketCreateTimeNewerMinutes) && !is_numeric($ticketCreateTimeNewerMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketCreateTimeNewerMinutes)), __LINE__);
        }
        $this->TicketCreateTimeNewerMinutes = $ticketCreateTimeNewerMinutes;
        return $this;
    }
    /**
     * Get TicketCreateTimeNewerDate value
     * @return string|null
     */
    public function getTicketCreateTimeNewerDate()
    {
        return $this->TicketCreateTimeNewerDate;
    }
    /**
     * Set TicketCreateTimeNewerDate value
     * @param string $ticketCreateTimeNewerDate
     * @return \StructType\TicketSearch
     */
    public function setTicketCreateTimeNewerDate($ticketCreateTimeNewerDate = null)
    {
        // validation for constraint: string
        if (!is_null($ticketCreateTimeNewerDate) && !is_string($ticketCreateTimeNewerDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketCreateTimeNewerDate)), __LINE__);
        }
        $this->TicketCreateTimeNewerDate = $ticketCreateTimeNewerDate;
        return $this;
    }
    /**
     * Get TicketCreateTimeOlderDate value
     * @return string|null
     */
    public function getTicketCreateTimeOlderDate()
    {
        return $this->TicketCreateTimeOlderDate;
    }
    /**
     * Set TicketCreateTimeOlderDate value
     * @param string $ticketCreateTimeOlderDate
     * @return \StructType\TicketSearch
     */
    public function setTicketCreateTimeOlderDate($ticketCreateTimeOlderDate = null)
    {
        // validation for constraint: string
        if (!is_null($ticketCreateTimeOlderDate) && !is_string($ticketCreateTimeOlderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketCreateTimeOlderDate)), __LINE__);
        }
        $this->TicketCreateTimeOlderDate = $ticketCreateTimeOlderDate;
        return $this;
    }
    /**
     * Get TicketChangeTimeOlderMinutes value
     * @return int|null
     */
    public function getTicketChangeTimeOlderMinutes()
    {
        return $this->TicketChangeTimeOlderMinutes;
    }
    /**
     * Set TicketChangeTimeOlderMinutes value
     * @param int $ticketChangeTimeOlderMinutes
     * @return \StructType\TicketSearch
     */
    public function setTicketChangeTimeOlderMinutes($ticketChangeTimeOlderMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($ticketChangeTimeOlderMinutes) && !is_numeric($ticketChangeTimeOlderMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketChangeTimeOlderMinutes)), __LINE__);
        }
        $this->TicketChangeTimeOlderMinutes = $ticketChangeTimeOlderMinutes;
        return $this;
    }
    /**
     * Get TicketChangeTimeNewerMinutes value
     * @return int|null
     */
    public function getTicketChangeTimeNewerMinutes()
    {
        return $this->TicketChangeTimeNewerMinutes;
    }
    /**
     * Set TicketChangeTimeNewerMinutes value
     * @param int $ticketChangeTimeNewerMinutes
     * @return \StructType\TicketSearch
     */
    public function setTicketChangeTimeNewerMinutes($ticketChangeTimeNewerMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($ticketChangeTimeNewerMinutes) && !is_numeric($ticketChangeTimeNewerMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketChangeTimeNewerMinutes)), __LINE__);
        }
        $this->TicketChangeTimeNewerMinutes = $ticketChangeTimeNewerMinutes;
        return $this;
    }
    /**
     * Get TicketChangeTimeNewerDate value
     * @return string|null
     */
    public function getTicketChangeTimeNewerDate()
    {
        return $this->TicketChangeTimeNewerDate;
    }
    /**
     * Set TicketChangeTimeNewerDate value
     * @param string $ticketChangeTimeNewerDate
     * @return \StructType\TicketSearch
     */
    public function setTicketChangeTimeNewerDate($ticketChangeTimeNewerDate = null)
    {
        // validation for constraint: string
        if (!is_null($ticketChangeTimeNewerDate) && !is_string($ticketChangeTimeNewerDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketChangeTimeNewerDate)), __LINE__);
        }
        $this->TicketChangeTimeNewerDate = $ticketChangeTimeNewerDate;
        return $this;
    }
    /**
     * Get TicketChangeTimeOlderDate value
     * @return string|null
     */
    public function getTicketChangeTimeOlderDate()
    {
        return $this->TicketChangeTimeOlderDate;
    }
    /**
     * Set TicketChangeTimeOlderDate value
     * @param string $ticketChangeTimeOlderDate
     * @return \StructType\TicketSearch
     */
    public function setTicketChangeTimeOlderDate($ticketChangeTimeOlderDate = null)
    {
        // validation for constraint: string
        if (!is_null($ticketChangeTimeOlderDate) && !is_string($ticketChangeTimeOlderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketChangeTimeOlderDate)), __LINE__);
        }
        $this->TicketChangeTimeOlderDate = $ticketChangeTimeOlderDate;
        return $this;
    }
    /**
     * Get TicketLastChangeTimeOlderMinutes value
     * @return int|null
     */
    public function getTicketLastChangeTimeOlderMinutes()
    {
        return $this->TicketLastChangeTimeOlderMinutes;
    }
    /**
     * Set TicketLastChangeTimeOlderMinutes value
     * @param int $ticketLastChangeTimeOlderMinutes
     * @return \StructType\TicketSearch
     */
    public function setTicketLastChangeTimeOlderMinutes($ticketLastChangeTimeOlderMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($ticketLastChangeTimeOlderMinutes) && !is_numeric($ticketLastChangeTimeOlderMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketLastChangeTimeOlderMinutes)), __LINE__);
        }
        $this->TicketLastChangeTimeOlderMinutes = $ticketLastChangeTimeOlderMinutes;
        return $this;
    }
    /**
     * Get TicketLastChangeTimeNewerMinutes value
     * @return int|null
     */
    public function getTicketLastChangeTimeNewerMinutes()
    {
        return $this->TicketLastChangeTimeNewerMinutes;
    }
    /**
     * Set TicketLastChangeTimeNewerMinutes value
     * @param int $ticketLastChangeTimeNewerMinutes
     * @return \StructType\TicketSearch
     */
    public function setTicketLastChangeTimeNewerMinutes($ticketLastChangeTimeNewerMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($ticketLastChangeTimeNewerMinutes) && !is_numeric($ticketLastChangeTimeNewerMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketLastChangeTimeNewerMinutes)), __LINE__);
        }
        $this->TicketLastChangeTimeNewerMinutes = $ticketLastChangeTimeNewerMinutes;
        return $this;
    }
    /**
     * Get TicketLastChangeTimeNewerDate value
     * @return string|null
     */
    public function getTicketLastChangeTimeNewerDate()
    {
        return $this->TicketLastChangeTimeNewerDate;
    }
    /**
     * Set TicketLastChangeTimeNewerDate value
     * @param string $ticketLastChangeTimeNewerDate
     * @return \StructType\TicketSearch
     */
    public function setTicketLastChangeTimeNewerDate($ticketLastChangeTimeNewerDate = null)
    {
        // validation for constraint: string
        if (!is_null($ticketLastChangeTimeNewerDate) && !is_string($ticketLastChangeTimeNewerDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketLastChangeTimeNewerDate)), __LINE__);
        }
        $this->TicketLastChangeTimeNewerDate = $ticketLastChangeTimeNewerDate;
        return $this;
    }
    /**
     * Get TicketLastChangeTimeOlderDate value
     * @return string|null
     */
    public function getTicketLastChangeTimeOlderDate()
    {
        return $this->TicketLastChangeTimeOlderDate;
    }
    /**
     * Set TicketLastChangeTimeOlderDate value
     * @param string $ticketLastChangeTimeOlderDate
     * @return \StructType\TicketSearch
     */
    public function setTicketLastChangeTimeOlderDate($ticketLastChangeTimeOlderDate = null)
    {
        // validation for constraint: string
        if (!is_null($ticketLastChangeTimeOlderDate) && !is_string($ticketLastChangeTimeOlderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketLastChangeTimeOlderDate)), __LINE__);
        }
        $this->TicketLastChangeTimeOlderDate = $ticketLastChangeTimeOlderDate;
        return $this;
    }
    /**
     * Get TicketCloseTimeOlderMinutes value
     * @return int|null
     */
    public function getTicketCloseTimeOlderMinutes()
    {
        return $this->TicketCloseTimeOlderMinutes;
    }
    /**
     * Set TicketCloseTimeOlderMinutes value
     * @param int $ticketCloseTimeOlderMinutes
     * @return \StructType\TicketSearch
     */
    public function setTicketCloseTimeOlderMinutes($ticketCloseTimeOlderMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($ticketCloseTimeOlderMinutes) && !is_numeric($ticketCloseTimeOlderMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketCloseTimeOlderMinutes)), __LINE__);
        }
        $this->TicketCloseTimeOlderMinutes = $ticketCloseTimeOlderMinutes;
        return $this;
    }
    /**
     * Get TicketCloseTimeNewerMinutes value
     * @return int|null
     */
    public function getTicketCloseTimeNewerMinutes()
    {
        return $this->TicketCloseTimeNewerMinutes;
    }
    /**
     * Set TicketCloseTimeNewerMinutes value
     * @param int $ticketCloseTimeNewerMinutes
     * @return \StructType\TicketSearch
     */
    public function setTicketCloseTimeNewerMinutes($ticketCloseTimeNewerMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($ticketCloseTimeNewerMinutes) && !is_numeric($ticketCloseTimeNewerMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketCloseTimeNewerMinutes)), __LINE__);
        }
        $this->TicketCloseTimeNewerMinutes = $ticketCloseTimeNewerMinutes;
        return $this;
    }
    /**
     * Get TicketCloseTimeNewerDate value
     * @return string|null
     */
    public function getTicketCloseTimeNewerDate()
    {
        return $this->TicketCloseTimeNewerDate;
    }
    /**
     * Set TicketCloseTimeNewerDate value
     * @param string $ticketCloseTimeNewerDate
     * @return \StructType\TicketSearch
     */
    public function setTicketCloseTimeNewerDate($ticketCloseTimeNewerDate = null)
    {
        // validation for constraint: string
        if (!is_null($ticketCloseTimeNewerDate) && !is_string($ticketCloseTimeNewerDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketCloseTimeNewerDate)), __LINE__);
        }
        $this->TicketCloseTimeNewerDate = $ticketCloseTimeNewerDate;
        return $this;
    }
    /**
     * Get TicketCloseTimeOlderDate value
     * @return string|null
     */
    public function getTicketCloseTimeOlderDate()
    {
        return $this->TicketCloseTimeOlderDate;
    }
    /**
     * Set TicketCloseTimeOlderDate value
     * @param string $ticketCloseTimeOlderDate
     * @return \StructType\TicketSearch
     */
    public function setTicketCloseTimeOlderDate($ticketCloseTimeOlderDate = null)
    {
        // validation for constraint: string
        if (!is_null($ticketCloseTimeOlderDate) && !is_string($ticketCloseTimeOlderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketCloseTimeOlderDate)), __LINE__);
        }
        $this->TicketCloseTimeOlderDate = $ticketCloseTimeOlderDate;
        return $this;
    }
    /**
     * Get TicketPendingTimeOlderMinutes value
     * @return int|null
     */
    public function getTicketPendingTimeOlderMinutes()
    {
        return $this->TicketPendingTimeOlderMinutes;
    }
    /**
     * Set TicketPendingTimeOlderMinutes value
     * @param int $ticketPendingTimeOlderMinutes
     * @return \StructType\TicketSearch
     */
    public function setTicketPendingTimeOlderMinutes($ticketPendingTimeOlderMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($ticketPendingTimeOlderMinutes) && !is_numeric($ticketPendingTimeOlderMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketPendingTimeOlderMinutes)), __LINE__);
        }
        $this->TicketPendingTimeOlderMinutes = $ticketPendingTimeOlderMinutes;
        return $this;
    }
    /**
     * Get TicketPendingTimeNewerMinutes value
     * @return int|null
     */
    public function getTicketPendingTimeNewerMinutes()
    {
        return $this->TicketPendingTimeNewerMinutes;
    }
    /**
     * Set TicketPendingTimeNewerMinutes value
     * @param int $ticketPendingTimeNewerMinutes
     * @return \StructType\TicketSearch
     */
    public function setTicketPendingTimeNewerMinutes($ticketPendingTimeNewerMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($ticketPendingTimeNewerMinutes) && !is_numeric($ticketPendingTimeNewerMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketPendingTimeNewerMinutes)), __LINE__);
        }
        $this->TicketPendingTimeNewerMinutes = $ticketPendingTimeNewerMinutes;
        return $this;
    }
    /**
     * Get TicketPendingTimeNewerDate value
     * @return string|null
     */
    public function getTicketPendingTimeNewerDate()
    {
        return $this->TicketPendingTimeNewerDate;
    }
    /**
     * Set TicketPendingTimeNewerDate value
     * @param string $ticketPendingTimeNewerDate
     * @return \StructType\TicketSearch
     */
    public function setTicketPendingTimeNewerDate($ticketPendingTimeNewerDate = null)
    {
        // validation for constraint: string
        if (!is_null($ticketPendingTimeNewerDate) && !is_string($ticketPendingTimeNewerDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketPendingTimeNewerDate)), __LINE__);
        }
        $this->TicketPendingTimeNewerDate = $ticketPendingTimeNewerDate;
        return $this;
    }
    /**
     * Get TicketPendingTimeOlderDate value
     * @return string|null
     */
    public function getTicketPendingTimeOlderDate()
    {
        return $this->TicketPendingTimeOlderDate;
    }
    /**
     * Set TicketPendingTimeOlderDate value
     * @param string $ticketPendingTimeOlderDate
     * @return \StructType\TicketSearch
     */
    public function setTicketPendingTimeOlderDate($ticketPendingTimeOlderDate = null)
    {
        // validation for constraint: string
        if (!is_null($ticketPendingTimeOlderDate) && !is_string($ticketPendingTimeOlderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketPendingTimeOlderDate)), __LINE__);
        }
        $this->TicketPendingTimeOlderDate = $ticketPendingTimeOlderDate;
        return $this;
    }
    /**
     * Get TicketEscalationTimeOlderMinutes value
     * @return int|null
     */
    public function getTicketEscalationTimeOlderMinutes()
    {
        return $this->TicketEscalationTimeOlderMinutes;
    }
    /**
     * Set TicketEscalationTimeOlderMinutes value
     * @param int $ticketEscalationTimeOlderMinutes
     * @return \StructType\TicketSearch
     */
    public function setTicketEscalationTimeOlderMinutes($ticketEscalationTimeOlderMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($ticketEscalationTimeOlderMinutes) && !is_numeric($ticketEscalationTimeOlderMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketEscalationTimeOlderMinutes)), __LINE__);
        }
        $this->TicketEscalationTimeOlderMinutes = $ticketEscalationTimeOlderMinutes;
        return $this;
    }
    /**
     * Get TicketEscalationTimeNewerMinutes value
     * @return int|null
     */
    public function getTicketEscalationTimeNewerMinutes()
    {
        return $this->TicketEscalationTimeNewerMinutes;
    }
    /**
     * Set TicketEscalationTimeNewerMinutes value
     * @param int $ticketEscalationTimeNewerMinutes
     * @return \StructType\TicketSearch
     */
    public function setTicketEscalationTimeNewerMinutes($ticketEscalationTimeNewerMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($ticketEscalationTimeNewerMinutes) && !is_numeric($ticketEscalationTimeNewerMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketEscalationTimeNewerMinutes)), __LINE__);
        }
        $this->TicketEscalationTimeNewerMinutes = $ticketEscalationTimeNewerMinutes;
        return $this;
    }
    /**
     * Get TicketEscalationTimeNewerDate value
     * @return string|null
     */
    public function getTicketEscalationTimeNewerDate()
    {
        return $this->TicketEscalationTimeNewerDate;
    }
    /**
     * Set TicketEscalationTimeNewerDate value
     * @param string $ticketEscalationTimeNewerDate
     * @return \StructType\TicketSearch
     */
    public function setTicketEscalationTimeNewerDate($ticketEscalationTimeNewerDate = null)
    {
        // validation for constraint: string
        if (!is_null($ticketEscalationTimeNewerDate) && !is_string($ticketEscalationTimeNewerDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketEscalationTimeNewerDate)), __LINE__);
        }
        $this->TicketEscalationTimeNewerDate = $ticketEscalationTimeNewerDate;
        return $this;
    }
    /**
     * Get TicketEscalationTimeOlderDate value
     * @return string|null
     */
    public function getTicketEscalationTimeOlderDate()
    {
        return $this->TicketEscalationTimeOlderDate;
    }
    /**
     * Set TicketEscalationTimeOlderDate value
     * @param string $ticketEscalationTimeOlderDate
     * @return \StructType\TicketSearch
     */
    public function setTicketEscalationTimeOlderDate($ticketEscalationTimeOlderDate = null)
    {
        // validation for constraint: string
        if (!is_null($ticketEscalationTimeOlderDate) && !is_string($ticketEscalationTimeOlderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketEscalationTimeOlderDate)), __LINE__);
        }
        $this->TicketEscalationTimeOlderDate = $ticketEscalationTimeOlderDate;
        return $this;
    }
    /**
     * Get ArchiveFlags value
     * @return string|null
     */
    public function getArchiveFlags()
    {
        return $this->ArchiveFlags;
    }
    /**
     * Set ArchiveFlags value
     * @param string $archiveFlags
     * @return \StructType\TicketSearch
     */
    public function setArchiveFlags($archiveFlags = null)
    {
        // validation for constraint: string
        if (!is_null($archiveFlags) && !is_string($archiveFlags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($archiveFlags)), __LINE__);
        }
        $this->ArchiveFlags = $archiveFlags;
        return $this;
    }
    /**
     * Get OrderBy value
     * @return string[]|null
     */
    public function getOrderBy()
    {
        return $this->OrderBy;
    }
    /**
     * Set OrderBy value
     * @throws \InvalidArgumentException
     * @param string[] $orderBy
     * @return \StructType\TicketSearch
     */
    public function setOrderBy(array $orderBy = array())
    {
        foreach ($orderBy as $ticketSearchOrderByItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchOrderByItem)) {
                throw new \InvalidArgumentException(sprintf('The OrderBy property can only contain items of string, "%s" given', is_object($ticketSearchOrderByItem) ? get_class($ticketSearchOrderByItem) : gettype($ticketSearchOrderByItem)), __LINE__);
            }
        }
        $this->OrderBy = $orderBy;
        return $this;
    }
    /**
     * Add item to OrderBy value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToOrderBy($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OrderBy property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderBy[] = $item;
        return $this;
    }
    /**
     * Get SortBy value
     * @return int[]|null
     */
    public function getSortBy()
    {
        return $this->SortBy;
    }
    /**
     * Set SortBy value
     * @throws \InvalidArgumentException
     * @param int[] $sortBy
     * @return \StructType\TicketSearch
     */
    public function setSortBy(array $sortBy = array())
    {
        foreach ($sortBy as $ticketSearchSortByItem) {
            // validation for constraint: itemType
            if (!is_numeric($ticketSearchSortByItem)) {
                throw new \InvalidArgumentException(sprintf('The SortBy property can only contain items of positiveInteger, "%s" given', is_object($ticketSearchSortByItem) ? get_class($ticketSearchSortByItem) : gettype($ticketSearchSortByItem)), __LINE__);
            }
        }
        $this->SortBy = $sortBy;
        return $this;
    }
    /**
     * Add item to SortBy value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TicketSearch
     */
    public function addToSortBy($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The SortBy property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SortBy[] = $item;
        return $this;
    }
    /**
     * Get CustomerUserID value
     * @return string[]|null
     */
    public function getCustomerUserID()
    {
        return $this->CustomerUserID;
    }
    /**
     * Set CustomerUserID value
     * @throws \InvalidArgumentException
     * @param string[] $customerUserID
     * @return \StructType\TicketSearch
     */
    public function setCustomerUserID(array $customerUserID = array())
    {
        foreach ($customerUserID as $ticketSearchCustomerUserIDItem) {
            // validation for constraint: itemType
            if (!is_string($ticketSearchCustomerUserIDItem)) {
                throw new \InvalidArgumentException(sprintf('The CustomerUserID property can only contain items of string, "%s" given', is_object($ticketSearchCustomerUserIDItem) ? get_class($ticketSearchCustomerUserIDItem) : gettype($ticketSearchCustomerUserIDItem)), __LINE__);
            }
        }
        $this->CustomerUserID = $customerUserID;
        return $this;
    }
    /**
     * Add item to CustomerUserID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TicketSearch
     */
    public function addToCustomerUserID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CustomerUserID property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerUserID[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketSearch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
