<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketGetResponse StructType
 * @subpackage Structs
 */
class TicketGetResponse extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OTRS_TicketGetResponse_Ticket[]
     */
    public $Ticket;
    /**
     * Constructor method for TicketGetResponse
     * @uses TicketGetResponse::setTicket()
     * @param \StructType\OTRS_TicketGetResponse_Ticket[] $ticket
     */
    public function __construct(array $ticket = array())
    {
        $this
            ->setTicket($ticket);
    }
    /**
     * Get Ticket value
     * @return \StructType\OTRS_TicketGetResponse_Ticket[]|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_TicketGetResponse_Ticket[] $ticket
     * @return \StructType\TicketGetResponse
     */
    public function setTicket(array $ticket = array())
    {
        foreach ($ticket as $ticketGetResponseTicketItem) {
            // validation for constraint: itemType
            if (!$ticketGetResponseTicketItem instanceof \StructType\OTRS_TicketGetResponse_Ticket) {
                throw new \InvalidArgumentException(sprintf('The Ticket property can only contain items of \StructType\OTRS_TicketGetResponse_Ticket, "%s" given', is_object($ticketGetResponseTicketItem) ? get_class($ticketGetResponseTicketItem) : gettype($ticketGetResponseTicketItem)), __LINE__);
            }
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Add item to Ticket value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_TicketGetResponse_Ticket $item
     * @return \StructType\TicketGetResponse
     */
    public function addToTicket(\StructType\OTRS_TicketGetResponse_Ticket $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OTRS_TicketGetResponse_Ticket) {
            throw new \InvalidArgumentException(sprintf('The Ticket property can only contain items of \StructType\OTRS_TicketGetResponse_Ticket, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Ticket[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketGetResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
