<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SessionGetResponse StructType
 * @subpackage Structs
 */
class SessionGetResponse extends AbstractStructBase
{
    /**
     * The SessionData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OTRS_SessionGetResponse_SessionData[]
     */
    public $SessionData;
    /**
     * Constructor method for SessionGetResponse
     * @uses SessionGetResponse::setSessionData()
     * @param \StructType\OTRS_SessionGetResponse_SessionData[] $sessionData
     */
    public function __construct(array $sessionData = array())
    {
        $this
            ->setSessionData($sessionData);
    }
    /**
     * Get SessionData value
     * @return \StructType\OTRS_SessionGetResponse_SessionData[]
     */
    public function getSessionData()
    {
        return $this->SessionData;
    }
    /**
     * Set SessionData value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_SessionGetResponse_SessionData[] $sessionData
     * @return \StructType\SessionGetResponse
     */
    public function setSessionData(array $sessionData = array())
    {
        foreach ($sessionData as $sessionGetResponseSessionDataItem) {
            // validation for constraint: itemType
            if (!$sessionGetResponseSessionDataItem instanceof \StructType\OTRS_SessionGetResponse_SessionData) {
                throw new \InvalidArgumentException(sprintf('The SessionData property can only contain items of \StructType\OTRS_SessionGetResponse_SessionData, "%s" given', is_object($sessionGetResponseSessionDataItem) ? get_class($sessionGetResponseSessionDataItem) : gettype($sessionGetResponseSessionDataItem)), __LINE__);
            }
        }
        $this->SessionData = $sessionData;
        return $this;
    }
    /**
     * Add item to SessionData value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_SessionGetResponse_SessionData $item
     * @return \StructType\SessionGetResponse
     */
    public function addToSessionData(\StructType\OTRS_SessionGetResponse_SessionData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OTRS_SessionGetResponse_SessionData) {
            throw new \InvalidArgumentException(sprintf('The SessionData property can only contain items of \StructType\OTRS_SessionGetResponse_SessionData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SessionData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SessionGetResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
