<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTRS_TicketHistoryGetResponse_TicketHistory StructType
 * @subpackage Structs
 */
class OTRS_TicketHistoryGetResponse_TicketHistory extends AbstractStructBase
{
    /**
     * The History
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OTRS_TicketHistoryGetResponse_TicketHistoryElement[]
     */
    public $History;
    /**
     * The TicketID
     * @var int
     */
    public $TicketID;
    /**
     * Constructor method for OTRS_TicketHistoryGetResponse_TicketHistory
     * @uses OTRS_TicketHistoryGetResponse_TicketHistory::setHistory()
     * @uses OTRS_TicketHistoryGetResponse_TicketHistory::setTicketID()
     * @param \StructType\OTRS_TicketHistoryGetResponse_TicketHistoryElement[] $history
     * @param int $ticketID
     */
    public function __construct(array $history = array(), $ticketID = null)
    {
        $this
            ->setHistory($history)
            ->setTicketID($ticketID);
    }
    /**
     * Get History value
     * @return \StructType\OTRS_TicketHistoryGetResponse_TicketHistoryElement[]
     */
    public function getHistory()
    {
        return $this->History;
    }
    /**
     * Set History value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_TicketHistoryGetResponse_TicketHistoryElement[] $history
     * @return \StructType\OTRS_TicketHistoryGetResponse_TicketHistory
     */
    public function setHistory(array $history = array())
    {
        foreach ($history as $oTRS_TicketHistoryGetResponse_TicketHistoryHistoryItem) {
            // validation for constraint: itemType
            if (!$oTRS_TicketHistoryGetResponse_TicketHistoryHistoryItem instanceof \StructType\OTRS_TicketHistoryGetResponse_TicketHistoryElement) {
                throw new \InvalidArgumentException(sprintf('The History property can only contain items of \StructType\OTRS_TicketHistoryGetResponse_TicketHistoryElement, "%s" given', is_object($oTRS_TicketHistoryGetResponse_TicketHistoryHistoryItem) ? get_class($oTRS_TicketHistoryGetResponse_TicketHistoryHistoryItem) : gettype($oTRS_TicketHistoryGetResponse_TicketHistoryHistoryItem)), __LINE__);
            }
        }
        $this->History = $history;
        return $this;
    }
    /**
     * Add item to History value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_TicketHistoryGetResponse_TicketHistoryElement $item
     * @return \StructType\OTRS_TicketHistoryGetResponse_TicketHistory
     */
    public function addToHistory(\StructType\OTRS_TicketHistoryGetResponse_TicketHistoryElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OTRS_TicketHistoryGetResponse_TicketHistoryElement) {
            throw new \InvalidArgumentException(sprintf('The History property can only contain items of \StructType\OTRS_TicketHistoryGetResponse_TicketHistoryElement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->History[] = $item;
        return $this;
    }
    /**
     * Get TicketID value
     * @return int|null
     */
    public function getTicketID()
    {
        return $this->TicketID;
    }
    /**
     * Set TicketID value
     * @param int $ticketID
     * @return \StructType\OTRS_TicketHistoryGetResponse_TicketHistory
     */
    public function setTicketID($ticketID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketID) && !is_numeric($ticketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketID)), __LINE__);
        }
        $this->TicketID = $ticketID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTRS_TicketHistoryGetResponse_TicketHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
