<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTRS_TicketGetResponse_Ticket StructType
 * @subpackage Structs
 */
class OTRS_TicketGetResponse_Ticket extends AbstractStructBase
{
    /**
     * The Created
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Created;
    /**
     * The CustomerUserID
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $CustomerUserID;
    /**
     * The GroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupID;
    /**
     * The LockID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LockID;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $Owner;
    /**
     * The OwnerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OwnerID;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $Priority;
    /**
     * The PriorityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PriorityID;
    /**
     * The Queue
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $Queue;
    /**
     * The QueueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QueueID;
    /**
     * The Responsible
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $Responsible;
    /**
     * The ResponsibleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResponsibleID;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $State;
    /**
     * The StateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StateID;
    /**
     * The StateType
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $StateType;
    /**
     * The TicketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketID;
    /**
     * The TicketNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TicketNumber;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Title;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The TypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TypeID;
    /**
     * The UnlockTimeout
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnlockTimeout;
    /**
     * The UntilTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UntilTime;
    /**
     * The Age
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $Age;
    /**
     * The ArchiveFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $ArchiveFlag;
    /**
     * The Article
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OTRS_TicketGetResponse_Article[]
     */
    public $Article;
    /**
     * The ChangeBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $ChangeBy;
    /**
     * The Changed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $Changed;
    /**
     * The Closed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Closed;
    /**
     * The CreateBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $CreateBy;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerID;
    /**
     * The DynamicField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OTRS_DynamicField[]
     */
    public $DynamicField;
    /**
     * The EscalationDestinationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EscalationDestinationDate;
    /**
     * The EscalationDestinationIn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EscalationDestinationIn;
    /**
     * The EscalationDestinationTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EscalationDestinationTime;
    /**
     * The EscalationResponseTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EscalationResponseTime;
    /**
     * The EscalationSolutionTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EscalationSolutionTime;
    /**
     * The EscalationTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $EscalationTime;
    /**
     * The EscalationTimeWorkingTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EscalationTimeWorkingTime;
    /**
     * The EscalationUpdateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EscalationUpdateTime;
    /**
     * The FirstResponseTimeEscalation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstResponseTimeEscalation;
    /**
     * The FirstResponseTimeNotification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstResponseTimeNotification;
    /**
     * The FirstResponseTimeDestinationTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstResponseTimeDestinationTime;
    /**
     * The FirstResponseTimeDestinationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstResponseTimeDestinationDate;
    /**
     * The FirstResponseTimeWorkingTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstResponseTimeWorkingTime;
    /**
     * The FirstResponseTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstResponseTime;
    /**
     * The UpdateTimeEscalation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UpdateTimeEscalation;
    /**
     * The UpdateTimeNotification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UpdateTimeNotification;
    /**
     * The UpdateTimeDestinationTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UpdateTimeDestinationTime;
    /**
     * The UpdateTimeDestinationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UpdateTimeDestinationDate;
    /**
     * The UpdateTimeWorkingTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UpdateTimeWorkingTime;
    /**
     * The UpdateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UpdateTime;
    /**
     * The FirstResponse
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstResponse;
    /**
     * The FirstResponseInMin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstResponseInMin;
    /**
     * The FirstResponseDiffInMin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstResponseDiffInMin;
    /**
     * The SolutionInMin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SolutionInMin;
    /**
     * The SolutionDiffInMin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SolutionDiffInMin;
    /**
     * The FirstLock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstLock;
    /**
     * The Lock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Lock;
    /**
     * The RealTillTimeNotUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RealTillTimeNotUsed;
    /**
     * The SLA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SLA;
    /**
     * The SLAID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SLAID;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Service;
    /**
     * The ServiceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ServiceID;
    /**
     * The SolutionTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SolutionTime;
    /**
     * The SolutionTimeEscalation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SolutionTimeEscalation;
    /**
     * The SolutionTimeNotification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SolutionTimeNotification;
    /**
     * The SolutionTimeDestinationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SolutionTimeDestinationDate;
    /**
     * The SolutionTimeDestinationTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SolutionTimeDestinationTime;
    /**
     * The SolutionTimeWorkingTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SolutionTimeWorkingTime;
    /**
     * The TicketFreeKeyX
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TicketFreeKeyX;
    /**
     * The TicketFreeTextX
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TicketFreeTextX;
    /**
     * The TicketFreeTimeX
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TicketFreeTimeX;
    /**
     * The TimeUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TimeUnit;
    /**
     * Constructor method for OTRS_TicketGetResponse_Ticket
     * @uses OTRS_TicketGetResponse_Ticket::setCreated()
     * @uses OTRS_TicketGetResponse_Ticket::setCustomerUserID()
     * @uses OTRS_TicketGetResponse_Ticket::setGroupID()
     * @uses OTRS_TicketGetResponse_Ticket::setLockID()
     * @uses OTRS_TicketGetResponse_Ticket::setOwner()
     * @uses OTRS_TicketGetResponse_Ticket::setOwnerID()
     * @uses OTRS_TicketGetResponse_Ticket::setPriority()
     * @uses OTRS_TicketGetResponse_Ticket::setPriorityID()
     * @uses OTRS_TicketGetResponse_Ticket::setQueue()
     * @uses OTRS_TicketGetResponse_Ticket::setQueueID()
     * @uses OTRS_TicketGetResponse_Ticket::setResponsible()
     * @uses OTRS_TicketGetResponse_Ticket::setResponsibleID()
     * @uses OTRS_TicketGetResponse_Ticket::setState()
     * @uses OTRS_TicketGetResponse_Ticket::setStateID()
     * @uses OTRS_TicketGetResponse_Ticket::setStateType()
     * @uses OTRS_TicketGetResponse_Ticket::setTicketID()
     * @uses OTRS_TicketGetResponse_Ticket::setTicketNumber()
     * @uses OTRS_TicketGetResponse_Ticket::setTitle()
     * @uses OTRS_TicketGetResponse_Ticket::setType()
     * @uses OTRS_TicketGetResponse_Ticket::setTypeID()
     * @uses OTRS_TicketGetResponse_Ticket::setUnlockTimeout()
     * @uses OTRS_TicketGetResponse_Ticket::setUntilTime()
     * @uses OTRS_TicketGetResponse_Ticket::setAge()
     * @uses OTRS_TicketGetResponse_Ticket::setArchiveFlag()
     * @uses OTRS_TicketGetResponse_Ticket::setArticle()
     * @uses OTRS_TicketGetResponse_Ticket::setChangeBy()
     * @uses OTRS_TicketGetResponse_Ticket::setChanged()
     * @uses OTRS_TicketGetResponse_Ticket::setClosed()
     * @uses OTRS_TicketGetResponse_Ticket::setCreateBy()
     * @uses OTRS_TicketGetResponse_Ticket::setCustomerID()
     * @uses OTRS_TicketGetResponse_Ticket::setDynamicField()
     * @uses OTRS_TicketGetResponse_Ticket::setEscalationDestinationDate()
     * @uses OTRS_TicketGetResponse_Ticket::setEscalationDestinationIn()
     * @uses OTRS_TicketGetResponse_Ticket::setEscalationDestinationTime()
     * @uses OTRS_TicketGetResponse_Ticket::setEscalationResponseTime()
     * @uses OTRS_TicketGetResponse_Ticket::setEscalationSolutionTime()
     * @uses OTRS_TicketGetResponse_Ticket::setEscalationTime()
     * @uses OTRS_TicketGetResponse_Ticket::setEscalationTimeWorkingTime()
     * @uses OTRS_TicketGetResponse_Ticket::setEscalationUpdateTime()
     * @uses OTRS_TicketGetResponse_Ticket::setFirstResponseTimeEscalation()
     * @uses OTRS_TicketGetResponse_Ticket::setFirstResponseTimeNotification()
     * @uses OTRS_TicketGetResponse_Ticket::setFirstResponseTimeDestinationTime()
     * @uses OTRS_TicketGetResponse_Ticket::setFirstResponseTimeDestinationDate()
     * @uses OTRS_TicketGetResponse_Ticket::setFirstResponseTimeWorkingTime()
     * @uses OTRS_TicketGetResponse_Ticket::setFirstResponseTime()
     * @uses OTRS_TicketGetResponse_Ticket::setUpdateTimeEscalation()
     * @uses OTRS_TicketGetResponse_Ticket::setUpdateTimeNotification()
     * @uses OTRS_TicketGetResponse_Ticket::setUpdateTimeDestinationTime()
     * @uses OTRS_TicketGetResponse_Ticket::setUpdateTimeDestinationDate()
     * @uses OTRS_TicketGetResponse_Ticket::setUpdateTimeWorkingTime()
     * @uses OTRS_TicketGetResponse_Ticket::setUpdateTime()
     * @uses OTRS_TicketGetResponse_Ticket::setFirstResponse()
     * @uses OTRS_TicketGetResponse_Ticket::setFirstResponseInMin()
     * @uses OTRS_TicketGetResponse_Ticket::setFirstResponseDiffInMin()
     * @uses OTRS_TicketGetResponse_Ticket::setSolutionInMin()
     * @uses OTRS_TicketGetResponse_Ticket::setSolutionDiffInMin()
     * @uses OTRS_TicketGetResponse_Ticket::setFirstLock()
     * @uses OTRS_TicketGetResponse_Ticket::setLock()
     * @uses OTRS_TicketGetResponse_Ticket::setRealTillTimeNotUsed()
     * @uses OTRS_TicketGetResponse_Ticket::setSLA()
     * @uses OTRS_TicketGetResponse_Ticket::setSLAID()
     * @uses OTRS_TicketGetResponse_Ticket::setService()
     * @uses OTRS_TicketGetResponse_Ticket::setServiceID()
     * @uses OTRS_TicketGetResponse_Ticket::setSolutionTime()
     * @uses OTRS_TicketGetResponse_Ticket::setSolutionTimeEscalation()
     * @uses OTRS_TicketGetResponse_Ticket::setSolutionTimeNotification()
     * @uses OTRS_TicketGetResponse_Ticket::setSolutionTimeDestinationDate()
     * @uses OTRS_TicketGetResponse_Ticket::setSolutionTimeDestinationTime()
     * @uses OTRS_TicketGetResponse_Ticket::setSolutionTimeWorkingTime()
     * @uses OTRS_TicketGetResponse_Ticket::setTicketFreeKeyX()
     * @uses OTRS_TicketGetResponse_Ticket::setTicketFreeTextX()
     * @uses OTRS_TicketGetResponse_Ticket::setTicketFreeTimeX()
     * @uses OTRS_TicketGetResponse_Ticket::setTimeUnit()
     * @param string $created
     * @param string $customerUserID
     * @param int $groupID
     * @param int $lockID
     * @param string $owner
     * @param int $ownerID
     * @param string $priority
     * @param int $priorityID
     * @param string $queue
     * @param int $queueID
     * @param string $responsible
     * @param int $responsibleID
     * @param string $state
     * @param int $stateID
     * @param string $stateType
     * @param int $ticketID
     * @param string $ticketNumber
     * @param string $title
     * @param string $type
     * @param int $typeID
     * @param int $unlockTimeout
     * @param int $untilTime
     * @param int $age
     * @param string $archiveFlag
     * @param \StructType\OTRS_TicketGetResponse_Article[] $article
     * @param int $changeBy
     * @param string $changed
     * @param string $closed
     * @param int $createBy
     * @param string $customerID
     * @param \StructType\OTRS_DynamicField[] $dynamicField
     * @param string $escalationDestinationDate
     * @param string $escalationDestinationIn
     * @param string $escalationDestinationTime
     * @param string $escalationResponseTime
     * @param string $escalationSolutionTime
     * @param string $escalationTime
     * @param string $escalationTimeWorkingTime
     * @param string $escalationUpdateTime
     * @param string $firstResponseTimeEscalation
     * @param string $firstResponseTimeNotification
     * @param string $firstResponseTimeDestinationTime
     * @param string $firstResponseTimeDestinationDate
     * @param string $firstResponseTimeWorkingTime
     * @param string $firstResponseTime
     * @param string $updateTimeEscalation
     * @param string $updateTimeNotification
     * @param string $updateTimeDestinationTime
     * @param string $updateTimeDestinationDate
     * @param string $updateTimeWorkingTime
     * @param string $updateTime
     * @param string $firstResponse
     * @param string $firstResponseInMin
     * @param string $firstResponseDiffInMin
     * @param string $solutionInMin
     * @param string $solutionDiffInMin
     * @param string $firstLock
     * @param string $lock
     * @param string $realTillTimeNotUsed
     * @param string $sLA
     * @param int $sLAID
     * @param string $service
     * @param int $serviceID
     * @param string $solutionTime
     * @param string $solutionTimeEscalation
     * @param string $solutionTimeNotification
     * @param string $solutionTimeDestinationDate
     * @param string $solutionTimeDestinationTime
     * @param string $solutionTimeWorkingTime
     * @param string $ticketFreeKeyX
     * @param string $ticketFreeTextX
     * @param string $ticketFreeTimeX
     * @param float $timeUnit
     */
    public function __construct($created = null, $customerUserID = null, $groupID = null, $lockID = null, $owner = null, $ownerID = null, $priority = null, $priorityID = null, $queue = null, $queueID = null, $responsible = null, $responsibleID = null, $state = null, $stateID = null, $stateType = null, $ticketID = null, $ticketNumber = null, $title = null, $type = null, $typeID = null, $unlockTimeout = null, $untilTime = null, $age = null, $archiveFlag = null, array $article = array(), $changeBy = null, $changed = null, $closed = null, $createBy = null, $customerID = null, array $dynamicField = array(), $escalationDestinationDate = null, $escalationDestinationIn = null, $escalationDestinationTime = null, $escalationResponseTime = null, $escalationSolutionTime = null, $escalationTime = null, $escalationTimeWorkingTime = null, $escalationUpdateTime = null, $firstResponseTimeEscalation = null, $firstResponseTimeNotification = null, $firstResponseTimeDestinationTime = null, $firstResponseTimeDestinationDate = null, $firstResponseTimeWorkingTime = null, $firstResponseTime = null, $updateTimeEscalation = null, $updateTimeNotification = null, $updateTimeDestinationTime = null, $updateTimeDestinationDate = null, $updateTimeWorkingTime = null, $updateTime = null, $firstResponse = null, $firstResponseInMin = null, $firstResponseDiffInMin = null, $solutionInMin = null, $solutionDiffInMin = null, $firstLock = null, $lock = null, $realTillTimeNotUsed = null, $sLA = null, $sLAID = null, $service = null, $serviceID = null, $solutionTime = null, $solutionTimeEscalation = null, $solutionTimeNotification = null, $solutionTimeDestinationDate = null, $solutionTimeDestinationTime = null, $solutionTimeWorkingTime = null, $ticketFreeKeyX = null, $ticketFreeTextX = null, $ticketFreeTimeX = null, $timeUnit = null)
    {
        $this
            ->setCreated($created)
            ->setCustomerUserID($customerUserID)
            ->setGroupID($groupID)
            ->setLockID($lockID)
            ->setOwner($owner)
            ->setOwnerID($ownerID)
            ->setPriority($priority)
            ->setPriorityID($priorityID)
            ->setQueue($queue)
            ->setQueueID($queueID)
            ->setResponsible($responsible)
            ->setResponsibleID($responsibleID)
            ->setState($state)
            ->setStateID($stateID)
            ->setStateType($stateType)
            ->setTicketID($ticketID)
            ->setTicketNumber($ticketNumber)
            ->setTitle($title)
            ->setType($type)
            ->setTypeID($typeID)
            ->setUnlockTimeout($unlockTimeout)
            ->setUntilTime($untilTime)
            ->setAge($age)
            ->setArchiveFlag($archiveFlag)
            ->setArticle($article)
            ->setChangeBy($changeBy)
            ->setChanged($changed)
            ->setClosed($closed)
            ->setCreateBy($createBy)
            ->setCustomerID($customerID)
            ->setDynamicField($dynamicField)
            ->setEscalationDestinationDate($escalationDestinationDate)
            ->setEscalationDestinationIn($escalationDestinationIn)
            ->setEscalationDestinationTime($escalationDestinationTime)
            ->setEscalationResponseTime($escalationResponseTime)
            ->setEscalationSolutionTime($escalationSolutionTime)
            ->setEscalationTime($escalationTime)
            ->setEscalationTimeWorkingTime($escalationTimeWorkingTime)
            ->setEscalationUpdateTime($escalationUpdateTime)
            ->setFirstResponseTimeEscalation($firstResponseTimeEscalation)
            ->setFirstResponseTimeNotification($firstResponseTimeNotification)
            ->setFirstResponseTimeDestinationTime($firstResponseTimeDestinationTime)
            ->setFirstResponseTimeDestinationDate($firstResponseTimeDestinationDate)
            ->setFirstResponseTimeWorkingTime($firstResponseTimeWorkingTime)
            ->setFirstResponseTime($firstResponseTime)
            ->setUpdateTimeEscalation($updateTimeEscalation)
            ->setUpdateTimeNotification($updateTimeNotification)
            ->setUpdateTimeDestinationTime($updateTimeDestinationTime)
            ->setUpdateTimeDestinationDate($updateTimeDestinationDate)
            ->setUpdateTimeWorkingTime($updateTimeWorkingTime)
            ->setUpdateTime($updateTime)
            ->setFirstResponse($firstResponse)
            ->setFirstResponseInMin($firstResponseInMin)
            ->setFirstResponseDiffInMin($firstResponseDiffInMin)
            ->setSolutionInMin($solutionInMin)
            ->setSolutionDiffInMin($solutionDiffInMin)
            ->setFirstLock($firstLock)
            ->setLock($lock)
            ->setRealTillTimeNotUsed($realTillTimeNotUsed)
            ->setSLA($sLA)
            ->setSLAID($sLAID)
            ->setService($service)
            ->setServiceID($serviceID)
            ->setSolutionTime($solutionTime)
            ->setSolutionTimeEscalation($solutionTimeEscalation)
            ->setSolutionTimeNotification($solutionTimeNotification)
            ->setSolutionTimeDestinationDate($solutionTimeDestinationDate)
            ->setSolutionTimeDestinationTime($solutionTimeDestinationTime)
            ->setSolutionTimeWorkingTime($solutionTimeWorkingTime)
            ->setTicketFreeKeyX($ticketFreeKeyX)
            ->setTicketFreeTextX($ticketFreeTextX)
            ->setTicketFreeTimeX($ticketFreeTimeX)
            ->setTimeUnit($timeUnit);
    }
    /**
     * Get Created value
     * @return string
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created)), __LINE__);
        }
        $this->Created = $created;
        return $this;
    }
    /**
     * Get CustomerUserID value
     * @return string
     */
    public function getCustomerUserID()
    {
        return $this->CustomerUserID;
    }
    /**
     * Set CustomerUserID value
     * @param string $customerUserID
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setCustomerUserID($customerUserID = null)
    {
        // validation for constraint: string
        if (!is_null($customerUserID) && !is_string($customerUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerUserID)), __LINE__);
        }
        $this->CustomerUserID = $customerUserID;
        return $this;
    }
    /**
     * Get GroupID value
     * @return int
     */
    public function getGroupID()
    {
        return $this->GroupID;
    }
    /**
     * Set GroupID value
     * @param int $groupID
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setGroupID($groupID = null)
    {
        // validation for constraint: int
        if (!is_null($groupID) && !is_numeric($groupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupID)), __LINE__);
        }
        $this->GroupID = $groupID;
        return $this;
    }
    /**
     * Get LockID value
     * @return int
     */
    public function getLockID()
    {
        return $this->LockID;
    }
    /**
     * Set LockID value
     * @param int $lockID
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setLockID($lockID = null)
    {
        // validation for constraint: int
        if (!is_null($lockID) && !is_numeric($lockID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lockID)), __LINE__);
        }
        $this->LockID = $lockID;
        return $this;
    }
    /**
     * Get Owner value
     * @return string
     */
    public function getOwner()
    {
        return $this->Owner;
    }
    /**
     * Set Owner value
     * @param string $owner
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($owner)), __LINE__);
        }
        $this->Owner = $owner;
        return $this;
    }
    /**
     * Get OwnerID value
     * @return int
     */
    public function getOwnerID()
    {
        return $this->OwnerID;
    }
    /**
     * Set OwnerID value
     * @param int $ownerID
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setOwnerID($ownerID = null)
    {
        // validation for constraint: int
        if (!is_null($ownerID) && !is_numeric($ownerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ownerID)), __LINE__);
        }
        $this->OwnerID = $ownerID;
        return $this;
    }
    /**
     * Get Priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param string $priority
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get PriorityID value
     * @return int
     */
    public function getPriorityID()
    {
        return $this->PriorityID;
    }
    /**
     * Set PriorityID value
     * @param int $priorityID
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setPriorityID($priorityID = null)
    {
        // validation for constraint: int
        if (!is_null($priorityID) && !is_numeric($priorityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priorityID)), __LINE__);
        }
        $this->PriorityID = $priorityID;
        return $this;
    }
    /**
     * Get Queue value
     * @return string
     */
    public function getQueue()
    {
        return $this->Queue;
    }
    /**
     * Set Queue value
     * @param string $queue
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setQueue($queue = null)
    {
        // validation for constraint: string
        if (!is_null($queue) && !is_string($queue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queue)), __LINE__);
        }
        $this->Queue = $queue;
        return $this;
    }
    /**
     * Get QueueID value
     * @return int
     */
    public function getQueueID()
    {
        return $this->QueueID;
    }
    /**
     * Set QueueID value
     * @param int $queueID
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setQueueID($queueID = null)
    {
        // validation for constraint: int
        if (!is_null($queueID) && !is_numeric($queueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($queueID)), __LINE__);
        }
        $this->QueueID = $queueID;
        return $this;
    }
    /**
     * Get Responsible value
     * @return string
     */
    public function getResponsible()
    {
        return $this->Responsible;
    }
    /**
     * Set Responsible value
     * @param string $responsible
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setResponsible($responsible = null)
    {
        // validation for constraint: string
        if (!is_null($responsible) && !is_string($responsible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responsible)), __LINE__);
        }
        $this->Responsible = $responsible;
        return $this;
    }
    /**
     * Get ResponsibleID value
     * @return int
     */
    public function getResponsibleID()
    {
        return $this->ResponsibleID;
    }
    /**
     * Set ResponsibleID value
     * @param int $responsibleID
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setResponsibleID($responsibleID = null)
    {
        // validation for constraint: int
        if (!is_null($responsibleID) && !is_numeric($responsibleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responsibleID)), __LINE__);
        }
        $this->ResponsibleID = $responsibleID;
        return $this;
    }
    /**
     * Get State value
     * @return string
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get StateID value
     * @return int
     */
    public function getStateID()
    {
        return $this->StateID;
    }
    /**
     * Set StateID value
     * @param int $stateID
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setStateID($stateID = null)
    {
        // validation for constraint: int
        if (!is_null($stateID) && !is_numeric($stateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stateID)), __LINE__);
        }
        $this->StateID = $stateID;
        return $this;
    }
    /**
     * Get StateType value
     * @return string
     */
    public function getStateType()
    {
        return $this->StateType;
    }
    /**
     * Set StateType value
     * @param string $stateType
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setStateType($stateType = null)
    {
        // validation for constraint: string
        if (!is_null($stateType) && !is_string($stateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateType)), __LINE__);
        }
        $this->StateType = $stateType;
        return $this;
    }
    /**
     * Get TicketID value
     * @return int
     */
    public function getTicketID()
    {
        return $this->TicketID;
    }
    /**
     * Set TicketID value
     * @param int $ticketID
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setTicketID($ticketID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketID) && !is_numeric($ticketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketID)), __LINE__);
        }
        $this->TicketID = $ticketID;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get Title value
     * @return string
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TypeID value
     * @return int
     */
    public function getTypeID()
    {
        return $this->TypeID;
    }
    /**
     * Set TypeID value
     * @param int $typeID
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setTypeID($typeID = null)
    {
        // validation for constraint: int
        if (!is_null($typeID) && !is_numeric($typeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($typeID)), __LINE__);
        }
        $this->TypeID = $typeID;
        return $this;
    }
    /**
     * Get UnlockTimeout value
     * @return int
     */
    public function getUnlockTimeout()
    {
        return $this->UnlockTimeout;
    }
    /**
     * Set UnlockTimeout value
     * @param int $unlockTimeout
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setUnlockTimeout($unlockTimeout = null)
    {
        // validation for constraint: int
        if (!is_null($unlockTimeout) && !is_numeric($unlockTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unlockTimeout)), __LINE__);
        }
        $this->UnlockTimeout = $unlockTimeout;
        return $this;
    }
    /**
     * Get UntilTime value
     * @return int
     */
    public function getUntilTime()
    {
        return $this->UntilTime;
    }
    /**
     * Set UntilTime value
     * @param int $untilTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setUntilTime($untilTime = null)
    {
        // validation for constraint: int
        if (!is_null($untilTime) && !is_numeric($untilTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($untilTime)), __LINE__);
        }
        $this->UntilTime = $untilTime;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !is_numeric($age)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get ArchiveFlag value
     * @return string|null
     */
    public function getArchiveFlag()
    {
        return $this->ArchiveFlag;
    }
    /**
     * Set ArchiveFlag value
     * @param string $archiveFlag
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setArchiveFlag($archiveFlag = null)
    {
        // validation for constraint: string
        if (!is_null($archiveFlag) && !is_string($archiveFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($archiveFlag)), __LINE__);
        }
        $this->ArchiveFlag = $archiveFlag;
        return $this;
    }
    /**
     * Get Article value
     * @return \StructType\OTRS_TicketGetResponse_Article[]|null
     */
    public function getArticle()
    {
        return $this->Article;
    }
    /**
     * Set Article value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_TicketGetResponse_Article[] $article
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setArticle(array $article = array())
    {
        foreach ($article as $oTRS_TicketGetResponse_TicketArticleItem) {
            // validation for constraint: itemType
            if (!$oTRS_TicketGetResponse_TicketArticleItem instanceof \StructType\OTRS_TicketGetResponse_Article) {
                throw new \InvalidArgumentException(sprintf('The Article property can only contain items of \StructType\OTRS_TicketGetResponse_Article, "%s" given', is_object($oTRS_TicketGetResponse_TicketArticleItem) ? get_class($oTRS_TicketGetResponse_TicketArticleItem) : gettype($oTRS_TicketGetResponse_TicketArticleItem)), __LINE__);
            }
        }
        $this->Article = $article;
        return $this;
    }
    /**
     * Add item to Article value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_TicketGetResponse_Article $item
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function addToArticle(\StructType\OTRS_TicketGetResponse_Article $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OTRS_TicketGetResponse_Article) {
            throw new \InvalidArgumentException(sprintf('The Article property can only contain items of \StructType\OTRS_TicketGetResponse_Article, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Article[] = $item;
        return $this;
    }
    /**
     * Get ChangeBy value
     * @return int|null
     */
    public function getChangeBy()
    {
        return $this->ChangeBy;
    }
    /**
     * Set ChangeBy value
     * @param int $changeBy
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setChangeBy($changeBy = null)
    {
        // validation for constraint: int
        if (!is_null($changeBy) && !is_numeric($changeBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($changeBy)), __LINE__);
        }
        $this->ChangeBy = $changeBy;
        return $this;
    }
    /**
     * Get Changed value
     * @return string|null
     */
    public function getChanged()
    {
        return $this->Changed;
    }
    /**
     * Set Changed value
     * @param string $changed
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setChanged($changed = null)
    {
        // validation for constraint: string
        if (!is_null($changed) && !is_string($changed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changed)), __LINE__);
        }
        $this->Changed = $changed;
        return $this;
    }
    /**
     * Get Closed value
     * @return string|null
     */
    public function getClosed()
    {
        return $this->Closed;
    }
    /**
     * Set Closed value
     * @param string $closed
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setClosed($closed = null)
    {
        // validation for constraint: string
        if (!is_null($closed) && !is_string($closed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($closed)), __LINE__);
        }
        $this->Closed = $closed;
        return $this;
    }
    /**
     * Get CreateBy value
     * @return int|null
     */
    public function getCreateBy()
    {
        return $this->CreateBy;
    }
    /**
     * Set CreateBy value
     * @param int $createBy
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setCreateBy($createBy = null)
    {
        // validation for constraint: int
        if (!is_null($createBy) && !is_numeric($createBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($createBy)), __LINE__);
        }
        $this->CreateBy = $createBy;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return string|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param string $customerID
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: string
        if (!is_null($customerID) && !is_string($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get DynamicField value
     * @return \StructType\OTRS_DynamicField[]|null
     */
    public function getDynamicField()
    {
        return $this->DynamicField;
    }
    /**
     * Set DynamicField value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_DynamicField[] $dynamicField
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setDynamicField(array $dynamicField = array())
    {
        foreach ($dynamicField as $oTRS_TicketGetResponse_TicketDynamicFieldItem) {
            // validation for constraint: itemType
            if (!$oTRS_TicketGetResponse_TicketDynamicFieldItem instanceof \StructType\OTRS_DynamicField) {
                throw new \InvalidArgumentException(sprintf('The DynamicField property can only contain items of \StructType\OTRS_DynamicField, "%s" given', is_object($oTRS_TicketGetResponse_TicketDynamicFieldItem) ? get_class($oTRS_TicketGetResponse_TicketDynamicFieldItem) : gettype($oTRS_TicketGetResponse_TicketDynamicFieldItem)), __LINE__);
            }
        }
        $this->DynamicField = $dynamicField;
        return $this;
    }
    /**
     * Add item to DynamicField value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_DynamicField $item
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function addToDynamicField(\StructType\OTRS_DynamicField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OTRS_DynamicField) {
            throw new \InvalidArgumentException(sprintf('The DynamicField property can only contain items of \StructType\OTRS_DynamicField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DynamicField[] = $item;
        return $this;
    }
    /**
     * Get EscalationDestinationDate value
     * @return string|null
     */
    public function getEscalationDestinationDate()
    {
        return $this->EscalationDestinationDate;
    }
    /**
     * Set EscalationDestinationDate value
     * @param string $escalationDestinationDate
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setEscalationDestinationDate($escalationDestinationDate = null)
    {
        // validation for constraint: string
        if (!is_null($escalationDestinationDate) && !is_string($escalationDestinationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationDestinationDate)), __LINE__);
        }
        $this->EscalationDestinationDate = $escalationDestinationDate;
        return $this;
    }
    /**
     * Get EscalationDestinationIn value
     * @return string|null
     */
    public function getEscalationDestinationIn()
    {
        return $this->EscalationDestinationIn;
    }
    /**
     * Set EscalationDestinationIn value
     * @param string $escalationDestinationIn
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setEscalationDestinationIn($escalationDestinationIn = null)
    {
        // validation for constraint: string
        if (!is_null($escalationDestinationIn) && !is_string($escalationDestinationIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationDestinationIn)), __LINE__);
        }
        $this->EscalationDestinationIn = $escalationDestinationIn;
        return $this;
    }
    /**
     * Get EscalationDestinationTime value
     * @return string|null
     */
    public function getEscalationDestinationTime()
    {
        return $this->EscalationDestinationTime;
    }
    /**
     * Set EscalationDestinationTime value
     * @param string $escalationDestinationTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setEscalationDestinationTime($escalationDestinationTime = null)
    {
        // validation for constraint: string
        if (!is_null($escalationDestinationTime) && !is_string($escalationDestinationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationDestinationTime)), __LINE__);
        }
        $this->EscalationDestinationTime = $escalationDestinationTime;
        return $this;
    }
    /**
     * Get EscalationResponseTime value
     * @return string|null
     */
    public function getEscalationResponseTime()
    {
        return $this->EscalationResponseTime;
    }
    /**
     * Set EscalationResponseTime value
     * @param string $escalationResponseTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setEscalationResponseTime($escalationResponseTime = null)
    {
        // validation for constraint: string
        if (!is_null($escalationResponseTime) && !is_string($escalationResponseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationResponseTime)), __LINE__);
        }
        $this->EscalationResponseTime = $escalationResponseTime;
        return $this;
    }
    /**
     * Get EscalationSolutionTime value
     * @return string|null
     */
    public function getEscalationSolutionTime()
    {
        return $this->EscalationSolutionTime;
    }
    /**
     * Set EscalationSolutionTime value
     * @param string $escalationSolutionTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setEscalationSolutionTime($escalationSolutionTime = null)
    {
        // validation for constraint: string
        if (!is_null($escalationSolutionTime) && !is_string($escalationSolutionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationSolutionTime)), __LINE__);
        }
        $this->EscalationSolutionTime = $escalationSolutionTime;
        return $this;
    }
    /**
     * Get EscalationTime value
     * @return string|null
     */
    public function getEscalationTime()
    {
        return $this->EscalationTime;
    }
    /**
     * Set EscalationTime value
     * @param string $escalationTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setEscalationTime($escalationTime = null)
    {
        // validation for constraint: string
        if (!is_null($escalationTime) && !is_string($escalationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationTime)), __LINE__);
        }
        $this->EscalationTime = $escalationTime;
        return $this;
    }
    /**
     * Get EscalationTimeWorkingTime value
     * @return string|null
     */
    public function getEscalationTimeWorkingTime()
    {
        return $this->EscalationTimeWorkingTime;
    }
    /**
     * Set EscalationTimeWorkingTime value
     * @param string $escalationTimeWorkingTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setEscalationTimeWorkingTime($escalationTimeWorkingTime = null)
    {
        // validation for constraint: string
        if (!is_null($escalationTimeWorkingTime) && !is_string($escalationTimeWorkingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationTimeWorkingTime)), __LINE__);
        }
        $this->EscalationTimeWorkingTime = $escalationTimeWorkingTime;
        return $this;
    }
    /**
     * Get EscalationUpdateTime value
     * @return string|null
     */
    public function getEscalationUpdateTime()
    {
        return $this->EscalationUpdateTime;
    }
    /**
     * Set EscalationUpdateTime value
     * @param string $escalationUpdateTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setEscalationUpdateTime($escalationUpdateTime = null)
    {
        // validation for constraint: string
        if (!is_null($escalationUpdateTime) && !is_string($escalationUpdateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationUpdateTime)), __LINE__);
        }
        $this->EscalationUpdateTime = $escalationUpdateTime;
        return $this;
    }
    /**
     * Get FirstResponseTimeEscalation value
     * @return string|null
     */
    public function getFirstResponseTimeEscalation()
    {
        return $this->FirstResponseTimeEscalation;
    }
    /**
     * Set FirstResponseTimeEscalation value
     * @param string $firstResponseTimeEscalation
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setFirstResponseTimeEscalation($firstResponseTimeEscalation = null)
    {
        // validation for constraint: string
        if (!is_null($firstResponseTimeEscalation) && !is_string($firstResponseTimeEscalation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstResponseTimeEscalation)), __LINE__);
        }
        $this->FirstResponseTimeEscalation = $firstResponseTimeEscalation;
        return $this;
    }
    /**
     * Get FirstResponseTimeNotification value
     * @return string|null
     */
    public function getFirstResponseTimeNotification()
    {
        return $this->FirstResponseTimeNotification;
    }
    /**
     * Set FirstResponseTimeNotification value
     * @param string $firstResponseTimeNotification
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setFirstResponseTimeNotification($firstResponseTimeNotification = null)
    {
        // validation for constraint: string
        if (!is_null($firstResponseTimeNotification) && !is_string($firstResponseTimeNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstResponseTimeNotification)), __LINE__);
        }
        $this->FirstResponseTimeNotification = $firstResponseTimeNotification;
        return $this;
    }
    /**
     * Get FirstResponseTimeDestinationTime value
     * @return string|null
     */
    public function getFirstResponseTimeDestinationTime()
    {
        return $this->FirstResponseTimeDestinationTime;
    }
    /**
     * Set FirstResponseTimeDestinationTime value
     * @param string $firstResponseTimeDestinationTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setFirstResponseTimeDestinationTime($firstResponseTimeDestinationTime = null)
    {
        // validation for constraint: string
        if (!is_null($firstResponseTimeDestinationTime) && !is_string($firstResponseTimeDestinationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstResponseTimeDestinationTime)), __LINE__);
        }
        $this->FirstResponseTimeDestinationTime = $firstResponseTimeDestinationTime;
        return $this;
    }
    /**
     * Get FirstResponseTimeDestinationDate value
     * @return string|null
     */
    public function getFirstResponseTimeDestinationDate()
    {
        return $this->FirstResponseTimeDestinationDate;
    }
    /**
     * Set FirstResponseTimeDestinationDate value
     * @param string $firstResponseTimeDestinationDate
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setFirstResponseTimeDestinationDate($firstResponseTimeDestinationDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstResponseTimeDestinationDate) && !is_string($firstResponseTimeDestinationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstResponseTimeDestinationDate)), __LINE__);
        }
        $this->FirstResponseTimeDestinationDate = $firstResponseTimeDestinationDate;
        return $this;
    }
    /**
     * Get FirstResponseTimeWorkingTime value
     * @return string|null
     */
    public function getFirstResponseTimeWorkingTime()
    {
        return $this->FirstResponseTimeWorkingTime;
    }
    /**
     * Set FirstResponseTimeWorkingTime value
     * @param string $firstResponseTimeWorkingTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setFirstResponseTimeWorkingTime($firstResponseTimeWorkingTime = null)
    {
        // validation for constraint: string
        if (!is_null($firstResponseTimeWorkingTime) && !is_string($firstResponseTimeWorkingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstResponseTimeWorkingTime)), __LINE__);
        }
        $this->FirstResponseTimeWorkingTime = $firstResponseTimeWorkingTime;
        return $this;
    }
    /**
     * Get FirstResponseTime value
     * @return string|null
     */
    public function getFirstResponseTime()
    {
        return $this->FirstResponseTime;
    }
    /**
     * Set FirstResponseTime value
     * @param string $firstResponseTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setFirstResponseTime($firstResponseTime = null)
    {
        // validation for constraint: string
        if (!is_null($firstResponseTime) && !is_string($firstResponseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstResponseTime)), __LINE__);
        }
        $this->FirstResponseTime = $firstResponseTime;
        return $this;
    }
    /**
     * Get UpdateTimeEscalation value
     * @return string|null
     */
    public function getUpdateTimeEscalation()
    {
        return $this->UpdateTimeEscalation;
    }
    /**
     * Set UpdateTimeEscalation value
     * @param string $updateTimeEscalation
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setUpdateTimeEscalation($updateTimeEscalation = null)
    {
        // validation for constraint: string
        if (!is_null($updateTimeEscalation) && !is_string($updateTimeEscalation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateTimeEscalation)), __LINE__);
        }
        $this->UpdateTimeEscalation = $updateTimeEscalation;
        return $this;
    }
    /**
     * Get UpdateTimeNotification value
     * @return string|null
     */
    public function getUpdateTimeNotification()
    {
        return $this->UpdateTimeNotification;
    }
    /**
     * Set UpdateTimeNotification value
     * @param string $updateTimeNotification
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setUpdateTimeNotification($updateTimeNotification = null)
    {
        // validation for constraint: string
        if (!is_null($updateTimeNotification) && !is_string($updateTimeNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateTimeNotification)), __LINE__);
        }
        $this->UpdateTimeNotification = $updateTimeNotification;
        return $this;
    }
    /**
     * Get UpdateTimeDestinationTime value
     * @return string|null
     */
    public function getUpdateTimeDestinationTime()
    {
        return $this->UpdateTimeDestinationTime;
    }
    /**
     * Set UpdateTimeDestinationTime value
     * @param string $updateTimeDestinationTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setUpdateTimeDestinationTime($updateTimeDestinationTime = null)
    {
        // validation for constraint: string
        if (!is_null($updateTimeDestinationTime) && !is_string($updateTimeDestinationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateTimeDestinationTime)), __LINE__);
        }
        $this->UpdateTimeDestinationTime = $updateTimeDestinationTime;
        return $this;
    }
    /**
     * Get UpdateTimeDestinationDate value
     * @return string|null
     */
    public function getUpdateTimeDestinationDate()
    {
        return $this->UpdateTimeDestinationDate;
    }
    /**
     * Set UpdateTimeDestinationDate value
     * @param string $updateTimeDestinationDate
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setUpdateTimeDestinationDate($updateTimeDestinationDate = null)
    {
        // validation for constraint: string
        if (!is_null($updateTimeDestinationDate) && !is_string($updateTimeDestinationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateTimeDestinationDate)), __LINE__);
        }
        $this->UpdateTimeDestinationDate = $updateTimeDestinationDate;
        return $this;
    }
    /**
     * Get UpdateTimeWorkingTime value
     * @return string|null
     */
    public function getUpdateTimeWorkingTime()
    {
        return $this->UpdateTimeWorkingTime;
    }
    /**
     * Set UpdateTimeWorkingTime value
     * @param string $updateTimeWorkingTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setUpdateTimeWorkingTime($updateTimeWorkingTime = null)
    {
        // validation for constraint: string
        if (!is_null($updateTimeWorkingTime) && !is_string($updateTimeWorkingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateTimeWorkingTime)), __LINE__);
        }
        $this->UpdateTimeWorkingTime = $updateTimeWorkingTime;
        return $this;
    }
    /**
     * Get UpdateTime value
     * @return string|null
     */
    public function getUpdateTime()
    {
        return $this->UpdateTime;
    }
    /**
     * Set UpdateTime value
     * @param string $updateTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setUpdateTime($updateTime = null)
    {
        // validation for constraint: string
        if (!is_null($updateTime) && !is_string($updateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateTime)), __LINE__);
        }
        $this->UpdateTime = $updateTime;
        return $this;
    }
    /**
     * Get FirstResponse value
     * @return string|null
     */
    public function getFirstResponse()
    {
        return $this->FirstResponse;
    }
    /**
     * Set FirstResponse value
     * @param string $firstResponse
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setFirstResponse($firstResponse = null)
    {
        // validation for constraint: string
        if (!is_null($firstResponse) && !is_string($firstResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstResponse)), __LINE__);
        }
        $this->FirstResponse = $firstResponse;
        return $this;
    }
    /**
     * Get FirstResponseInMin value
     * @return string|null
     */
    public function getFirstResponseInMin()
    {
        return $this->FirstResponseInMin;
    }
    /**
     * Set FirstResponseInMin value
     * @param string $firstResponseInMin
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setFirstResponseInMin($firstResponseInMin = null)
    {
        // validation for constraint: string
        if (!is_null($firstResponseInMin) && !is_string($firstResponseInMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstResponseInMin)), __LINE__);
        }
        $this->FirstResponseInMin = $firstResponseInMin;
        return $this;
    }
    /**
     * Get FirstResponseDiffInMin value
     * @return string|null
     */
    public function getFirstResponseDiffInMin()
    {
        return $this->FirstResponseDiffInMin;
    }
    /**
     * Set FirstResponseDiffInMin value
     * @param string $firstResponseDiffInMin
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setFirstResponseDiffInMin($firstResponseDiffInMin = null)
    {
        // validation for constraint: string
        if (!is_null($firstResponseDiffInMin) && !is_string($firstResponseDiffInMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstResponseDiffInMin)), __LINE__);
        }
        $this->FirstResponseDiffInMin = $firstResponseDiffInMin;
        return $this;
    }
    /**
     * Get SolutionInMin value
     * @return string|null
     */
    public function getSolutionInMin()
    {
        return $this->SolutionInMin;
    }
    /**
     * Set SolutionInMin value
     * @param string $solutionInMin
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setSolutionInMin($solutionInMin = null)
    {
        // validation for constraint: string
        if (!is_null($solutionInMin) && !is_string($solutionInMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($solutionInMin)), __LINE__);
        }
        $this->SolutionInMin = $solutionInMin;
        return $this;
    }
    /**
     * Get SolutionDiffInMin value
     * @return string|null
     */
    public function getSolutionDiffInMin()
    {
        return $this->SolutionDiffInMin;
    }
    /**
     * Set SolutionDiffInMin value
     * @param string $solutionDiffInMin
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setSolutionDiffInMin($solutionDiffInMin = null)
    {
        // validation for constraint: string
        if (!is_null($solutionDiffInMin) && !is_string($solutionDiffInMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($solutionDiffInMin)), __LINE__);
        }
        $this->SolutionDiffInMin = $solutionDiffInMin;
        return $this;
    }
    /**
     * Get FirstLock value
     * @return string|null
     */
    public function getFirstLock()
    {
        return $this->FirstLock;
    }
    /**
     * Set FirstLock value
     * @param string $firstLock
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setFirstLock($firstLock = null)
    {
        // validation for constraint: string
        if (!is_null($firstLock) && !is_string($firstLock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstLock)), __LINE__);
        }
        $this->FirstLock = $firstLock;
        return $this;
    }
    /**
     * Get Lock value
     * @return string|null
     */
    public function getLock()
    {
        return $this->Lock;
    }
    /**
     * Set Lock value
     * @param string $lock
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setLock($lock = null)
    {
        // validation for constraint: string
        if (!is_null($lock) && !is_string($lock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lock)), __LINE__);
        }
        $this->Lock = $lock;
        return $this;
    }
    /**
     * Get RealTillTimeNotUsed value
     * @return string|null
     */
    public function getRealTillTimeNotUsed()
    {
        return $this->RealTillTimeNotUsed;
    }
    /**
     * Set RealTillTimeNotUsed value
     * @param string $realTillTimeNotUsed
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setRealTillTimeNotUsed($realTillTimeNotUsed = null)
    {
        // validation for constraint: string
        if (!is_null($realTillTimeNotUsed) && !is_string($realTillTimeNotUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($realTillTimeNotUsed)), __LINE__);
        }
        $this->RealTillTimeNotUsed = $realTillTimeNotUsed;
        return $this;
    }
    /**
     * Get SLA value
     * @return string|null
     */
    public function getSLA()
    {
        return $this->SLA;
    }
    /**
     * Set SLA value
     * @param string $sLA
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setSLA($sLA = null)
    {
        // validation for constraint: string
        if (!is_null($sLA) && !is_string($sLA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sLA)), __LINE__);
        }
        $this->SLA = $sLA;
        return $this;
    }
    /**
     * Get SLAID value
     * @return int|null
     */
    public function getSLAID()
    {
        return $this->SLAID;
    }
    /**
     * Set SLAID value
     * @param int $sLAID
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setSLAID($sLAID = null)
    {
        // validation for constraint: int
        if (!is_null($sLAID) && !is_numeric($sLAID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sLAID)), __LINE__);
        }
        $this->SLAID = $sLAID;
        return $this;
    }
    /**
     * Get Service value
     * @return string|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param string $service
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($service)), __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Get ServiceID value
     * @return int|null
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param int $serviceID
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceID) && !is_numeric($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get SolutionTime value
     * @return string|null
     */
    public function getSolutionTime()
    {
        return $this->SolutionTime;
    }
    /**
     * Set SolutionTime value
     * @param string $solutionTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setSolutionTime($solutionTime = null)
    {
        // validation for constraint: string
        if (!is_null($solutionTime) && !is_string($solutionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($solutionTime)), __LINE__);
        }
        $this->SolutionTime = $solutionTime;
        return $this;
    }
    /**
     * Get SolutionTimeEscalation value
     * @return string|null
     */
    public function getSolutionTimeEscalation()
    {
        return $this->SolutionTimeEscalation;
    }
    /**
     * Set SolutionTimeEscalation value
     * @param string $solutionTimeEscalation
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setSolutionTimeEscalation($solutionTimeEscalation = null)
    {
        // validation for constraint: string
        if (!is_null($solutionTimeEscalation) && !is_string($solutionTimeEscalation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($solutionTimeEscalation)), __LINE__);
        }
        $this->SolutionTimeEscalation = $solutionTimeEscalation;
        return $this;
    }
    /**
     * Get SolutionTimeNotification value
     * @return string|null
     */
    public function getSolutionTimeNotification()
    {
        return $this->SolutionTimeNotification;
    }
    /**
     * Set SolutionTimeNotification value
     * @param string $solutionTimeNotification
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setSolutionTimeNotification($solutionTimeNotification = null)
    {
        // validation for constraint: string
        if (!is_null($solutionTimeNotification) && !is_string($solutionTimeNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($solutionTimeNotification)), __LINE__);
        }
        $this->SolutionTimeNotification = $solutionTimeNotification;
        return $this;
    }
    /**
     * Get SolutionTimeDestinationDate value
     * @return string|null
     */
    public function getSolutionTimeDestinationDate()
    {
        return $this->SolutionTimeDestinationDate;
    }
    /**
     * Set SolutionTimeDestinationDate value
     * @param string $solutionTimeDestinationDate
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setSolutionTimeDestinationDate($solutionTimeDestinationDate = null)
    {
        // validation for constraint: string
        if (!is_null($solutionTimeDestinationDate) && !is_string($solutionTimeDestinationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($solutionTimeDestinationDate)), __LINE__);
        }
        $this->SolutionTimeDestinationDate = $solutionTimeDestinationDate;
        return $this;
    }
    /**
     * Get SolutionTimeDestinationTime value
     * @return string|null
     */
    public function getSolutionTimeDestinationTime()
    {
        return $this->SolutionTimeDestinationTime;
    }
    /**
     * Set SolutionTimeDestinationTime value
     * @param string $solutionTimeDestinationTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setSolutionTimeDestinationTime($solutionTimeDestinationTime = null)
    {
        // validation for constraint: string
        if (!is_null($solutionTimeDestinationTime) && !is_string($solutionTimeDestinationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($solutionTimeDestinationTime)), __LINE__);
        }
        $this->SolutionTimeDestinationTime = $solutionTimeDestinationTime;
        return $this;
    }
    /**
     * Get SolutionTimeWorkingTime value
     * @return string|null
     */
    public function getSolutionTimeWorkingTime()
    {
        return $this->SolutionTimeWorkingTime;
    }
    /**
     * Set SolutionTimeWorkingTime value
     * @param string $solutionTimeWorkingTime
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setSolutionTimeWorkingTime($solutionTimeWorkingTime = null)
    {
        // validation for constraint: string
        if (!is_null($solutionTimeWorkingTime) && !is_string($solutionTimeWorkingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($solutionTimeWorkingTime)), __LINE__);
        }
        $this->SolutionTimeWorkingTime = $solutionTimeWorkingTime;
        return $this;
    }
    /**
     * Get TicketFreeKeyX value
     * @return string|null
     */
    public function getTicketFreeKeyX()
    {
        return $this->TicketFreeKeyX;
    }
    /**
     * Set TicketFreeKeyX value
     * @param string $ticketFreeKeyX
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setTicketFreeKeyX($ticketFreeKeyX = null)
    {
        // validation for constraint: string
        if (!is_null($ticketFreeKeyX) && !is_string($ticketFreeKeyX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketFreeKeyX)), __LINE__);
        }
        $this->TicketFreeKeyX = $ticketFreeKeyX;
        return $this;
    }
    /**
     * Get TicketFreeTextX value
     * @return string|null
     */
    public function getTicketFreeTextX()
    {
        return $this->TicketFreeTextX;
    }
    /**
     * Set TicketFreeTextX value
     * @param string $ticketFreeTextX
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setTicketFreeTextX($ticketFreeTextX = null)
    {
        // validation for constraint: string
        if (!is_null($ticketFreeTextX) && !is_string($ticketFreeTextX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketFreeTextX)), __LINE__);
        }
        $this->TicketFreeTextX = $ticketFreeTextX;
        return $this;
    }
    /**
     * Get TicketFreeTimeX value
     * @return string|null
     */
    public function getTicketFreeTimeX()
    {
        return $this->TicketFreeTimeX;
    }
    /**
     * Set TicketFreeTimeX value
     * @param string $ticketFreeTimeX
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setTicketFreeTimeX($ticketFreeTimeX = null)
    {
        // validation for constraint: string
        if (!is_null($ticketFreeTimeX) && !is_string($ticketFreeTimeX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketFreeTimeX)), __LINE__);
        }
        $this->TicketFreeTimeX = $ticketFreeTimeX;
        return $this;
    }
    /**
     * Get TimeUnit value
     * @return float|null
     */
    public function getTimeUnit()
    {
        return $this->TimeUnit;
    }
    /**
     * Set TimeUnit value
     * @param float $timeUnit
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public function setTimeUnit($timeUnit = null)
    {
        $this->TimeUnit = $timeUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTRS_TicketGetResponse_Ticket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
