<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTRS_TicketGetResponse_Article StructType
 * @subpackage Structs
 */
class OTRS_TicketGetResponse_Article extends AbstractStructBase
{
    /**
     * The Created
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Created;
    /**
     * The CustomerUserID
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $CustomerUserID;
    /**
     * The LockID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LockID;
    /**
     * The MessageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MessageID;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $Owner;
    /**
     * The OwnerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OwnerID;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $Priority;
    /**
     * The PriorityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PriorityID;
    /**
     * The Queue
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $Queue;
    /**
     * The QueueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QueueID;
    /**
     * The References
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $References;
    /**
     * The ReplyTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $ReplyTo;
    /**
     * The Responsible
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $Responsible;
    /**
     * The ResponsibleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResponsibleID;
    /**
     * The SenderType
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $SenderType;
    /**
     * The SenderTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SenderTypeID;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $State;
    /**
     * The StateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StateID;
    /**
     * The StateType
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $StateType;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $Subject;
    /**
     * The TicketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketID;
    /**
     * The TicketNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TicketNumber;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Title;
    /**
     * The To
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $To;
    /**
     * The ToRealname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ToRealname;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The TypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TypeID;
    /**
     * The UntilTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UntilTime;
    /**
     * The Age
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $Age;
    /**
     * The AgeTimeUnix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $AgeTimeUnix;
    /**
     * The ArticleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $ArticleID;
    /**
     * The ArticleType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $ArticleType;
    /**
     * The ArticleTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $ArticleTypeID;
    /**
     * The Attachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OTRS_TicketGetResponse_Attachment[]
     */
    public $Attachment;
    /**
     * The Body
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $Body;
    /**
     * The Cc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $Cc;
    /**
     * The CcRealname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CcRealname;
    /**
     * The Changed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $Changed;
    /**
     * The Charset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $Charset;
    /**
     * The Closed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Closed;
    /**
     * The ContentCharset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $ContentCharset;
    /**
     * The ContentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $ContentType;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $CreatedBy;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerID;
    /**
     * The DynamicField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DynamicField;
    /**
     * The EscalationDestinationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EscalationDestinationDate;
    /**
     * The EscalationDestinationIn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EscalationDestinationIn;
    /**
     * The EscalationDestinationTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EscalationDestinationTime;
    /**
     * The EscalationResponseTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EscalationResponseTime;
    /**
     * The EscalationSolutionTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EscalationSolutionTime;
    /**
     * The EscalationTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $EscalationTime;
    /**
     * The EscalationTimeWorkingTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EscalationTimeWorkingTime;
    /**
     * The EscalationUpdateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EscalationUpdateTime;
    /**
     * The FirstLock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstLock;
    /**
     * The From
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $From;
    /**
     * The FromRealname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FromRealname;
    /**
     * The InReplyTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InReplyTo;
    /**
     * The IncomingTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IncomingTime;
    /**
     * The Lock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Lock;
    /**
     * The MimeType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MimeType;
    /**
     * The RealTillTimeNotUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RealTillTimeNotUsed;
    /**
     * The SLA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SLA;
    /**
     * The SLAID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SLAID;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Service;
    /**
     * The ServiceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ServiceID;
    /**
     * The SolutionTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SolutionTime;
    /**
     * The SolutionTimeDestinationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SolutionTimeDestinationDate;
    /**
     * The SolutionTimeDestinationTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SolutionTimeDestinationTime;
    /**
     * The SolutionTimeWorkingTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SolutionTimeWorkingTime;
    /**
     * The TicketFreeKeyX
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TicketFreeKeyX;
    /**
     * The TicketFreeTextX
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TicketFreeTextX;
    /**
     * The TicketFreeTimeX
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TicketFreeTimeX;
    /**
     * The TimeUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TimeUnit;
    /**
     * Constructor method for OTRS_TicketGetResponse_Article
     * @uses OTRS_TicketGetResponse_Article::setCreated()
     * @uses OTRS_TicketGetResponse_Article::setCustomerUserID()
     * @uses OTRS_TicketGetResponse_Article::setLockID()
     * @uses OTRS_TicketGetResponse_Article::setMessageID()
     * @uses OTRS_TicketGetResponse_Article::setOwner()
     * @uses OTRS_TicketGetResponse_Article::setOwnerID()
     * @uses OTRS_TicketGetResponse_Article::setPriority()
     * @uses OTRS_TicketGetResponse_Article::setPriorityID()
     * @uses OTRS_TicketGetResponse_Article::setQueue()
     * @uses OTRS_TicketGetResponse_Article::setQueueID()
     * @uses OTRS_TicketGetResponse_Article::setReferences()
     * @uses OTRS_TicketGetResponse_Article::setReplyTo()
     * @uses OTRS_TicketGetResponse_Article::setResponsible()
     * @uses OTRS_TicketGetResponse_Article::setResponsibleID()
     * @uses OTRS_TicketGetResponse_Article::setSenderType()
     * @uses OTRS_TicketGetResponse_Article::setSenderTypeID()
     * @uses OTRS_TicketGetResponse_Article::setState()
     * @uses OTRS_TicketGetResponse_Article::setStateID()
     * @uses OTRS_TicketGetResponse_Article::setStateType()
     * @uses OTRS_TicketGetResponse_Article::setSubject()
     * @uses OTRS_TicketGetResponse_Article::setTicketID()
     * @uses OTRS_TicketGetResponse_Article::setTicketNumber()
     * @uses OTRS_TicketGetResponse_Article::setTitle()
     * @uses OTRS_TicketGetResponse_Article::setTo()
     * @uses OTRS_TicketGetResponse_Article::setToRealname()
     * @uses OTRS_TicketGetResponse_Article::setType()
     * @uses OTRS_TicketGetResponse_Article::setTypeID()
     * @uses OTRS_TicketGetResponse_Article::setUntilTime()
     * @uses OTRS_TicketGetResponse_Article::setAge()
     * @uses OTRS_TicketGetResponse_Article::setAgeTimeUnix()
     * @uses OTRS_TicketGetResponse_Article::setArticleID()
     * @uses OTRS_TicketGetResponse_Article::setArticleType()
     * @uses OTRS_TicketGetResponse_Article::setArticleTypeID()
     * @uses OTRS_TicketGetResponse_Article::setAttachment()
     * @uses OTRS_TicketGetResponse_Article::setBody()
     * @uses OTRS_TicketGetResponse_Article::setCc()
     * @uses OTRS_TicketGetResponse_Article::setCcRealname()
     * @uses OTRS_TicketGetResponse_Article::setChanged()
     * @uses OTRS_TicketGetResponse_Article::setCharset()
     * @uses OTRS_TicketGetResponse_Article::setClosed()
     * @uses OTRS_TicketGetResponse_Article::setContentCharset()
     * @uses OTRS_TicketGetResponse_Article::setContentType()
     * @uses OTRS_TicketGetResponse_Article::setCreatedBy()
     * @uses OTRS_TicketGetResponse_Article::setCustomerID()
     * @uses OTRS_TicketGetResponse_Article::setDynamicField()
     * @uses OTRS_TicketGetResponse_Article::setEscalationDestinationDate()
     * @uses OTRS_TicketGetResponse_Article::setEscalationDestinationIn()
     * @uses OTRS_TicketGetResponse_Article::setEscalationDestinationTime()
     * @uses OTRS_TicketGetResponse_Article::setEscalationResponseTime()
     * @uses OTRS_TicketGetResponse_Article::setEscalationSolutionTime()
     * @uses OTRS_TicketGetResponse_Article::setEscalationTime()
     * @uses OTRS_TicketGetResponse_Article::setEscalationTimeWorkingTime()
     * @uses OTRS_TicketGetResponse_Article::setEscalationUpdateTime()
     * @uses OTRS_TicketGetResponse_Article::setFirstLock()
     * @uses OTRS_TicketGetResponse_Article::setFrom()
     * @uses OTRS_TicketGetResponse_Article::setFromRealname()
     * @uses OTRS_TicketGetResponse_Article::setInReplyTo()
     * @uses OTRS_TicketGetResponse_Article::setIncomingTime()
     * @uses OTRS_TicketGetResponse_Article::setLock()
     * @uses OTRS_TicketGetResponse_Article::setMimeType()
     * @uses OTRS_TicketGetResponse_Article::setRealTillTimeNotUsed()
     * @uses OTRS_TicketGetResponse_Article::setSLA()
     * @uses OTRS_TicketGetResponse_Article::setSLAID()
     * @uses OTRS_TicketGetResponse_Article::setService()
     * @uses OTRS_TicketGetResponse_Article::setServiceID()
     * @uses OTRS_TicketGetResponse_Article::setSolutionTime()
     * @uses OTRS_TicketGetResponse_Article::setSolutionTimeDestinationDate()
     * @uses OTRS_TicketGetResponse_Article::setSolutionTimeDestinationTime()
     * @uses OTRS_TicketGetResponse_Article::setSolutionTimeWorkingTime()
     * @uses OTRS_TicketGetResponse_Article::setTicketFreeKeyX()
     * @uses OTRS_TicketGetResponse_Article::setTicketFreeTextX()
     * @uses OTRS_TicketGetResponse_Article::setTicketFreeTimeX()
     * @uses OTRS_TicketGetResponse_Article::setTimeUnit()
     * @param string $created
     * @param string $customerUserID
     * @param int $lockID
     * @param int $messageID
     * @param string $owner
     * @param int $ownerID
     * @param string $priority
     * @param int $priorityID
     * @param string $queue
     * @param int $queueID
     * @param string $references
     * @param string $replyTo
     * @param string $responsible
     * @param int $responsibleID
     * @param string $senderType
     * @param int $senderTypeID
     * @param string $state
     * @param int $stateID
     * @param string $stateType
     * @param string $subject
     * @param int $ticketID
     * @param string $ticketNumber
     * @param string $title
     * @param string $to
     * @param string $toRealname
     * @param string $type
     * @param int $typeID
     * @param int $untilTime
     * @param int $age
     * @param int $ageTimeUnix
     * @param int $articleID
     * @param string $articleType
     * @param int $articleTypeID
     * @param \StructType\OTRS_TicketGetResponse_Attachment[] $attachment
     * @param string $body
     * @param string $cc
     * @param string $ccRealname
     * @param string $changed
     * @param string $charset
     * @param string $closed
     * @param string $contentCharset
     * @param string $contentType
     * @param int $createdBy
     * @param string $customerID
     * @param string[] $dynamicField
     * @param string $escalationDestinationDate
     * @param string $escalationDestinationIn
     * @param string $escalationDestinationTime
     * @param string $escalationResponseTime
     * @param string $escalationSolutionTime
     * @param string $escalationTime
     * @param string $escalationTimeWorkingTime
     * @param string $escalationUpdateTime
     * @param string $firstLock
     * @param string $from
     * @param string $fromRealname
     * @param string $inReplyTo
     * @param string $incomingTime
     * @param string $lock
     * @param string $mimeType
     * @param string $realTillTimeNotUsed
     * @param string $sLA
     * @param int $sLAID
     * @param string $service
     * @param int $serviceID
     * @param string $solutionTime
     * @param string $solutionTimeDestinationDate
     * @param string $solutionTimeDestinationTime
     * @param string $solutionTimeWorkingTime
     * @param string $ticketFreeKeyX
     * @param string $ticketFreeTextX
     * @param string $ticketFreeTimeX
     * @param float $timeUnit
     */
    public function __construct($created = null, $customerUserID = null, $lockID = null, $messageID = null, $owner = null, $ownerID = null, $priority = null, $priorityID = null, $queue = null, $queueID = null, $references = null, $replyTo = null, $responsible = null, $responsibleID = null, $senderType = null, $senderTypeID = null, $state = null, $stateID = null, $stateType = null, $subject = null, $ticketID = null, $ticketNumber = null, $title = null, $to = null, $toRealname = null, $type = null, $typeID = null, $untilTime = null, $age = null, $ageTimeUnix = null, $articleID = null, $articleType = null, $articleTypeID = null, array $attachment = array(), $body = null, $cc = null, $ccRealname = null, $changed = null, $charset = null, $closed = null, $contentCharset = null, $contentType = null, $createdBy = null, $customerID = null, array $dynamicField = array(), $escalationDestinationDate = null, $escalationDestinationIn = null, $escalationDestinationTime = null, $escalationResponseTime = null, $escalationSolutionTime = null, $escalationTime = null, $escalationTimeWorkingTime = null, $escalationUpdateTime = null, $firstLock = null, $from = null, $fromRealname = null, $inReplyTo = null, $incomingTime = null, $lock = null, $mimeType = null, $realTillTimeNotUsed = null, $sLA = null, $sLAID = null, $service = null, $serviceID = null, $solutionTime = null, $solutionTimeDestinationDate = null, $solutionTimeDestinationTime = null, $solutionTimeWorkingTime = null, $ticketFreeKeyX = null, $ticketFreeTextX = null, $ticketFreeTimeX = null, $timeUnit = null)
    {
        $this
            ->setCreated($created)
            ->setCustomerUserID($customerUserID)
            ->setLockID($lockID)
            ->setMessageID($messageID)
            ->setOwner($owner)
            ->setOwnerID($ownerID)
            ->setPriority($priority)
            ->setPriorityID($priorityID)
            ->setQueue($queue)
            ->setQueueID($queueID)
            ->setReferences($references)
            ->setReplyTo($replyTo)
            ->setResponsible($responsible)
            ->setResponsibleID($responsibleID)
            ->setSenderType($senderType)
            ->setSenderTypeID($senderTypeID)
            ->setState($state)
            ->setStateID($stateID)
            ->setStateType($stateType)
            ->setSubject($subject)
            ->setTicketID($ticketID)
            ->setTicketNumber($ticketNumber)
            ->setTitle($title)
            ->setTo($to)
            ->setToRealname($toRealname)
            ->setType($type)
            ->setTypeID($typeID)
            ->setUntilTime($untilTime)
            ->setAge($age)
            ->setAgeTimeUnix($ageTimeUnix)
            ->setArticleID($articleID)
            ->setArticleType($articleType)
            ->setArticleTypeID($articleTypeID)
            ->setAttachment($attachment)
            ->setBody($body)
            ->setCc($cc)
            ->setCcRealname($ccRealname)
            ->setChanged($changed)
            ->setCharset($charset)
            ->setClosed($closed)
            ->setContentCharset($contentCharset)
            ->setContentType($contentType)
            ->setCreatedBy($createdBy)
            ->setCustomerID($customerID)
            ->setDynamicField($dynamicField)
            ->setEscalationDestinationDate($escalationDestinationDate)
            ->setEscalationDestinationIn($escalationDestinationIn)
            ->setEscalationDestinationTime($escalationDestinationTime)
            ->setEscalationResponseTime($escalationResponseTime)
            ->setEscalationSolutionTime($escalationSolutionTime)
            ->setEscalationTime($escalationTime)
            ->setEscalationTimeWorkingTime($escalationTimeWorkingTime)
            ->setEscalationUpdateTime($escalationUpdateTime)
            ->setFirstLock($firstLock)
            ->setFrom($from)
            ->setFromRealname($fromRealname)
            ->setInReplyTo($inReplyTo)
            ->setIncomingTime($incomingTime)
            ->setLock($lock)
            ->setMimeType($mimeType)
            ->setRealTillTimeNotUsed($realTillTimeNotUsed)
            ->setSLA($sLA)
            ->setSLAID($sLAID)
            ->setService($service)
            ->setServiceID($serviceID)
            ->setSolutionTime($solutionTime)
            ->setSolutionTimeDestinationDate($solutionTimeDestinationDate)
            ->setSolutionTimeDestinationTime($solutionTimeDestinationTime)
            ->setSolutionTimeWorkingTime($solutionTimeWorkingTime)
            ->setTicketFreeKeyX($ticketFreeKeyX)
            ->setTicketFreeTextX($ticketFreeTextX)
            ->setTicketFreeTimeX($ticketFreeTimeX)
            ->setTimeUnit($timeUnit);
    }
    /**
     * Get Created value
     * @return string
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created)), __LINE__);
        }
        $this->Created = $created;
        return $this;
    }
    /**
     * Get CustomerUserID value
     * @return string
     */
    public function getCustomerUserID()
    {
        return $this->CustomerUserID;
    }
    /**
     * Set CustomerUserID value
     * @param string $customerUserID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setCustomerUserID($customerUserID = null)
    {
        // validation for constraint: string
        if (!is_null($customerUserID) && !is_string($customerUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerUserID)), __LINE__);
        }
        $this->CustomerUserID = $customerUserID;
        return $this;
    }
    /**
     * Get LockID value
     * @return int
     */
    public function getLockID()
    {
        return $this->LockID;
    }
    /**
     * Set LockID value
     * @param int $lockID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setLockID($lockID = null)
    {
        // validation for constraint: int
        if (!is_null($lockID) && !is_numeric($lockID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lockID)), __LINE__);
        }
        $this->LockID = $lockID;
        return $this;
    }
    /**
     * Get MessageID value
     * @return int
     */
    public function getMessageID()
    {
        return $this->MessageID;
    }
    /**
     * Set MessageID value
     * @param int $messageID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setMessageID($messageID = null)
    {
        // validation for constraint: int
        if (!is_null($messageID) && !is_numeric($messageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($messageID)), __LINE__);
        }
        $this->MessageID = $messageID;
        return $this;
    }
    /**
     * Get Owner value
     * @return string
     */
    public function getOwner()
    {
        return $this->Owner;
    }
    /**
     * Set Owner value
     * @param string $owner
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($owner)), __LINE__);
        }
        $this->Owner = $owner;
        return $this;
    }
    /**
     * Get OwnerID value
     * @return int
     */
    public function getOwnerID()
    {
        return $this->OwnerID;
    }
    /**
     * Set OwnerID value
     * @param int $ownerID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setOwnerID($ownerID = null)
    {
        // validation for constraint: int
        if (!is_null($ownerID) && !is_numeric($ownerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ownerID)), __LINE__);
        }
        $this->OwnerID = $ownerID;
        return $this;
    }
    /**
     * Get Priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param string $priority
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get PriorityID value
     * @return int
     */
    public function getPriorityID()
    {
        return $this->PriorityID;
    }
    /**
     * Set PriorityID value
     * @param int $priorityID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setPriorityID($priorityID = null)
    {
        // validation for constraint: int
        if (!is_null($priorityID) && !is_numeric($priorityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priorityID)), __LINE__);
        }
        $this->PriorityID = $priorityID;
        return $this;
    }
    /**
     * Get Queue value
     * @return string
     */
    public function getQueue()
    {
        return $this->Queue;
    }
    /**
     * Set Queue value
     * @param string $queue
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setQueue($queue = null)
    {
        // validation for constraint: string
        if (!is_null($queue) && !is_string($queue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queue)), __LINE__);
        }
        $this->Queue = $queue;
        return $this;
    }
    /**
     * Get QueueID value
     * @return int
     */
    public function getQueueID()
    {
        return $this->QueueID;
    }
    /**
     * Set QueueID value
     * @param int $queueID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setQueueID($queueID = null)
    {
        // validation for constraint: int
        if (!is_null($queueID) && !is_numeric($queueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($queueID)), __LINE__);
        }
        $this->QueueID = $queueID;
        return $this;
    }
    /**
     * Get References value
     * @return string
     */
    public function getReferences()
    {
        return $this->References;
    }
    /**
     * Set References value
     * @param string $references
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setReferences($references = null)
    {
        // validation for constraint: string
        if (!is_null($references) && !is_string($references)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($references)), __LINE__);
        }
        $this->References = $references;
        return $this;
    }
    /**
     * Get ReplyTo value
     * @return string
     */
    public function getReplyTo()
    {
        return $this->ReplyTo;
    }
    /**
     * Set ReplyTo value
     * @param string $replyTo
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setReplyTo($replyTo = null)
    {
        // validation for constraint: string
        if (!is_null($replyTo) && !is_string($replyTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($replyTo)), __LINE__);
        }
        $this->ReplyTo = $replyTo;
        return $this;
    }
    /**
     * Get Responsible value
     * @return string
     */
    public function getResponsible()
    {
        return $this->Responsible;
    }
    /**
     * Set Responsible value
     * @param string $responsible
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setResponsible($responsible = null)
    {
        // validation for constraint: string
        if (!is_null($responsible) && !is_string($responsible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responsible)), __LINE__);
        }
        $this->Responsible = $responsible;
        return $this;
    }
    /**
     * Get ResponsibleID value
     * @return int
     */
    public function getResponsibleID()
    {
        return $this->ResponsibleID;
    }
    /**
     * Set ResponsibleID value
     * @param int $responsibleID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setResponsibleID($responsibleID = null)
    {
        // validation for constraint: int
        if (!is_null($responsibleID) && !is_numeric($responsibleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responsibleID)), __LINE__);
        }
        $this->ResponsibleID = $responsibleID;
        return $this;
    }
    /**
     * Get SenderType value
     * @return string
     */
    public function getSenderType()
    {
        return $this->SenderType;
    }
    /**
     * Set SenderType value
     * @param string $senderType
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setSenderType($senderType = null)
    {
        // validation for constraint: string
        if (!is_null($senderType) && !is_string($senderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderType)), __LINE__);
        }
        $this->SenderType = $senderType;
        return $this;
    }
    /**
     * Get SenderTypeID value
     * @return int
     */
    public function getSenderTypeID()
    {
        return $this->SenderTypeID;
    }
    /**
     * Set SenderTypeID value
     * @param int $senderTypeID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setSenderTypeID($senderTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($senderTypeID) && !is_numeric($senderTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($senderTypeID)), __LINE__);
        }
        $this->SenderTypeID = $senderTypeID;
        return $this;
    }
    /**
     * Get State value
     * @return string
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get StateID value
     * @return int
     */
    public function getStateID()
    {
        return $this->StateID;
    }
    /**
     * Set StateID value
     * @param int $stateID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setStateID($stateID = null)
    {
        // validation for constraint: int
        if (!is_null($stateID) && !is_numeric($stateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stateID)), __LINE__);
        }
        $this->StateID = $stateID;
        return $this;
    }
    /**
     * Get StateType value
     * @return string
     */
    public function getStateType()
    {
        return $this->StateType;
    }
    /**
     * Set StateType value
     * @param string $stateType
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setStateType($stateType = null)
    {
        // validation for constraint: string
        if (!is_null($stateType) && !is_string($stateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateType)), __LINE__);
        }
        $this->StateType = $stateType;
        return $this;
    }
    /**
     * Get Subject value
     * @return string
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get TicketID value
     * @return int
     */
    public function getTicketID()
    {
        return $this->TicketID;
    }
    /**
     * Set TicketID value
     * @param int $ticketID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setTicketID($ticketID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketID) && !is_numeric($ticketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketID)), __LINE__);
        }
        $this->TicketID = $ticketID;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get Title value
     * @return string
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get To value
     * @return string
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
    /**
     * Get ToRealname value
     * @return string
     */
    public function getToRealname()
    {
        return $this->ToRealname;
    }
    /**
     * Set ToRealname value
     * @param string $toRealname
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setToRealname($toRealname = null)
    {
        // validation for constraint: string
        if (!is_null($toRealname) && !is_string($toRealname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toRealname)), __LINE__);
        }
        $this->ToRealname = $toRealname;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TypeID value
     * @return int
     */
    public function getTypeID()
    {
        return $this->TypeID;
    }
    /**
     * Set TypeID value
     * @param int $typeID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setTypeID($typeID = null)
    {
        // validation for constraint: int
        if (!is_null($typeID) && !is_numeric($typeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($typeID)), __LINE__);
        }
        $this->TypeID = $typeID;
        return $this;
    }
    /**
     * Get UntilTime value
     * @return int
     */
    public function getUntilTime()
    {
        return $this->UntilTime;
    }
    /**
     * Set UntilTime value
     * @param int $untilTime
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setUntilTime($untilTime = null)
    {
        // validation for constraint: int
        if (!is_null($untilTime) && !is_numeric($untilTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($untilTime)), __LINE__);
        }
        $this->UntilTime = $untilTime;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !is_numeric($age)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get AgeTimeUnix value
     * @return int|null
     */
    public function getAgeTimeUnix()
    {
        return $this->AgeTimeUnix;
    }
    /**
     * Set AgeTimeUnix value
     * @param int $ageTimeUnix
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setAgeTimeUnix($ageTimeUnix = null)
    {
        // validation for constraint: int
        if (!is_null($ageTimeUnix) && !is_numeric($ageTimeUnix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ageTimeUnix)), __LINE__);
        }
        $this->AgeTimeUnix = $ageTimeUnix;
        return $this;
    }
    /**
     * Get ArticleID value
     * @return int|null
     */
    public function getArticleID()
    {
        return $this->ArticleID;
    }
    /**
     * Set ArticleID value
     * @param int $articleID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setArticleID($articleID = null)
    {
        // validation for constraint: int
        if (!is_null($articleID) && !is_numeric($articleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($articleID)), __LINE__);
        }
        $this->ArticleID = $articleID;
        return $this;
    }
    /**
     * Get ArticleType value
     * @return string|null
     */
    public function getArticleType()
    {
        return $this->ArticleType;
    }
    /**
     * Set ArticleType value
     * @param string $articleType
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setArticleType($articleType = null)
    {
        // validation for constraint: string
        if (!is_null($articleType) && !is_string($articleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($articleType)), __LINE__);
        }
        $this->ArticleType = $articleType;
        return $this;
    }
    /**
     * Get ArticleTypeID value
     * @return int|null
     */
    public function getArticleTypeID()
    {
        return $this->ArticleTypeID;
    }
    /**
     * Set ArticleTypeID value
     * @param int $articleTypeID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setArticleTypeID($articleTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($articleTypeID) && !is_numeric($articleTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($articleTypeID)), __LINE__);
        }
        $this->ArticleTypeID = $articleTypeID;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \StructType\OTRS_TicketGetResponse_Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_TicketGetResponse_Attachment[] $attachment
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setAttachment(array $attachment = array())
    {
        foreach ($attachment as $oTRS_TicketGetResponse_ArticleAttachmentItem) {
            // validation for constraint: itemType
            if (!$oTRS_TicketGetResponse_ArticleAttachmentItem instanceof \StructType\OTRS_TicketGetResponse_Attachment) {
                throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of \StructType\OTRS_TicketGetResponse_Attachment, "%s" given', is_object($oTRS_TicketGetResponse_ArticleAttachmentItem) ? get_class($oTRS_TicketGetResponse_ArticleAttachmentItem) : gettype($oTRS_TicketGetResponse_ArticleAttachmentItem)), __LINE__);
            }
        }
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Add item to Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\OTRS_TicketGetResponse_Attachment $item
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function addToAttachment(\StructType\OTRS_TicketGetResponse_Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OTRS_TicketGetResponse_Attachment) {
            throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of \StructType\OTRS_TicketGetResponse_Attachment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attachment[] = $item;
        return $this;
    }
    /**
     * Get Body value
     * @return string|null
     */
    public function getBody()
    {
        return $this->Body;
    }
    /**
     * Set Body value
     * @param string $body
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setBody($body = null)
    {
        // validation for constraint: string
        if (!is_null($body) && !is_string($body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($body)), __LINE__);
        }
        $this->Body = $body;
        return $this;
    }
    /**
     * Get Cc value
     * @return string|null
     */
    public function getCc()
    {
        return $this->Cc;
    }
    /**
     * Set Cc value
     * @param string $cc
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setCc($cc = null)
    {
        // validation for constraint: string
        if (!is_null($cc) && !is_string($cc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cc)), __LINE__);
        }
        $this->Cc = $cc;
        return $this;
    }
    /**
     * Get CcRealname value
     * @return string|null
     */
    public function getCcRealname()
    {
        return $this->CcRealname;
    }
    /**
     * Set CcRealname value
     * @param string $ccRealname
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setCcRealname($ccRealname = null)
    {
        // validation for constraint: string
        if (!is_null($ccRealname) && !is_string($ccRealname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ccRealname)), __LINE__);
        }
        $this->CcRealname = $ccRealname;
        return $this;
    }
    /**
     * Get Changed value
     * @return string|null
     */
    public function getChanged()
    {
        return $this->Changed;
    }
    /**
     * Set Changed value
     * @param string $changed
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setChanged($changed = null)
    {
        // validation for constraint: string
        if (!is_null($changed) && !is_string($changed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changed)), __LINE__);
        }
        $this->Changed = $changed;
        return $this;
    }
    /**
     * Get Charset value
     * @return string|null
     */
    public function getCharset()
    {
        return $this->Charset;
    }
    /**
     * Set Charset value
     * @param string $charset
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setCharset($charset = null)
    {
        // validation for constraint: string
        if (!is_null($charset) && !is_string($charset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charset)), __LINE__);
        }
        $this->Charset = $charset;
        return $this;
    }
    /**
     * Get Closed value
     * @return string|null
     */
    public function getClosed()
    {
        return $this->Closed;
    }
    /**
     * Set Closed value
     * @param string $closed
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setClosed($closed = null)
    {
        // validation for constraint: string
        if (!is_null($closed) && !is_string($closed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($closed)), __LINE__);
        }
        $this->Closed = $closed;
        return $this;
    }
    /**
     * Get ContentCharset value
     * @return string|null
     */
    public function getContentCharset()
    {
        return $this->ContentCharset;
    }
    /**
     * Set ContentCharset value
     * @param string $contentCharset
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setContentCharset($contentCharset = null)
    {
        // validation for constraint: string
        if (!is_null($contentCharset) && !is_string($contentCharset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentCharset)), __LINE__);
        }
        $this->ContentCharset = $contentCharset;
        return $this;
    }
    /**
     * Get ContentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return int|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param int $createdBy
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: int
        if (!is_null($createdBy) && !is_numeric($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return string|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param string $customerID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: string
        if (!is_null($customerID) && !is_string($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get DynamicField value
     * @return string[]|null
     */
    public function getDynamicField()
    {
        return $this->DynamicField;
    }
    /**
     * Set DynamicField value
     * @throws \InvalidArgumentException
     * @param string[] $dynamicField
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setDynamicField(array $dynamicField = array())
    {
        foreach ($dynamicField as $oTRS_TicketGetResponse_ArticleDynamicFieldItem) {
            // validation for constraint: itemType
            if (!is_string($oTRS_TicketGetResponse_ArticleDynamicFieldItem)) {
                throw new \InvalidArgumentException(sprintf('The DynamicField property can only contain items of string, "%s" given', is_object($oTRS_TicketGetResponse_ArticleDynamicFieldItem) ? get_class($oTRS_TicketGetResponse_ArticleDynamicFieldItem) : gettype($oTRS_TicketGetResponse_ArticleDynamicFieldItem)), __LINE__);
            }
        }
        $this->DynamicField = $dynamicField;
        return $this;
    }
    /**
     * Add item to DynamicField value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function addToDynamicField($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DynamicField property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DynamicField[] = $item;
        return $this;
    }
    /**
     * Get EscalationDestinationDate value
     * @return string|null
     */
    public function getEscalationDestinationDate()
    {
        return $this->EscalationDestinationDate;
    }
    /**
     * Set EscalationDestinationDate value
     * @param string $escalationDestinationDate
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setEscalationDestinationDate($escalationDestinationDate = null)
    {
        // validation for constraint: string
        if (!is_null($escalationDestinationDate) && !is_string($escalationDestinationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationDestinationDate)), __LINE__);
        }
        $this->EscalationDestinationDate = $escalationDestinationDate;
        return $this;
    }
    /**
     * Get EscalationDestinationIn value
     * @return string|null
     */
    public function getEscalationDestinationIn()
    {
        return $this->EscalationDestinationIn;
    }
    /**
     * Set EscalationDestinationIn value
     * @param string $escalationDestinationIn
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setEscalationDestinationIn($escalationDestinationIn = null)
    {
        // validation for constraint: string
        if (!is_null($escalationDestinationIn) && !is_string($escalationDestinationIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationDestinationIn)), __LINE__);
        }
        $this->EscalationDestinationIn = $escalationDestinationIn;
        return $this;
    }
    /**
     * Get EscalationDestinationTime value
     * @return string|null
     */
    public function getEscalationDestinationTime()
    {
        return $this->EscalationDestinationTime;
    }
    /**
     * Set EscalationDestinationTime value
     * @param string $escalationDestinationTime
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setEscalationDestinationTime($escalationDestinationTime = null)
    {
        // validation for constraint: string
        if (!is_null($escalationDestinationTime) && !is_string($escalationDestinationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationDestinationTime)), __LINE__);
        }
        $this->EscalationDestinationTime = $escalationDestinationTime;
        return $this;
    }
    /**
     * Get EscalationResponseTime value
     * @return string|null
     */
    public function getEscalationResponseTime()
    {
        return $this->EscalationResponseTime;
    }
    /**
     * Set EscalationResponseTime value
     * @param string $escalationResponseTime
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setEscalationResponseTime($escalationResponseTime = null)
    {
        // validation for constraint: string
        if (!is_null($escalationResponseTime) && !is_string($escalationResponseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationResponseTime)), __LINE__);
        }
        $this->EscalationResponseTime = $escalationResponseTime;
        return $this;
    }
    /**
     * Get EscalationSolutionTime value
     * @return string|null
     */
    public function getEscalationSolutionTime()
    {
        return $this->EscalationSolutionTime;
    }
    /**
     * Set EscalationSolutionTime value
     * @param string $escalationSolutionTime
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setEscalationSolutionTime($escalationSolutionTime = null)
    {
        // validation for constraint: string
        if (!is_null($escalationSolutionTime) && !is_string($escalationSolutionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationSolutionTime)), __LINE__);
        }
        $this->EscalationSolutionTime = $escalationSolutionTime;
        return $this;
    }
    /**
     * Get EscalationTime value
     * @return string|null
     */
    public function getEscalationTime()
    {
        return $this->EscalationTime;
    }
    /**
     * Set EscalationTime value
     * @param string $escalationTime
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setEscalationTime($escalationTime = null)
    {
        // validation for constraint: string
        if (!is_null($escalationTime) && !is_string($escalationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationTime)), __LINE__);
        }
        $this->EscalationTime = $escalationTime;
        return $this;
    }
    /**
     * Get EscalationTimeWorkingTime value
     * @return string|null
     */
    public function getEscalationTimeWorkingTime()
    {
        return $this->EscalationTimeWorkingTime;
    }
    /**
     * Set EscalationTimeWorkingTime value
     * @param string $escalationTimeWorkingTime
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setEscalationTimeWorkingTime($escalationTimeWorkingTime = null)
    {
        // validation for constraint: string
        if (!is_null($escalationTimeWorkingTime) && !is_string($escalationTimeWorkingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationTimeWorkingTime)), __LINE__);
        }
        $this->EscalationTimeWorkingTime = $escalationTimeWorkingTime;
        return $this;
    }
    /**
     * Get EscalationUpdateTime value
     * @return string|null
     */
    public function getEscalationUpdateTime()
    {
        return $this->EscalationUpdateTime;
    }
    /**
     * Set EscalationUpdateTime value
     * @param string $escalationUpdateTime
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setEscalationUpdateTime($escalationUpdateTime = null)
    {
        // validation for constraint: string
        if (!is_null($escalationUpdateTime) && !is_string($escalationUpdateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($escalationUpdateTime)), __LINE__);
        }
        $this->EscalationUpdateTime = $escalationUpdateTime;
        return $this;
    }
    /**
     * Get FirstLock value
     * @return string|null
     */
    public function getFirstLock()
    {
        return $this->FirstLock;
    }
    /**
     * Set FirstLock value
     * @param string $firstLock
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setFirstLock($firstLock = null)
    {
        // validation for constraint: string
        if (!is_null($firstLock) && !is_string($firstLock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstLock)), __LINE__);
        }
        $this->FirstLock = $firstLock;
        return $this;
    }
    /**
     * Get From value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get FromRealname value
     * @return string|null
     */
    public function getFromRealname()
    {
        return $this->FromRealname;
    }
    /**
     * Set FromRealname value
     * @param string $fromRealname
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setFromRealname($fromRealname = null)
    {
        // validation for constraint: string
        if (!is_null($fromRealname) && !is_string($fromRealname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromRealname)), __LINE__);
        }
        $this->FromRealname = $fromRealname;
        return $this;
    }
    /**
     * Get InReplyTo value
     * @return string|null
     */
    public function getInReplyTo()
    {
        return $this->InReplyTo;
    }
    /**
     * Set InReplyTo value
     * @param string $inReplyTo
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setInReplyTo($inReplyTo = null)
    {
        // validation for constraint: string
        if (!is_null($inReplyTo) && !is_string($inReplyTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inReplyTo)), __LINE__);
        }
        $this->InReplyTo = $inReplyTo;
        return $this;
    }
    /**
     * Get IncomingTime value
     * @return string|null
     */
    public function getIncomingTime()
    {
        return $this->IncomingTime;
    }
    /**
     * Set IncomingTime value
     * @param string $incomingTime
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setIncomingTime($incomingTime = null)
    {
        // validation for constraint: string
        if (!is_null($incomingTime) && !is_string($incomingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($incomingTime)), __LINE__);
        }
        $this->IncomingTime = $incomingTime;
        return $this;
    }
    /**
     * Get Lock value
     * @return string|null
     */
    public function getLock()
    {
        return $this->Lock;
    }
    /**
     * Set Lock value
     * @param string $lock
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setLock($lock = null)
    {
        // validation for constraint: string
        if (!is_null($lock) && !is_string($lock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lock)), __LINE__);
        }
        $this->Lock = $lock;
        return $this;
    }
    /**
     * Get MimeType value
     * @return string|null
     */
    public function getMimeType()
    {
        return $this->MimeType;
    }
    /**
     * Set MimeType value
     * @param string $mimeType
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mimeType)), __LINE__);
        }
        $this->MimeType = $mimeType;
        return $this;
    }
    /**
     * Get RealTillTimeNotUsed value
     * @return string|null
     */
    public function getRealTillTimeNotUsed()
    {
        return $this->RealTillTimeNotUsed;
    }
    /**
     * Set RealTillTimeNotUsed value
     * @param string $realTillTimeNotUsed
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setRealTillTimeNotUsed($realTillTimeNotUsed = null)
    {
        // validation for constraint: string
        if (!is_null($realTillTimeNotUsed) && !is_string($realTillTimeNotUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($realTillTimeNotUsed)), __LINE__);
        }
        $this->RealTillTimeNotUsed = $realTillTimeNotUsed;
        return $this;
    }
    /**
     * Get SLA value
     * @return string|null
     */
    public function getSLA()
    {
        return $this->SLA;
    }
    /**
     * Set SLA value
     * @param string $sLA
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setSLA($sLA = null)
    {
        // validation for constraint: string
        if (!is_null($sLA) && !is_string($sLA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sLA)), __LINE__);
        }
        $this->SLA = $sLA;
        return $this;
    }
    /**
     * Get SLAID value
     * @return int|null
     */
    public function getSLAID()
    {
        return $this->SLAID;
    }
    /**
     * Set SLAID value
     * @param int $sLAID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setSLAID($sLAID = null)
    {
        // validation for constraint: int
        if (!is_null($sLAID) && !is_numeric($sLAID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sLAID)), __LINE__);
        }
        $this->SLAID = $sLAID;
        return $this;
    }
    /**
     * Get Service value
     * @return string|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param string $service
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($service)), __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Get ServiceID value
     * @return int|null
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param int $serviceID
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceID) && !is_numeric($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get SolutionTime value
     * @return string|null
     */
    public function getSolutionTime()
    {
        return $this->SolutionTime;
    }
    /**
     * Set SolutionTime value
     * @param string $solutionTime
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setSolutionTime($solutionTime = null)
    {
        // validation for constraint: string
        if (!is_null($solutionTime) && !is_string($solutionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($solutionTime)), __LINE__);
        }
        $this->SolutionTime = $solutionTime;
        return $this;
    }
    /**
     * Get SolutionTimeDestinationDate value
     * @return string|null
     */
    public function getSolutionTimeDestinationDate()
    {
        return $this->SolutionTimeDestinationDate;
    }
    /**
     * Set SolutionTimeDestinationDate value
     * @param string $solutionTimeDestinationDate
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setSolutionTimeDestinationDate($solutionTimeDestinationDate = null)
    {
        // validation for constraint: string
        if (!is_null($solutionTimeDestinationDate) && !is_string($solutionTimeDestinationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($solutionTimeDestinationDate)), __LINE__);
        }
        $this->SolutionTimeDestinationDate = $solutionTimeDestinationDate;
        return $this;
    }
    /**
     * Get SolutionTimeDestinationTime value
     * @return string|null
     */
    public function getSolutionTimeDestinationTime()
    {
        return $this->SolutionTimeDestinationTime;
    }
    /**
     * Set SolutionTimeDestinationTime value
     * @param string $solutionTimeDestinationTime
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setSolutionTimeDestinationTime($solutionTimeDestinationTime = null)
    {
        // validation for constraint: string
        if (!is_null($solutionTimeDestinationTime) && !is_string($solutionTimeDestinationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($solutionTimeDestinationTime)), __LINE__);
        }
        $this->SolutionTimeDestinationTime = $solutionTimeDestinationTime;
        return $this;
    }
    /**
     * Get SolutionTimeWorkingTime value
     * @return string|null
     */
    public function getSolutionTimeWorkingTime()
    {
        return $this->SolutionTimeWorkingTime;
    }
    /**
     * Set SolutionTimeWorkingTime value
     * @param string $solutionTimeWorkingTime
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setSolutionTimeWorkingTime($solutionTimeWorkingTime = null)
    {
        // validation for constraint: string
        if (!is_null($solutionTimeWorkingTime) && !is_string($solutionTimeWorkingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($solutionTimeWorkingTime)), __LINE__);
        }
        $this->SolutionTimeWorkingTime = $solutionTimeWorkingTime;
        return $this;
    }
    /**
     * Get TicketFreeKeyX value
     * @return string|null
     */
    public function getTicketFreeKeyX()
    {
        return $this->TicketFreeKeyX;
    }
    /**
     * Set TicketFreeKeyX value
     * @param string $ticketFreeKeyX
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setTicketFreeKeyX($ticketFreeKeyX = null)
    {
        // validation for constraint: string
        if (!is_null($ticketFreeKeyX) && !is_string($ticketFreeKeyX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketFreeKeyX)), __LINE__);
        }
        $this->TicketFreeKeyX = $ticketFreeKeyX;
        return $this;
    }
    /**
     * Get TicketFreeTextX value
     * @return string|null
     */
    public function getTicketFreeTextX()
    {
        return $this->TicketFreeTextX;
    }
    /**
     * Set TicketFreeTextX value
     * @param string $ticketFreeTextX
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setTicketFreeTextX($ticketFreeTextX = null)
    {
        // validation for constraint: string
        if (!is_null($ticketFreeTextX) && !is_string($ticketFreeTextX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketFreeTextX)), __LINE__);
        }
        $this->TicketFreeTextX = $ticketFreeTextX;
        return $this;
    }
    /**
     * Get TicketFreeTimeX value
     * @return string|null
     */
    public function getTicketFreeTimeX()
    {
        return $this->TicketFreeTimeX;
    }
    /**
     * Set TicketFreeTimeX value
     * @param string $ticketFreeTimeX
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setTicketFreeTimeX($ticketFreeTimeX = null)
    {
        // validation for constraint: string
        if (!is_null($ticketFreeTimeX) && !is_string($ticketFreeTimeX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketFreeTimeX)), __LINE__);
        }
        $this->TicketFreeTimeX = $ticketFreeTimeX;
        return $this;
    }
    /**
     * Get TimeUnit value
     * @return float|null
     */
    public function getTimeUnit()
    {
        return $this->TimeUnit;
    }
    /**
     * Set TimeUnit value
     * @param float $timeUnit
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public function setTimeUnit($timeUnit = null)
    {
        $this->TimeUnit = $timeUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTRS_TicketGetResponse_Article
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
