<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTRS_PendingTime StructType
 * @subpackage Structs
 */
class OTRS_PendingTime extends AbstractStructBase
{
    /**
     * The Year
     * @var int
     */
    public $Year;
    /**
     * The Month
     * @var int
     */
    public $Month;
    /**
     * The Day
     * @var int
     */
    public $Day;
    /**
     * The Hour
     * @var int
     */
    public $Hour;
    /**
     * The Minute
     * @var int
     */
    public $Minute;
    /**
     * The Diff
     * @var int
     */
    public $Diff;
    /**
     * Constructor method for OTRS_PendingTime
     * @uses OTRS_PendingTime::setYear()
     * @uses OTRS_PendingTime::setMonth()
     * @uses OTRS_PendingTime::setDay()
     * @uses OTRS_PendingTime::setHour()
     * @uses OTRS_PendingTime::setMinute()
     * @uses OTRS_PendingTime::setDiff()
     * @param int $year
     * @param int $month
     * @param int $day
     * @param int $hour
     * @param int $minute
     * @param int $diff
     */
    public function __construct($year = null, $month = null, $day = null, $hour = null, $minute = null, $diff = null)
    {
        $this
            ->setYear($year)
            ->setMonth($month)
            ->setDay($day)
            ->setHour($hour)
            ->setMinute($minute)
            ->setDiff($diff);
    }
    /**
     * Get Year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->Year;
    }
    /**
     * Set Year value
     * @param int $year
     * @return \StructType\OTRS_PendingTime
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !is_numeric($year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($year)), __LINE__);
        }
        $this->Year = $year;
        return $this;
    }
    /**
     * Get Month value
     * @return int|null
     */
    public function getMonth()
    {
        return $this->Month;
    }
    /**
     * Set Month value
     * @param int $month
     * @return \StructType\OTRS_PendingTime
     */
    public function setMonth($month = null)
    {
        // validation for constraint: int
        if (!is_null($month) && !is_numeric($month)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($month)), __LINE__);
        }
        $this->Month = $month;
        return $this;
    }
    /**
     * Get Day value
     * @return int|null
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @param int $day
     * @return \StructType\OTRS_PendingTime
     */
    public function setDay($day = null)
    {
        // validation for constraint: int
        if (!is_null($day) && !is_numeric($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($day)), __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Get Hour value
     * @return int|null
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param int $hour
     * @return \StructType\OTRS_PendingTime
     */
    public function setHour($hour = null)
    {
        // validation for constraint: int
        if (!is_null($hour) && !is_numeric($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hour)), __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Get Minute value
     * @return int|null
     */
    public function getMinute()
    {
        return $this->Minute;
    }
    /**
     * Set Minute value
     * @param int $minute
     * @return \StructType\OTRS_PendingTime
     */
    public function setMinute($minute = null)
    {
        // validation for constraint: int
        if (!is_null($minute) && !is_numeric($minute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minute)), __LINE__);
        }
        $this->Minute = $minute;
        return $this;
    }
    /**
     * Get Diff value
     * @return int|null
     */
    public function getDiff()
    {
        return $this->Diff;
    }
    /**
     * Set Diff value
     * @param int $diff
     * @return \StructType\OTRS_PendingTime
     */
    public function setDiff($diff = null)
    {
        // validation for constraint: int
        if (!is_null($diff) && !is_numeric($diff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($diff)), __LINE__);
        }
        $this->Diff = $diff;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTRS_PendingTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
