<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTRS_Article StructType
 * @subpackage Structs
 */
class OTRS_Article extends AbstractStructBase
{
    /**
     * The IsVisibleForCustomer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IsVisibleForCustomer;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Subject;
    /**
     * The Body
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Body;
    /**
     * The Charset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Charset;
    /**
     * The MimeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MimeType;
    /**
     * The CommunicationChannelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CommunicationChannelID;
    /**
     * The CommunicationChannel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommunicationChannel;
    /**
     * The SenderTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SenderTypeID;
    /**
     * The SenderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderType;
    /**
     * The From
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From;
    /**
     * The ContentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ContentType;
    /**
     * The HistoryType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HistoryType;
    /**
     * The HistoryComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HistoryComment;
    /**
     * The AutoResponseType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoResponseType;
    /**
     * The TimeUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TimeUnit;
    /**
     * The NoAgentNotify
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NoAgentNotify;
    /**
     * The ForceNotificationToUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $ForceNotificationToUserID;
    /**
     * The ExcludeNotificationToUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $ExcludeNotificationToUserID;
    /**
     * The ExcludeMuteNotificationToUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $ExcludeMuteNotificationToUserID;
    /**
     * Constructor method for OTRS_Article
     * @uses OTRS_Article::setIsVisibleForCustomer()
     * @uses OTRS_Article::setSubject()
     * @uses OTRS_Article::setBody()
     * @uses OTRS_Article::setCharset()
     * @uses OTRS_Article::setMimeType()
     * @uses OTRS_Article::setCommunicationChannelID()
     * @uses OTRS_Article::setCommunicationChannel()
     * @uses OTRS_Article::setSenderTypeID()
     * @uses OTRS_Article::setSenderType()
     * @uses OTRS_Article::setFrom()
     * @uses OTRS_Article::setContentType()
     * @uses OTRS_Article::setHistoryType()
     * @uses OTRS_Article::setHistoryComment()
     * @uses OTRS_Article::setAutoResponseType()
     * @uses OTRS_Article::setTimeUnit()
     * @uses OTRS_Article::setNoAgentNotify()
     * @uses OTRS_Article::setForceNotificationToUserID()
     * @uses OTRS_Article::setExcludeNotificationToUserID()
     * @uses OTRS_Article::setExcludeMuteNotificationToUserID()
     * @param string $isVisibleForCustomer
     * @param string $subject
     * @param string $body
     * @param string $charset
     * @param string $mimeType
     * @param int $communicationChannelID
     * @param string $communicationChannel
     * @param int $senderTypeID
     * @param string $senderType
     * @param string $from
     * @param string $contentType
     * @param string $historyType
     * @param string $historyComment
     * @param string $autoResponseType
     * @param float $timeUnit
     * @param int $noAgentNotify
     * @param int[] $forceNotificationToUserID
     * @param int[] $excludeNotificationToUserID
     * @param int[] $excludeMuteNotificationToUserID
     */
    public function __construct($isVisibleForCustomer = null, $subject = null, $body = null, $charset = null, $mimeType = null, $communicationChannelID = null, $communicationChannel = null, $senderTypeID = null, $senderType = null, $from = null, $contentType = null, $historyType = null, $historyComment = null, $autoResponseType = null, $timeUnit = null, $noAgentNotify = null, array $forceNotificationToUserID = array(), array $excludeNotificationToUserID = array(), array $excludeMuteNotificationToUserID = array())
    {
        $this
            ->setIsVisibleForCustomer($isVisibleForCustomer)
            ->setSubject($subject)
            ->setBody($body)
            ->setCharset($charset)
            ->setMimeType($mimeType)
            ->setCommunicationChannelID($communicationChannelID)
            ->setCommunicationChannel($communicationChannel)
            ->setSenderTypeID($senderTypeID)
            ->setSenderType($senderType)
            ->setFrom($from)
            ->setContentType($contentType)
            ->setHistoryType($historyType)
            ->setHistoryComment($historyComment)
            ->setAutoResponseType($autoResponseType)
            ->setTimeUnit($timeUnit)
            ->setNoAgentNotify($noAgentNotify)
            ->setForceNotificationToUserID($forceNotificationToUserID)
            ->setExcludeNotificationToUserID($excludeNotificationToUserID)
            ->setExcludeMuteNotificationToUserID($excludeMuteNotificationToUserID);
    }
    /**
     * Get IsVisibleForCustomer value
     * @return string
     */
    public function getIsVisibleForCustomer()
    {
        return $this->IsVisibleForCustomer;
    }
    /**
     * Set IsVisibleForCustomer value
     * @param string $isVisibleForCustomer
     * @return \StructType\OTRS_Article
     */
    public function setIsVisibleForCustomer($isVisibleForCustomer = null)
    {
        // validation for constraint: string
        if (!is_null($isVisibleForCustomer) && !is_string($isVisibleForCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isVisibleForCustomer)), __LINE__);
        }
        $this->IsVisibleForCustomer = $isVisibleForCustomer;
        return $this;
    }
    /**
     * Get Subject value
     * @return string
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \StructType\OTRS_Article
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Body value
     * @return string
     */
    public function getBody()
    {
        return $this->Body;
    }
    /**
     * Set Body value
     * @param string $body
     * @return \StructType\OTRS_Article
     */
    public function setBody($body = null)
    {
        // validation for constraint: string
        if (!is_null($body) && !is_string($body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($body)), __LINE__);
        }
        $this->Body = $body;
        return $this;
    }
    /**
     * Get Charset value
     * @return string
     */
    public function getCharset()
    {
        return $this->Charset;
    }
    /**
     * Set Charset value
     * @param string $charset
     * @return \StructType\OTRS_Article
     */
    public function setCharset($charset = null)
    {
        // validation for constraint: string
        if (!is_null($charset) && !is_string($charset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charset)), __LINE__);
        }
        $this->Charset = $charset;
        return $this;
    }
    /**
     * Get MimeType value
     * @return string
     */
    public function getMimeType()
    {
        return $this->MimeType;
    }
    /**
     * Set MimeType value
     * @param string $mimeType
     * @return \StructType\OTRS_Article
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mimeType)), __LINE__);
        }
        $this->MimeType = $mimeType;
        return $this;
    }
    /**
     * Get CommunicationChannelID value
     * @return int|null
     */
    public function getCommunicationChannelID()
    {
        return $this->CommunicationChannelID;
    }
    /**
     * Set CommunicationChannelID value
     * @param int $communicationChannelID
     * @return \StructType\OTRS_Article
     */
    public function setCommunicationChannelID($communicationChannelID = null)
    {
        // validation for constraint: int
        if (!is_null($communicationChannelID) && !is_numeric($communicationChannelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($communicationChannelID)), __LINE__);
        }
        $this->CommunicationChannelID = $communicationChannelID;
        return $this;
    }
    /**
     * Get CommunicationChannel value
     * @return string|null
     */
    public function getCommunicationChannel()
    {
        return $this->CommunicationChannel;
    }
    /**
     * Set CommunicationChannel value
     * @uses \EnumType\OTRS_MIME_Communication_Channel::valueIsValid()
     * @uses \EnumType\OTRS_MIME_Communication_Channel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $communicationChannel
     * @return \StructType\OTRS_Article
     */
    public function setCommunicationChannel($communicationChannel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OTRS_MIME_Communication_Channel::valueIsValid($communicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $communicationChannel, implode(', ', \EnumType\OTRS_MIME_Communication_Channel::getValidValues())), __LINE__);
        }
        $this->CommunicationChannel = $communicationChannel;
        return $this;
    }
    /**
     * Get SenderTypeID value
     * @return int|null
     */
    public function getSenderTypeID()
    {
        return $this->SenderTypeID;
    }
    /**
     * Set SenderTypeID value
     * @param int $senderTypeID
     * @return \StructType\OTRS_Article
     */
    public function setSenderTypeID($senderTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($senderTypeID) && !is_numeric($senderTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($senderTypeID)), __LINE__);
        }
        $this->SenderTypeID = $senderTypeID;
        return $this;
    }
    /**
     * Get SenderType value
     * @return string|null
     */
    public function getSenderType()
    {
        return $this->SenderType;
    }
    /**
     * Set SenderType value
     * @param string $senderType
     * @return \StructType\OTRS_Article
     */
    public function setSenderType($senderType = null)
    {
        // validation for constraint: string
        if (!is_null($senderType) && !is_string($senderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderType)), __LINE__);
        }
        $this->SenderType = $senderType;
        return $this;
    }
    /**
     * Get From value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \StructType\OTRS_Article
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get ContentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \StructType\OTRS_Article
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get HistoryType value
     * @return string|null
     */
    public function getHistoryType()
    {
        return $this->HistoryType;
    }
    /**
     * Set HistoryType value
     * @param string $historyType
     * @return \StructType\OTRS_Article
     */
    public function setHistoryType($historyType = null)
    {
        // validation for constraint: string
        if (!is_null($historyType) && !is_string($historyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($historyType)), __LINE__);
        }
        $this->HistoryType = $historyType;
        return $this;
    }
    /**
     * Get HistoryComment value
     * @return string|null
     */
    public function getHistoryComment()
    {
        return $this->HistoryComment;
    }
    /**
     * Set HistoryComment value
     * @param string $historyComment
     * @return \StructType\OTRS_Article
     */
    public function setHistoryComment($historyComment = null)
    {
        // validation for constraint: string
        if (!is_null($historyComment) && !is_string($historyComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($historyComment)), __LINE__);
        }
        $this->HistoryComment = $historyComment;
        return $this;
    }
    /**
     * Get AutoResponseType value
     * @return string|null
     */
    public function getAutoResponseType()
    {
        return $this->AutoResponseType;
    }
    /**
     * Set AutoResponseType value
     * @param string $autoResponseType
     * @return \StructType\OTRS_Article
     */
    public function setAutoResponseType($autoResponseType = null)
    {
        // validation for constraint: string
        if (!is_null($autoResponseType) && !is_string($autoResponseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoResponseType)), __LINE__);
        }
        $this->AutoResponseType = $autoResponseType;
        return $this;
    }
    /**
     * Get TimeUnit value
     * @return float|null
     */
    public function getTimeUnit()
    {
        return $this->TimeUnit;
    }
    /**
     * Set TimeUnit value
     * @param float $timeUnit
     * @return \StructType\OTRS_Article
     */
    public function setTimeUnit($timeUnit = null)
    {
        $this->TimeUnit = $timeUnit;
        return $this;
    }
    /**
     * Get NoAgentNotify value
     * @return int|null
     */
    public function getNoAgentNotify()
    {
        return $this->NoAgentNotify;
    }
    /**
     * Set NoAgentNotify value
     * @param int $noAgentNotify
     * @return \StructType\OTRS_Article
     */
    public function setNoAgentNotify($noAgentNotify = null)
    {
        // validation for constraint: int
        if (!is_null($noAgentNotify) && !is_numeric($noAgentNotify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($noAgentNotify)), __LINE__);
        }
        $this->NoAgentNotify = $noAgentNotify;
        return $this;
    }
    /**
     * Get ForceNotificationToUserID value
     * @return int[]|null
     */
    public function getForceNotificationToUserID()
    {
        return $this->ForceNotificationToUserID;
    }
    /**
     * Set ForceNotificationToUserID value
     * @throws \InvalidArgumentException
     * @param int[] $forceNotificationToUserID
     * @return \StructType\OTRS_Article
     */
    public function setForceNotificationToUserID(array $forceNotificationToUserID = array())
    {
        foreach ($forceNotificationToUserID as $oTRS_ArticleForceNotificationToUserIDItem) {
            // validation for constraint: itemType
            if (!is_numeric($oTRS_ArticleForceNotificationToUserIDItem)) {
                throw new \InvalidArgumentException(sprintf('The ForceNotificationToUserID property can only contain items of positiveInteger, "%s" given', is_object($oTRS_ArticleForceNotificationToUserIDItem) ? get_class($oTRS_ArticleForceNotificationToUserIDItem) : gettype($oTRS_ArticleForceNotificationToUserIDItem)), __LINE__);
            }
        }
        $this->ForceNotificationToUserID = $forceNotificationToUserID;
        return $this;
    }
    /**
     * Add item to ForceNotificationToUserID value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\OTRS_Article
     */
    public function addToForceNotificationToUserID($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The ForceNotificationToUserID property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ForceNotificationToUserID[] = $item;
        return $this;
    }
    /**
     * Get ExcludeNotificationToUserID value
     * @return int[]|null
     */
    public function getExcludeNotificationToUserID()
    {
        return $this->ExcludeNotificationToUserID;
    }
    /**
     * Set ExcludeNotificationToUserID value
     * @throws \InvalidArgumentException
     * @param int[] $excludeNotificationToUserID
     * @return \StructType\OTRS_Article
     */
    public function setExcludeNotificationToUserID(array $excludeNotificationToUserID = array())
    {
        foreach ($excludeNotificationToUserID as $oTRS_ArticleExcludeNotificationToUserIDItem) {
            // validation for constraint: itemType
            if (!is_numeric($oTRS_ArticleExcludeNotificationToUserIDItem)) {
                throw new \InvalidArgumentException(sprintf('The ExcludeNotificationToUserID property can only contain items of positiveInteger, "%s" given', is_object($oTRS_ArticleExcludeNotificationToUserIDItem) ? get_class($oTRS_ArticleExcludeNotificationToUserIDItem) : gettype($oTRS_ArticleExcludeNotificationToUserIDItem)), __LINE__);
            }
        }
        $this->ExcludeNotificationToUserID = $excludeNotificationToUserID;
        return $this;
    }
    /**
     * Add item to ExcludeNotificationToUserID value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\OTRS_Article
     */
    public function addToExcludeNotificationToUserID($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The ExcludeNotificationToUserID property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExcludeNotificationToUserID[] = $item;
        return $this;
    }
    /**
     * Get ExcludeMuteNotificationToUserID value
     * @return int[]|null
     */
    public function getExcludeMuteNotificationToUserID()
    {
        return $this->ExcludeMuteNotificationToUserID;
    }
    /**
     * Set ExcludeMuteNotificationToUserID value
     * @throws \InvalidArgumentException
     * @param int[] $excludeMuteNotificationToUserID
     * @return \StructType\OTRS_Article
     */
    public function setExcludeMuteNotificationToUserID(array $excludeMuteNotificationToUserID = array())
    {
        foreach ($excludeMuteNotificationToUserID as $oTRS_ArticleExcludeMuteNotificationToUserIDItem) {
            // validation for constraint: itemType
            if (!is_numeric($oTRS_ArticleExcludeMuteNotificationToUserIDItem)) {
                throw new \InvalidArgumentException(sprintf('The ExcludeMuteNotificationToUserID property can only contain items of positiveInteger, "%s" given', is_object($oTRS_ArticleExcludeMuteNotificationToUserIDItem) ? get_class($oTRS_ArticleExcludeMuteNotificationToUserIDItem) : gettype($oTRS_ArticleExcludeMuteNotificationToUserIDItem)), __LINE__);
            }
        }
        $this->ExcludeMuteNotificationToUserID = $excludeMuteNotificationToUserID;
        return $this;
    }
    /**
     * Add item to ExcludeMuteNotificationToUserID value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\OTRS_Article
     */
    public function addToExcludeMuteNotificationToUserID($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The ExcludeMuteNotificationToUserID property can only contain items of positiveInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExcludeMuteNotificationToUserID[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTRS_Article
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
