<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ticket ServiceType
 * @subpackage Services
 */
class Ticket extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TicketCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TicketCreate $parameters
     * @return \StructType\TicketCreateResponse|bool
     */
    public function TicketCreate(\StructType\TicketCreate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TicketCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TicketUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TicketUpdate $parameters
     * @return \StructType\TicketUpdateResponse|bool
     */
    public function TicketUpdate(\StructType\TicketUpdate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TicketUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TicketGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TicketGet $parameters
     * @return \StructType\TicketGetResponse|bool
     */
    public function TicketGet(\StructType\TicketGet $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TicketGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TicketSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TicketSearch $parameters
     * @return \StructType\TicketSearchResponse|bool
     */
    public function TicketSearch(\StructType\TicketSearch $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TicketSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TicketHistoryGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TicketHistoryGet $parameters
     * @return \StructType\TicketHistoryGetResponse|bool
     */
    public function TicketHistoryGet(\StructType\TicketHistoryGet $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TicketHistoryGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TicketCreateResponse|\StructType\TicketGetResponse|\StructType\TicketHistoryGetResponse|\StructType\TicketSearchResponse|\StructType\TicketUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
