<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorStatement StructType
 * @subpackage Structs
 */
class VendorStatement extends AbstractStructBase
{
    /**
     * The accNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accNo;
    /**
     * The accBal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $accBal;
    /**
     * The availCredit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $availCredit;
    /**
     * The lineItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VendorStatementLineItem[]
     */
    public $lineItem;
    /**
     * Constructor method for VendorStatement
     * @uses VendorStatement::setAccNo()
     * @uses VendorStatement::setAccBal()
     * @uses VendorStatement::setAvailCredit()
     * @uses VendorStatement::setLineItem()
     * @param string $accNo
     * @param \StructType\Currency $accBal
     * @param \StructType\Currency $availCredit
     * @param \StructType\VendorStatementLineItem[] $lineItem
     */
    public function __construct($accNo = null, \StructType\Currency $accBal = null, \StructType\Currency $availCredit = null, array $lineItem = array())
    {
        $this
            ->setAccNo($accNo)
            ->setAccBal($accBal)
            ->setAvailCredit($availCredit)
            ->setLineItem($lineItem);
    }
    /**
     * Get accNo value
     * @return string|null
     */
    public function getAccNo()
    {
        return $this->accNo;
    }
    /**
     * Set accNo value
     * @param string $accNo
     * @return \StructType\VendorStatement
     */
    public function setAccNo($accNo = null)
    {
        // validation for constraint: string
        if (!is_null($accNo) && !is_string($accNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accNo)), __LINE__);
        }
        $this->accNo = $accNo;
        return $this;
    }
    /**
     * Get accBal value
     * @return \StructType\Currency|null
     */
    public function getAccBal()
    {
        return $this->accBal;
    }
    /**
     * Set accBal value
     * @param \StructType\Currency $accBal
     * @return \StructType\VendorStatement
     */
    public function setAccBal(\StructType\Currency $accBal = null)
    {
        $this->accBal = $accBal;
        return $this;
    }
    /**
     * Get availCredit value
     * @return \StructType\Currency|null
     */
    public function getAvailCredit()
    {
        return $this->availCredit;
    }
    /**
     * Set availCredit value
     * @param \StructType\Currency $availCredit
     * @return \StructType\VendorStatement
     */
    public function setAvailCredit(\StructType\Currency $availCredit = null)
    {
        $this->availCredit = $availCredit;
        return $this;
    }
    /**
     * Get lineItem value
     * @return \StructType\VendorStatementLineItem[]|null
     */
    public function getLineItem()
    {
        return $this->lineItem;
    }
    /**
     * Set lineItem value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorStatementLineItem[] $lineItem
     * @return \StructType\VendorStatement
     */
    public function setLineItem(array $lineItem = array())
    {
        foreach ($lineItem as $vendorStatementLineItemItem) {
            // validation for constraint: itemType
            if (!$vendorStatementLineItemItem instanceof \StructType\VendorStatementLineItem) {
                throw new \InvalidArgumentException(sprintf('The lineItem property can only contain items of \StructType\VendorStatementLineItem, "%s" given', is_object($vendorStatementLineItemItem) ? get_class($vendorStatementLineItemItem) : gettype($vendorStatementLineItemItem)), __LINE__);
            }
        }
        $this->lineItem = $lineItem;
        return $this;
    }
    /**
     * Add item to lineItem value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorStatementLineItem $item
     * @return \StructType\VendorStatement
     */
    public function addToLineItem(\StructType\VendorStatementLineItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorStatementLineItem) {
            throw new \InvalidArgumentException(sprintf('The lineItem property can only contain items of \StructType\VendorStatementLineItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->lineItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorStatement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
