<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VAT StructType
 * @subpackage Structs
 */
class VAT extends Tax
{
    /**
     * The rate
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $rate;
    /**
     * Constructor method for VAT
     * @uses VAT::setRate()
     * @param float $rate
     */
    public function __construct($rate = null)
    {
        $this
            ->setRate($rate);
    }
    /**
     * Get rate value
     * @return float
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\VAT
     */
    public function setRate($rate = null)
    {
        $this->rate = $rate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VAT
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
