<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tx StructType
 * @subpackage Structs
 */
abstract class Tx extends AbstractStructBase
{
    /**
     * The amt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $amt;
    /**
     * The tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tax[]
     */
    public $tax;
    /**
     * The receiptNo
     * @var string
     */
    public $receiptNo;
    /**
     * Constructor method for Tx
     * @uses Tx::setAmt()
     * @uses Tx::setTax()
     * @uses Tx::setReceiptNo()
     * @param \StructType\Currency $amt
     * @param \StructType\Tax[] $tax
     * @param string $receiptNo
     */
    public function __construct(\StructType\Currency $amt = null, array $tax = array(), $receiptNo = null)
    {
        $this
            ->setAmt($amt)
            ->setTax($tax)
            ->setReceiptNo($receiptNo);
    }
    /**
     * Get amt value
     * @return \StructType\Currency|null
     */
    public function getAmt()
    {
        return $this->amt;
    }
    /**
     * Set amt value
     * @param \StructType\Currency $amt
     * @return \StructType\Tx
     */
    public function setAmt(\StructType\Currency $amt = null)
    {
        $this->amt = $amt;
        return $this;
    }
    /**
     * Get tax value
     * @return \StructType\Tax[]|null
     */
    public function getTax()
    {
        return $this->tax;
    }
    /**
     * Set tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax[] $tax
     * @return \StructType\Tx
     */
    public function setTax(array $tax = array())
    {
        foreach ($tax as $txTaxItem) {
            // validation for constraint: itemType
            if (!$txTaxItem instanceof \StructType\Tax) {
                throw new \InvalidArgumentException(sprintf('The tax property can only contain items of \StructType\Tax, "%s" given', is_object($txTaxItem) ? get_class($txTaxItem) : gettype($txTaxItem)), __LINE__);
            }
        }
        $this->tax = $tax;
        return $this;
    }
    /**
     * Add item to tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax $item
     * @return \StructType\Tx
     */
    public function addToTax(\StructType\Tax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax) {
            throw new \InvalidArgumentException(sprintf('The tax property can only contain items of \StructType\Tax, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->tax[] = $item;
        return $this;
    }
    /**
     * Get receiptNo value
     * @return string|null
     */
    public function getReceiptNo()
    {
        return $this->receiptNo;
    }
    /**
     * Set receiptNo value
     * @param string $receiptNo
     * @return \StructType\Tx
     */
    public function setReceiptNo($receiptNo = null)
    {
        // validation for constraint: string
        if (!is_null($receiptNo) && !is_string($receiptNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiptNo)), __LINE__);
        }
        $this->receiptNo = $receiptNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tx
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
