<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalBatchResp StructType
 * @subpackage Structs
 */
class TotalBatchResp extends BaseResp
{
    /**
     * The totalBatch
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Batch[]
     */
    public $totalBatch;
    /**
     * Constructor method for TotalBatchResp
     * @uses TotalBatchResp::setTotalBatch()
     * @param \StructType\Batch[] $totalBatch
     */
    public function __construct(array $totalBatch = array())
    {
        $this
            ->setTotalBatch($totalBatch);
    }
    /**
     * Get totalBatch value
     * @return \StructType\Batch[]|null
     */
    public function getTotalBatch()
    {
        return $this->totalBatch;
    }
    /**
     * Set totalBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\Batch[] $totalBatch
     * @return \StructType\TotalBatchResp
     */
    public function setTotalBatch(array $totalBatch = array())
    {
        foreach ($totalBatch as $totalBatchRespTotalBatchItem) {
            // validation for constraint: itemType
            if (!$totalBatchRespTotalBatchItem instanceof \StructType\Batch) {
                throw new \InvalidArgumentException(sprintf('The totalBatch property can only contain items of \StructType\Batch, "%s" given', is_object($totalBatchRespTotalBatchItem) ? get_class($totalBatchRespTotalBatchItem) : gettype($totalBatchRespTotalBatchItem)), __LINE__);
            }
        }
        $this->totalBatch = $totalBatch;
        return $this;
    }
    /**
     * Add item to totalBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\Batch $item
     * @return \StructType\TotalBatchResp
     */
    public function addToTotalBatch(\StructType\Batch $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Batch) {
            throw new \InvalidArgumentException(sprintf('The totalBatch property can only contain items of \StructType\Batch, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->totalBatch[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TotalBatchResp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
