<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Step StructType
 * @subpackage Structs
 */
class Step extends AbstractStructBase
{
    /**
     * The units
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Units
     */
    public $units;
    /**
     * The rate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $rate;
    /**
     * Constructor method for Step
     * @uses Step::setUnits()
     * @uses Step::setRate()
     * @param \StructType\Units $units
     * @param \StructType\Currency $rate
     */
    public function __construct(\StructType\Units $units = null, \StructType\Currency $rate = null)
    {
        $this
            ->setUnits($units)
            ->setRate($rate);
    }
    /**
     * Get units value
     * @return \StructType\Units|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\Units $units
     * @return \StructType\Step
     */
    public function setUnits(\StructType\Units $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get rate value
     * @return \StructType\Currency|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param \StructType\Currency $rate
     * @return \StructType\Step
     */
    public function setRate(\StructType\Currency $rate = null)
    {
        $this->rate = $rate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Step
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
