<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShiftBatch StructType
 * @subpackage Structs
 */
class ShiftBatch extends Batch
{
    /**
     * The seqNo
     * @var string
     */
    public $seqNo;
    /**
     * Constructor method for ShiftBatch
     * @uses ShiftBatch::setSeqNo()
     * @param string $seqNo
     */
    public function __construct($seqNo = null)
    {
        $this
            ->setSeqNo($seqNo);
    }
    /**
     * Get seqNo value
     * @return string|null
     */
    public function getSeqNo()
    {
        return $this->seqNo;
    }
    /**
     * Set seqNo value
     * @param string $seqNo
     * @return \StructType\ShiftBatch
     */
    public function setSeqNo($seqNo = null)
    {
        // validation for constraint: string
        if (!is_null($seqNo) && !is_string($seqNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seqNo)), __LINE__);
        }
        $this->seqNo = $seqNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShiftBatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
