<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesStartBatch StructType
 * @subpackage Structs
 */
class SalesStartBatch extends StartBatch
{
    /**
     * The shiftStartBatch
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ShiftStartBatch[]
     */
    public $shiftStartBatch;
    /**
     * The seqNo
     * @var string
     */
    public $seqNo;
    /**
     * Constructor method for SalesStartBatch
     * @uses SalesStartBatch::setShiftStartBatch()
     * @uses SalesStartBatch::setSeqNo()
     * @param \StructType\ShiftStartBatch[] $shiftStartBatch
     * @param string $seqNo
     */
    public function __construct(array $shiftStartBatch = array(), $seqNo = null)
    {
        $this
            ->setShiftStartBatch($shiftStartBatch)
            ->setSeqNo($seqNo);
    }
    /**
     * Get shiftStartBatch value
     * @return \StructType\ShiftStartBatch[]|null
     */
    public function getShiftStartBatch()
    {
        return $this->shiftStartBatch;
    }
    /**
     * Set shiftStartBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\ShiftStartBatch[] $shiftStartBatch
     * @return \StructType\SalesStartBatch
     */
    public function setShiftStartBatch(array $shiftStartBatch = array())
    {
        foreach ($shiftStartBatch as $salesStartBatchShiftStartBatchItem) {
            // validation for constraint: itemType
            if (!$salesStartBatchShiftStartBatchItem instanceof \StructType\ShiftStartBatch) {
                throw new \InvalidArgumentException(sprintf('The shiftStartBatch property can only contain items of \StructType\ShiftStartBatch, "%s" given', is_object($salesStartBatchShiftStartBatchItem) ? get_class($salesStartBatchShiftStartBatchItem) : gettype($salesStartBatchShiftStartBatchItem)), __LINE__);
            }
        }
        $this->shiftStartBatch = $shiftStartBatch;
        return $this;
    }
    /**
     * Add item to shiftStartBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\ShiftStartBatch $item
     * @return \StructType\SalesStartBatch
     */
    public function addToShiftStartBatch(\StructType\ShiftStartBatch $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShiftStartBatch) {
            throw new \InvalidArgumentException(sprintf('The shiftStartBatch property can only contain items of \StructType\ShiftStartBatch, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->shiftStartBatch[] = $item;
        return $this;
    }
    /**
     * Get seqNo value
     * @return string|null
     */
    public function getSeqNo()
    {
        return $this->seqNo;
    }
    /**
     * Set seqNo value
     * @param string $seqNo
     * @return \StructType\SalesStartBatch
     */
    public function setSeqNo($seqNo = null)
    {
        // validation for constraint: string
        if (!is_null($seqNo) && !is_string($seqNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seqNo)), __LINE__);
        }
        $this->seqNo = $seqNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SalesStartBatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
