<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReprintDepositResp StructType
 * @subpackage Structs
 */
class ReprintDepositResp extends BaseResp
{
    /**
     * The reprint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DepositResp[]
     */
    public $reprint;
    /**
     * Constructor method for ReprintDepositResp
     * @uses ReprintDepositResp::setReprint()
     * @param \StructType\DepositResp[] $reprint
     */
    public function __construct(array $reprint = array())
    {
        $this
            ->setReprint($reprint);
    }
    /**
     * Get reprint value
     * @return \StructType\DepositResp[]|null
     */
    public function getReprint()
    {
        return $this->reprint;
    }
    /**
     * Set reprint value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositResp[] $reprint
     * @return \StructType\ReprintDepositResp
     */
    public function setReprint(array $reprint = array())
    {
        foreach ($reprint as $reprintDepositRespReprintItem) {
            // validation for constraint: itemType
            if (!$reprintDepositRespReprintItem instanceof \StructType\DepositResp) {
                throw new \InvalidArgumentException(sprintf('The reprint property can only contain items of \StructType\DepositResp, "%s" given', is_object($reprintDepositRespReprintItem) ? get_class($reprintDepositRespReprintItem) : gettype($reprintDepositRespReprintItem)), __LINE__);
            }
        }
        $this->reprint = $reprint;
        return $this;
    }
    /**
     * Add item to reprint value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositResp $item
     * @return \StructType\ReprintDepositResp
     */
    public function addToReprint(\StructType\DepositResp $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DepositResp) {
            throw new \InvalidArgumentException(sprintf('The reprint property can only contain items of \StructType\DepositResp, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->reprint[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReprintDepositResp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
