<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayTypeTotal StructType
 * @subpackage Structs
 */
abstract class PayTypeTotal extends AbstractStructBase
{
    /**
     * The desc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $desc;
    /**
     * The amt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $amt;
    /**
     * Constructor method for PayTypeTotal
     * @uses PayTypeTotal::setDesc()
     * @uses PayTypeTotal::setAmt()
     * @param string $desc
     * @param \StructType\Currency $amt
     */
    public function __construct($desc = null, \StructType\Currency $amt = null)
    {
        $this
            ->setDesc($desc)
            ->setAmt($amt);
    }
    /**
     * Get desc value
     * @return string|null
     */
    public function getDesc()
    {
        return $this->desc;
    }
    /**
     * Set desc value
     * @param string $desc
     * @return \StructType\PayTypeTotal
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($desc)), __LINE__);
        }
        $this->desc = $desc;
        return $this;
    }
    /**
     * Get amt value
     * @return \StructType\Currency|null
     */
    public function getAmt()
    {
        return $this->amt;
    }
    /**
     * Set amt value
     * @param \StructType\Currency $amt
     * @return \StructType\PayTypeTotal
     */
    public function setAmt(\StructType\Currency $amt = null)
    {
        $this->amt = $amt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PayTypeTotal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
