<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayAccount StructType
 * @subpackage Structs
 */
class PayAccount extends AbstractStructBase
{
    /**
     * The desc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $desc;
    /**
     * The idMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IDMethod
     */
    public $idMethod;
    /**
     * Constructor method for PayAccount
     * @uses PayAccount::setDesc()
     * @uses PayAccount::setIdMethod()
     * @param string $desc
     * @param \StructType\IDMethod $idMethod
     */
    public function __construct($desc = null, \StructType\IDMethod $idMethod = null)
    {
        $this
            ->setDesc($desc)
            ->setIdMethod($idMethod);
    }
    /**
     * Get desc value
     * @return string|null
     */
    public function getDesc()
    {
        return $this->desc;
    }
    /**
     * Set desc value
     * @param string $desc
     * @return \StructType\PayAccount
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($desc)), __LINE__);
        }
        $this->desc = $desc;
        return $this;
    }
    /**
     * Get idMethod value
     * @return \StructType\IDMethod|null
     */
    public function getIdMethod()
    {
        return $this->idMethod;
    }
    /**
     * Set idMethod value
     * @param \StructType\IDMethod $idMethod
     * @return \StructType\PayAccount
     */
    public function setIdMethod(\StructType\IDMethod $idMethod = null)
    {
        $this->idMethod = $idMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PayAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
