<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayAccTx StructType
 * @subpackage Structs
 */
class PayAccTx extends Tx
{
    /**
     * The accDesc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accDesc;
    /**
     * The accNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accNo;
    /**
     * The tariff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Tariff
     */
    public $tariff;
    /**
     * Constructor method for PayAccTx
     * @uses PayAccTx::setAccDesc()
     * @uses PayAccTx::setAccNo()
     * @uses PayAccTx::setTariff()
     * @param string $accDesc
     * @param string $accNo
     * @param \StructType\Tariff $tariff
     */
    public function __construct($accDesc = null, $accNo = null, \StructType\Tariff $tariff = null)
    {
        $this
            ->setAccDesc($accDesc)
            ->setAccNo($accNo)
            ->setTariff($tariff);
    }
    /**
     * Get accDesc value
     * @return string|null
     */
    public function getAccDesc()
    {
        return $this->accDesc;
    }
    /**
     * Set accDesc value
     * @param string $accDesc
     * @return \StructType\PayAccTx
     */
    public function setAccDesc($accDesc = null)
    {
        // validation for constraint: string
        if (!is_null($accDesc) && !is_string($accDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accDesc)), __LINE__);
        }
        $this->accDesc = $accDesc;
        return $this;
    }
    /**
     * Get accNo value
     * @return string|null
     */
    public function getAccNo()
    {
        return $this->accNo;
    }
    /**
     * Set accNo value
     * @param string $accNo
     * @return \StructType\PayAccTx
     */
    public function setAccNo($accNo = null)
    {
        // validation for constraint: string
        if (!is_null($accNo) && !is_string($accNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accNo)), __LINE__);
        }
        $this->accNo = $accNo;
        return $this;
    }
    /**
     * Get tariff value
     * @return \StructType\Tariff|null
     */
    public function getTariff()
    {
        return $this->tariff;
    }
    /**
     * Set tariff value
     * @param \StructType\Tariff $tariff
     * @return \StructType\PayAccTx
     */
    public function setTariff(\StructType\Tariff $tariff = null)
    {
        $this->tariff = $tariff;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PayAccTx
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
