<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayAccReq StructType
 * @subpackage Structs
 */
class PayAccReq extends BaseReq
{
    /**
     * The vendingServerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $vendingServerId;
    /**
     * The reqAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $reqAmt;
    /**
     * The payType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PayType
     */
    public $payType;
    /**
     * The payAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PayAccount
     */
    public $payAccount;
    /**
     * Constructor method for PayAccReq
     * @uses PayAccReq::setVendingServerId()
     * @uses PayAccReq::setReqAmt()
     * @uses PayAccReq::setPayType()
     * @uses PayAccReq::setPayAccount()
     * @param int $vendingServerId
     * @param \StructType\Currency $reqAmt
     * @param \StructType\PayType $payType
     * @param \StructType\PayAccount $payAccount
     */
    public function __construct($vendingServerId = null, \StructType\Currency $reqAmt = null, \StructType\PayType $payType = null, \StructType\PayAccount $payAccount = null)
    {
        $this
            ->setVendingServerId($vendingServerId)
            ->setReqAmt($reqAmt)
            ->setPayType($payType)
            ->setPayAccount($payAccount);
    }
    /**
     * Get vendingServerId value
     * @return int
     */
    public function getVendingServerId()
    {
        return $this->vendingServerId;
    }
    /**
     * Set vendingServerId value
     * @param int $vendingServerId
     * @return \StructType\PayAccReq
     */
    public function setVendingServerId($vendingServerId = null)
    {
        // validation for constraint: int
        if (!is_null($vendingServerId) && !is_numeric($vendingServerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vendingServerId)), __LINE__);
        }
        $this->vendingServerId = $vendingServerId;
        return $this;
    }
    /**
     * Get reqAmt value
     * @return \StructType\Currency|null
     */
    public function getReqAmt()
    {
        return $this->reqAmt;
    }
    /**
     * Set reqAmt value
     * @param \StructType\Currency $reqAmt
     * @return \StructType\PayAccReq
     */
    public function setReqAmt(\StructType\Currency $reqAmt = null)
    {
        $this->reqAmt = $reqAmt;
        return $this;
    }
    /**
     * Get payType value
     * @return \StructType\PayType|null
     */
    public function getPayType()
    {
        return $this->payType;
    }
    /**
     * Set payType value
     * @param \StructType\PayType $payType
     * @return \StructType\PayAccReq
     */
    public function setPayType(\StructType\PayType $payType = null)
    {
        $this->payType = $payType;
        return $this;
    }
    /**
     * Get payAccount value
     * @return \StructType\PayAccount|null
     */
    public function getPayAccount()
    {
        return $this->payAccount;
    }
    /**
     * Set payAccount value
     * @param \StructType\PayAccount $payAccount
     * @return \StructType\PayAccReq
     */
    public function setPayAccount(\StructType\PayAccount $payAccount = null)
    {
        $this->payAccount = $payAccount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PayAccReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
