<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MsgID StructType
 * @subpackage Structs
 */
class MsgID extends AbstractStructBase
{
    /**
     * The dateTime
     * @var string
     */
    public $dateTime;
    /**
     * The uniqueNumber
     * @var int
     */
    public $uniqueNumber;
    /**
     * The sequenceNumber
     * @var string
     */
    public $sequenceNumber;
    /**
     * Constructor method for MsgID
     * @uses MsgID::setDateTime()
     * @uses MsgID::setUniqueNumber()
     * @uses MsgID::setSequenceNumber()
     * @param string $dateTime
     * @param int $uniqueNumber
     * @param string $sequenceNumber
     */
    public function __construct($dateTime = null, $uniqueNumber = null, $sequenceNumber = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setUniqueNumber($uniqueNumber)
            ->setSequenceNumber($sequenceNumber);
    }
    /**
     * Get dateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->dateTime;
    }
    /**
     * Set dateTime value
     * @param string $dateTime
     * @return \StructType\MsgID
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTime)), __LINE__);
        }
        $this->dateTime = $dateTime;
        return $this;
    }
    /**
     * Get uniqueNumber value
     * @return int|null
     */
    public function getUniqueNumber()
    {
        return $this->uniqueNumber;
    }
    /**
     * Set uniqueNumber value
     * @param int $uniqueNumber
     * @return \StructType\MsgID
     */
    public function setUniqueNumber($uniqueNumber = null)
    {
        // validation for constraint: int
        if (!is_null($uniqueNumber) && !is_numeric($uniqueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uniqueNumber)), __LINE__);
        }
        $this->uniqueNumber = $uniqueNumber;
        return $this;
    }
    /**
     * Get sequenceNumber value
     * @return string|null
     */
    public function getSequenceNumber()
    {
        return $this->sequenceNumber;
    }
    /**
     * Set sequenceNumber value
     * @param string $sequenceNumber
     * @return \StructType\MsgID
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sequenceNumber) && !is_string($sequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sequenceNumber)), __LINE__);
        }
        $this->sequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MsgID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
