<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterNumber StructType
 * @subpackage Structs
 */
class MeterNumber extends MeterIdentifier
{
    /**
     * The msno
     * @var string
     */
    public $msno;
    /**
     * Constructor method for MeterNumber
     * @uses MeterNumber::setMsno()
     * @param string $msno
     */
    public function __construct($msno = null)
    {
        $this
            ->setMsno($msno);
    }
    /**
     * Get msno value
     * @return string|null
     */
    public function getMsno()
    {
        return $this->msno;
    }
    /**
     * Set msno value
     * @param string $msno
     * @return \StructType\MeterNumber
     */
    public function setMsno($msno = null)
    {
        // validation for constraint: string
        if (!is_null($msno) && !is_string($msno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($msno)), __LINE__);
        }
        $this->msno = $msno;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeterNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
