<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KCTData StructType
 * @subpackage Structs
 */
class KCTData extends AbstractStructBase
{
    /**
     * The fromSGC
     * @var string
     */
    public $fromSGC;
    /**
     * The fromKRN
     * @var string
     */
    public $fromKRN;
    /**
     * The fromTI
     * @var string
     */
    public $fromTI;
    /**
     * The toSGC
     * @var string
     */
    public $toSGC;
    /**
     * The toKRN
     * @var string
     */
    public $toKRN;
    /**
     * The toTI
     * @var string
     */
    public $toTI;
    /**
     * Constructor method for KCTData
     * @uses KCTData::setFromSGC()
     * @uses KCTData::setFromKRN()
     * @uses KCTData::setFromTI()
     * @uses KCTData::setToSGC()
     * @uses KCTData::setToKRN()
     * @uses KCTData::setToTI()
     * @param string $fromSGC
     * @param string $fromKRN
     * @param string $fromTI
     * @param string $toSGC
     * @param string $toKRN
     * @param string $toTI
     */
    public function __construct($fromSGC = null, $fromKRN = null, $fromTI = null, $toSGC = null, $toKRN = null, $toTI = null)
    {
        $this
            ->setFromSGC($fromSGC)
            ->setFromKRN($fromKRN)
            ->setFromTI($fromTI)
            ->setToSGC($toSGC)
            ->setToKRN($toKRN)
            ->setToTI($toTI);
    }
    /**
     * Get fromSGC value
     * @return string|null
     */
    public function getFromSGC()
    {
        return $this->fromSGC;
    }
    /**
     * Set fromSGC value
     * @param string $fromSGC
     * @return \StructType\KCTData
     */
    public function setFromSGC($fromSGC = null)
    {
        // validation for constraint: string
        if (!is_null($fromSGC) && !is_string($fromSGC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromSGC)), __LINE__);
        }
        $this->fromSGC = $fromSGC;
        return $this;
    }
    /**
     * Get fromKRN value
     * @return string|null
     */
    public function getFromKRN()
    {
        return $this->fromKRN;
    }
    /**
     * Set fromKRN value
     * @param string $fromKRN
     * @return \StructType\KCTData
     */
    public function setFromKRN($fromKRN = null)
    {
        // validation for constraint: string
        if (!is_null($fromKRN) && !is_string($fromKRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromKRN)), __LINE__);
        }
        $this->fromKRN = $fromKRN;
        return $this;
    }
    /**
     * Get fromTI value
     * @return string|null
     */
    public function getFromTI()
    {
        return $this->fromTI;
    }
    /**
     * Set fromTI value
     * @param string $fromTI
     * @return \StructType\KCTData
     */
    public function setFromTI($fromTI = null)
    {
        // validation for constraint: string
        if (!is_null($fromTI) && !is_string($fromTI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromTI)), __LINE__);
        }
        $this->fromTI = $fromTI;
        return $this;
    }
    /**
     * Get toSGC value
     * @return string|null
     */
    public function getToSGC()
    {
        return $this->toSGC;
    }
    /**
     * Set toSGC value
     * @param string $toSGC
     * @return \StructType\KCTData
     */
    public function setToSGC($toSGC = null)
    {
        // validation for constraint: string
        if (!is_null($toSGC) && !is_string($toSGC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toSGC)), __LINE__);
        }
        $this->toSGC = $toSGC;
        return $this;
    }
    /**
     * Get toKRN value
     * @return string|null
     */
    public function getToKRN()
    {
        return $this->toKRN;
    }
    /**
     * Set toKRN value
     * @param string $toKRN
     * @return \StructType\KCTData
     */
    public function setToKRN($toKRN = null)
    {
        // validation for constraint: string
        if (!is_null($toKRN) && !is_string($toKRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toKRN)), __LINE__);
        }
        $this->toKRN = $toKRN;
        return $this;
    }
    /**
     * Get toTI value
     * @return string|null
     */
    public function getToTI()
    {
        return $this->toTI;
    }
    /**
     * Set toTI value
     * @param string $toTI
     * @return \StructType\KCTData
     */
    public function setToTI($toTI = null)
    {
        // validation for constraint: string
        if (!is_null($toTI) && !is_string($toTI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toTI)), __LINE__);
        }
        $this->toTI = $toTI;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KCTData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
