<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositSlip StructType
 * @subpackage Structs
 */
class DepositSlip extends AbstractStructBase
{
    /**
     * The header
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $header;
    /**
     * The amt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $amt;
    /**
     * The beneficiary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Beneficiary
     */
    public $beneficiary;
    /**
     * The bankingRefNo
     * @var string
     */
    public $bankingRefNo;
    /**
     * Constructor method for DepositSlip
     * @uses DepositSlip::setHeader()
     * @uses DepositSlip::setAmt()
     * @uses DepositSlip::setBeneficiary()
     * @uses DepositSlip::setBankingRefNo()
     * @param string $header
     * @param \StructType\Currency $amt
     * @param \StructType\Beneficiary $beneficiary
     * @param string $bankingRefNo
     */
    public function __construct($header = null, \StructType\Currency $amt = null, \StructType\Beneficiary $beneficiary = null, $bankingRefNo = null)
    {
        $this
            ->setHeader($header)
            ->setAmt($amt)
            ->setBeneficiary($beneficiary)
            ->setBankingRefNo($bankingRefNo);
    }
    /**
     * Get header value
     * @return string|null
     */
    public function getHeader()
    {
        return $this->header;
    }
    /**
     * Set header value
     * @param string $header
     * @return \StructType\DepositSlip
     */
    public function setHeader($header = null)
    {
        // validation for constraint: string
        if (!is_null($header) && !is_string($header)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($header)), __LINE__);
        }
        $this->header = $header;
        return $this;
    }
    /**
     * Get amt value
     * @return \StructType\Currency|null
     */
    public function getAmt()
    {
        return $this->amt;
    }
    /**
     * Set amt value
     * @param \StructType\Currency $amt
     * @return \StructType\DepositSlip
     */
    public function setAmt(\StructType\Currency $amt = null)
    {
        $this->amt = $amt;
        return $this;
    }
    /**
     * Get beneficiary value
     * @return \StructType\Beneficiary|null
     */
    public function getBeneficiary()
    {
        return $this->beneficiary;
    }
    /**
     * Set beneficiary value
     * @param \StructType\Beneficiary $beneficiary
     * @return \StructType\DepositSlip
     */
    public function setBeneficiary(\StructType\Beneficiary $beneficiary = null)
    {
        $this->beneficiary = $beneficiary;
        return $this;
    }
    /**
     * Get bankingRefNo value
     * @return string|null
     */
    public function getBankingRefNo()
    {
        return $this->bankingRefNo;
    }
    /**
     * Set bankingRefNo value
     * @param string $bankingRefNo
     * @return \StructType\DepositSlip
     */
    public function setBankingRefNo($bankingRefNo = null)
    {
        // validation for constraint: string
        if (!is_null($bankingRefNo) && !is_string($bankingRefNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankingRefNo)), __LINE__);
        }
        $this->bankingRefNo = $bankingRefNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DepositSlip
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
