<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustVendConfig StructType
 * @subpackage Structs
 */
class CustVendConfig extends AbstractStructBase
{
    /**
     * The canVend
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $canVend;
    /**
     * The fbeDue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $fbeDue;
    /**
     * The maxVendAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $maxVendAmt;
    /**
     * The minVendAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $minVendAmt;
    /**
     * Constructor method for CustVendConfig
     * @uses CustVendConfig::setCanVend()
     * @uses CustVendConfig::setFbeDue()
     * @uses CustVendConfig::setMaxVendAmt()
     * @uses CustVendConfig::setMinVendAmt()
     * @param bool $canVend
     * @param bool $fbeDue
     * @param \StructType\Currency $maxVendAmt
     * @param \StructType\Currency $minVendAmt
     */
    public function __construct($canVend = null, $fbeDue = null, \StructType\Currency $maxVendAmt = null, \StructType\Currency $minVendAmt = null)
    {
        $this
            ->setCanVend($canVend)
            ->setFbeDue($fbeDue)
            ->setMaxVendAmt($maxVendAmt)
            ->setMinVendAmt($minVendAmt);
    }
    /**
     * Get canVend value
     * @return bool
     */
    public function getCanVend()
    {
        return $this->canVend;
    }
    /**
     * Set canVend value
     * @param bool $canVend
     * @return \StructType\CustVendConfig
     */
    public function setCanVend($canVend = null)
    {
        // validation for constraint: boolean
        if (!is_null($canVend) && !is_bool($canVend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($canVend)), __LINE__);
        }
        $this->canVend = $canVend;
        return $this;
    }
    /**
     * Get fbeDue value
     * @return bool|null
     */
    public function getFbeDue()
    {
        return $this->fbeDue;
    }
    /**
     * Set fbeDue value
     * @param bool $fbeDue
     * @return \StructType\CustVendConfig
     */
    public function setFbeDue($fbeDue = null)
    {
        // validation for constraint: boolean
        if (!is_null($fbeDue) && !is_bool($fbeDue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fbeDue)), __LINE__);
        }
        $this->fbeDue = $fbeDue;
        return $this;
    }
    /**
     * Get maxVendAmt value
     * @return \StructType\Currency|null
     */
    public function getMaxVendAmt()
    {
        return $this->maxVendAmt;
    }
    /**
     * Set maxVendAmt value
     * @param \StructType\Currency $maxVendAmt
     * @return \StructType\CustVendConfig
     */
    public function setMaxVendAmt(\StructType\Currency $maxVendAmt = null)
    {
        $this->maxVendAmt = $maxVendAmt;
        return $this;
    }
    /**
     * Get minVendAmt value
     * @return \StructType\Currency|null
     */
    public function getMinVendAmt()
    {
        return $this->minVendAmt;
    }
    /**
     * Set minVendAmt value
     * @param \StructType\Currency $minVendAmt
     * @return \StructType\CustVendConfig
     */
    public function setMinVendAmt(\StructType\Currency $minVendAmt = null)
    {
        $this->minVendAmt = $minVendAmt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustVendConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
