<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustIDNumber StructType
 * @subpackage Structs
 */
class CustIDNumber extends CustIdentifier
{
    /**
     * The idNo
     * @var string
     */
    public $idNo;
    /**
     * Constructor method for CustIDNumber
     * @uses CustIDNumber::setIdNo()
     * @param string $idNo
     */
    public function __construct($idNo = null)
    {
        $this
            ->setIdNo($idNo);
    }
    /**
     * Get idNo value
     * @return string|null
     */
    public function getIdNo()
    {
        return $this->idNo;
    }
    /**
     * Set idNo value
     * @param string $idNo
     * @return \StructType\CustIDNumber
     */
    public function setIdNo($idNo = null)
    {
        // validation for constraint: string
        if (!is_null($idNo) && !is_string($idNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idNo)), __LINE__);
        }
        $this->idNo = $idNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustIDNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
