<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustDetail StructType
 * @subpackage Structs
 */
class CustDetail extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The address
     * @var string
     */
    public $address;
    /**
     * The contactNo
     * @var string
     */
    public $contactNo;
    /**
     * The accNo
     * @var string
     */
    public $accNo;
    /**
     * The locRef
     * @var string
     */
    public $locRef;
    /**
     * Constructor method for CustDetail
     * @uses CustDetail::setName()
     * @uses CustDetail::setAddress()
     * @uses CustDetail::setContactNo()
     * @uses CustDetail::setAccNo()
     * @uses CustDetail::setLocRef()
     * @param string $name
     * @param string $address
     * @param string $contactNo
     * @param string $accNo
     * @param string $locRef
     */
    public function __construct($name = null, $address = null, $contactNo = null, $accNo = null, $locRef = null)
    {
        $this
            ->setName($name)
            ->setAddress($address)
            ->setContactNo($contactNo)
            ->setAccNo($accNo)
            ->setLocRef($locRef);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CustDetail
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\CustDetail
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get contactNo value
     * @return string|null
     */
    public function getContactNo()
    {
        return $this->contactNo;
    }
    /**
     * Set contactNo value
     * @param string $contactNo
     * @return \StructType\CustDetail
     */
    public function setContactNo($contactNo = null)
    {
        // validation for constraint: string
        if (!is_null($contactNo) && !is_string($contactNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactNo)), __LINE__);
        }
        $this->contactNo = $contactNo;
        return $this;
    }
    /**
     * Get accNo value
     * @return string|null
     */
    public function getAccNo()
    {
        return $this->accNo;
    }
    /**
     * Set accNo value
     * @param string $accNo
     * @return \StructType\CustDetail
     */
    public function setAccNo($accNo = null)
    {
        // validation for constraint: string
        if (!is_null($accNo) && !is_string($accNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accNo)), __LINE__);
        }
        $this->accNo = $accNo;
        return $this;
    }
    /**
     * Get locRef value
     * @return string|null
     */
    public function getLocRef()
    {
        return $this->locRef;
    }
    /**
     * Set locRef value
     * @param string $locRef
     * @return \StructType\CustDetail
     */
    public function setLocRef($locRef = null)
    {
        // validation for constraint: string
        if (!is_null($locRef) && !is_string($locRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locRef)), __LINE__);
        }
        $this->locRef = $locRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
