<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Currency StructType
 * @subpackage Structs
 */
class Currency extends AbstractStructBase
{
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $value;
    /**
     * The symbol
     * @var string
     */
    public $symbol;
    /**
     * Constructor method for Currency
     * @uses Currency::setValue()
     * @uses Currency::setSymbol()
     * @param float $value
     * @param string $symbol
     */
    public function __construct($value = null, $symbol = null)
    {
        $this
            ->setValue($value)
            ->setSymbol($symbol);
    }
    /**
     * Get value value
     * @return float
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\Currency
     */
    public function setValue($value = null)
    {
        $this->value = $value;
        return $this;
    }
    /**
     * Get symbol value
     * @return string|null
     */
    public function getSymbol()
    {
        return $this->symbol;
    }
    /**
     * Set symbol value
     * @param string $symbol
     * @return \StructType\Currency
     */
    public function setSymbol($symbol = null)
    {
        // validation for constraint: string
        if (!is_null($symbol) && !is_string($symbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($symbol)), __LINE__);
        }
        $this->symbol = $symbol;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Currency
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
