<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CmftReq StructType
 * @subpackage Structs
 */
class CmftReq extends BaseVendReq
{
    /**
     * The CmftType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CmftType;
    /**
     * The SGC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SGC;
    /**
     * The KeyRevNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KeyRevNo;
    /**
     * The TarrifIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TarrifIndex;
    /**
     * The GeneralPurposeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GeneralPurposeValue;
    /**
     * Constructor method for CmftReq
     * @uses CmftReq::setCmftType()
     * @uses CmftReq::setSGC()
     * @uses CmftReq::setKeyRevNo()
     * @uses CmftReq::setTarrifIndex()
     * @uses CmftReq::setGeneralPurposeValue()
     * @param string $cmftType
     * @param string $sGC
     * @param string $keyRevNo
     * @param string $tarrifIndex
     * @param string $generalPurposeValue
     */
    public function __construct($cmftType = null, $sGC = null, $keyRevNo = null, $tarrifIndex = null, $generalPurposeValue = null)
    {
        $this
            ->setCmftType($cmftType)
            ->setSGC($sGC)
            ->setKeyRevNo($keyRevNo)
            ->setTarrifIndex($tarrifIndex)
            ->setGeneralPurposeValue($generalPurposeValue);
    }
    /**
     * Get CmftType value
     * @return string
     */
    public function getCmftType()
    {
        return $this->CmftType;
    }
    /**
     * Set CmftType value
     * @uses \EnumType\TokenTypes::valueIsValid()
     * @uses \EnumType\TokenTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cmftType
     * @return \StructType\CmftReq
     */
    public function setCmftType($cmftType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TokenTypes::valueIsValid($cmftType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cmftType, implode(', ', \EnumType\TokenTypes::getValidValues())), __LINE__);
        }
        $this->CmftType = $cmftType;
        return $this;
    }
    /**
     * Get SGC value
     * @return string|null
     */
    public function getSGC()
    {
        return $this->SGC;
    }
    /**
     * Set SGC value
     * @param string $sGC
     * @return \StructType\CmftReq
     */
    public function setSGC($sGC = null)
    {
        // validation for constraint: string
        if (!is_null($sGC) && !is_string($sGC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sGC)), __LINE__);
        }
        $this->SGC = $sGC;
        return $this;
    }
    /**
     * Get KeyRevNo value
     * @return string|null
     */
    public function getKeyRevNo()
    {
        return $this->KeyRevNo;
    }
    /**
     * Set KeyRevNo value
     * @param string $keyRevNo
     * @return \StructType\CmftReq
     */
    public function setKeyRevNo($keyRevNo = null)
    {
        // validation for constraint: string
        if (!is_null($keyRevNo) && !is_string($keyRevNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyRevNo)), __LINE__);
        }
        $this->KeyRevNo = $keyRevNo;
        return $this;
    }
    /**
     * Get TarrifIndex value
     * @return string|null
     */
    public function getTarrifIndex()
    {
        return $this->TarrifIndex;
    }
    /**
     * Set TarrifIndex value
     * @param string $tarrifIndex
     * @return \StructType\CmftReq
     */
    public function setTarrifIndex($tarrifIndex = null)
    {
        // validation for constraint: string
        if (!is_null($tarrifIndex) && !is_string($tarrifIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tarrifIndex)), __LINE__);
        }
        $this->TarrifIndex = $tarrifIndex;
        return $this;
    }
    /**
     * Get GeneralPurposeValue value
     * @return string|null
     */
    public function getGeneralPurposeValue()
    {
        return $this->GeneralPurposeValue;
    }
    /**
     * Set GeneralPurposeValue value
     * @param string $generalPurposeValue
     * @return \StructType\CmftReq
     */
    public function setGeneralPurposeValue($generalPurposeValue = null)
    {
        // validation for constraint: string
        if (!is_null($generalPurposeValue) && !is_string($generalPurposeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($generalPurposeValue)), __LINE__);
        }
        $this->GeneralPurposeValue = $generalPurposeValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CmftReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
