<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cheque StructType
 * @subpackage Structs
 */
class Cheque extends PayType
{
    /**
     * The cheqType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $cheqType;
    /**
     * The cheqAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $cheqAmt;
    /**
     * The accHolderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accHolderName;
    /**
     * The accHolderIDNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accHolderIDNo;
    /**
     * The accNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accNo;
    /**
     * The bankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bankName;
    /**
     * The branchCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $branchCode;
    /**
     * The cheqNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cheqNo;
    /**
     * The micr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $micr;
    /**
     * Constructor method for Cheque
     * @uses Cheque::setCheqType()
     * @uses Cheque::setCheqAmt()
     * @uses Cheque::setAccHolderName()
     * @uses Cheque::setAccHolderIDNo()
     * @uses Cheque::setAccNo()
     * @uses Cheque::setBankName()
     * @uses Cheque::setBranchCode()
     * @uses Cheque::setCheqNo()
     * @uses Cheque::setMicr()
     * @param string $cheqType
     * @param \StructType\Currency $cheqAmt
     * @param string $accHolderName
     * @param string $accHolderIDNo
     * @param string $accNo
     * @param string $bankName
     * @param string $branchCode
     * @param string $cheqNo
     * @param string $micr
     */
    public function __construct($cheqType = null, \StructType\Currency $cheqAmt = null, $accHolderName = null, $accHolderIDNo = null, $accNo = null, $bankName = null, $branchCode = null, $cheqNo = null, $micr = null)
    {
        $this
            ->setCheqType($cheqType)
            ->setCheqAmt($cheqAmt)
            ->setAccHolderName($accHolderName)
            ->setAccHolderIDNo($accHolderIDNo)
            ->setAccNo($accNo)
            ->setBankName($bankName)
            ->setBranchCode($branchCode)
            ->setCheqNo($cheqNo)
            ->setMicr($micr);
    }
    /**
     * Get cheqType value
     * @return string
     */
    public function getCheqType()
    {
        return $this->cheqType;
    }
    /**
     * Set cheqType value
     * @uses \EnumType\ChequeType::valueIsValid()
     * @uses \EnumType\ChequeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cheqType
     * @return \StructType\Cheque
     */
    public function setCheqType($cheqType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ChequeType::valueIsValid($cheqType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cheqType, implode(', ', \EnumType\ChequeType::getValidValues())), __LINE__);
        }
        $this->cheqType = $cheqType;
        return $this;
    }
    /**
     * Get cheqAmt value
     * @return \StructType\Currency|null
     */
    public function getCheqAmt()
    {
        return $this->cheqAmt;
    }
    /**
     * Set cheqAmt value
     * @param \StructType\Currency $cheqAmt
     * @return \StructType\Cheque
     */
    public function setCheqAmt(\StructType\Currency $cheqAmt = null)
    {
        $this->cheqAmt = $cheqAmt;
        return $this;
    }
    /**
     * Get accHolderName value
     * @return string|null
     */
    public function getAccHolderName()
    {
        return $this->accHolderName;
    }
    /**
     * Set accHolderName value
     * @param string $accHolderName
     * @return \StructType\Cheque
     */
    public function setAccHolderName($accHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($accHolderName) && !is_string($accHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accHolderName)), __LINE__);
        }
        $this->accHolderName = $accHolderName;
        return $this;
    }
    /**
     * Get accHolderIDNo value
     * @return string|null
     */
    public function getAccHolderIDNo()
    {
        return $this->accHolderIDNo;
    }
    /**
     * Set accHolderIDNo value
     * @param string $accHolderIDNo
     * @return \StructType\Cheque
     */
    public function setAccHolderIDNo($accHolderIDNo = null)
    {
        // validation for constraint: string
        if (!is_null($accHolderIDNo) && !is_string($accHolderIDNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accHolderIDNo)), __LINE__);
        }
        $this->accHolderIDNo = $accHolderIDNo;
        return $this;
    }
    /**
     * Get accNo value
     * @return string|null
     */
    public function getAccNo()
    {
        return $this->accNo;
    }
    /**
     * Set accNo value
     * @param string $accNo
     * @return \StructType\Cheque
     */
    public function setAccNo($accNo = null)
    {
        // validation for constraint: string
        if (!is_null($accNo) && !is_string($accNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accNo)), __LINE__);
        }
        $this->accNo = $accNo;
        return $this;
    }
    /**
     * Get bankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->bankName;
    }
    /**
     * Set bankName value
     * @param string $bankName
     * @return \StructType\Cheque
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->bankName = $bankName;
        return $this;
    }
    /**
     * Get branchCode value
     * @return string|null
     */
    public function getBranchCode()
    {
        return $this->branchCode;
    }
    /**
     * Set branchCode value
     * @param string $branchCode
     * @return \StructType\Cheque
     */
    public function setBranchCode($branchCode = null)
    {
        // validation for constraint: string
        if (!is_null($branchCode) && !is_string($branchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($branchCode)), __LINE__);
        }
        $this->branchCode = $branchCode;
        return $this;
    }
    /**
     * Get cheqNo value
     * @return string|null
     */
    public function getCheqNo()
    {
        return $this->cheqNo;
    }
    /**
     * Set cheqNo value
     * @param string $cheqNo
     * @return \StructType\Cheque
     */
    public function setCheqNo($cheqNo = null)
    {
        // validation for constraint: string
        if (!is_null($cheqNo) && !is_string($cheqNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cheqNo)), __LINE__);
        }
        $this->cheqNo = $cheqNo;
        return $this;
    }
    /**
     * Get micr value
     * @return string|null
     */
    public function getMicr()
    {
        return $this->micr;
    }
    /**
     * Set micr value
     * @param string $micr
     * @return \StructType\Cheque
     */
    public function setMicr($micr = null)
    {
        // validation for constraint: string
        if (!is_null($micr) && !is_string($micr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($micr)), __LINE__);
        }
        $this->micr = $micr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Cheque
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
