<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelVendReq StructType
 * @subpackage Structs
 */
class CancelVendReq extends BaseVendReq
{
    /**
     * The AutoCancel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AutoCancel;
    /**
     * The TransactionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionNumber;
    /**
     * The CDUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EANDeviceID
     */
    public $CDUID;
    /**
     * The CancellationReasonCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CancellationReasonCode;
    /**
     * The token
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\STS1Token
     */
    public $token;
    /**
     * The DocumentNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentNumber;
    /**
     * The OriginalUniqueNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginalUniqueNumber;
    /**
     * Constructor method for CancelVendReq
     * @uses CancelVendReq::setAutoCancel()
     * @uses CancelVendReq::setTransactionNumber()
     * @uses CancelVendReq::setCDUID()
     * @uses CancelVendReq::setCancellationReasonCode()
     * @uses CancelVendReq::setToken()
     * @uses CancelVendReq::setDocumentNumber()
     * @uses CancelVendReq::setOriginalUniqueNumber()
     * @param bool $autoCancel
     * @param string $transactionNumber
     * @param \StructType\EANDeviceID $cDUID
     * @param string $cancellationReasonCode
     * @param \StructType\STS1Token $token
     * @param string $documentNumber
     * @param string $originalUniqueNumber
     */
    public function __construct($autoCancel = null, $transactionNumber = null, \StructType\EANDeviceID $cDUID = null, $cancellationReasonCode = null, \StructType\STS1Token $token = null, $documentNumber = null, $originalUniqueNumber = null)
    {
        $this
            ->setAutoCancel($autoCancel)
            ->setTransactionNumber($transactionNumber)
            ->setCDUID($cDUID)
            ->setCancellationReasonCode($cancellationReasonCode)
            ->setToken($token)
            ->setDocumentNumber($documentNumber)
            ->setOriginalUniqueNumber($originalUniqueNumber);
    }
    /**
     * Get AutoCancel value
     * @return bool
     */
    public function getAutoCancel()
    {
        return $this->AutoCancel;
    }
    /**
     * Set AutoCancel value
     * @param bool $autoCancel
     * @return \StructType\CancelVendReq
     */
    public function setAutoCancel($autoCancel = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoCancel) && !is_bool($autoCancel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($autoCancel)), __LINE__);
        }
        $this->AutoCancel = $autoCancel;
        return $this;
    }
    /**
     * Get TransactionNumber value
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return $this->TransactionNumber;
    }
    /**
     * Set TransactionNumber value
     * @param string $transactionNumber
     * @return \StructType\CancelVendReq
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionNumber)), __LINE__);
        }
        $this->TransactionNumber = $transactionNumber;
        return $this;
    }
    /**
     * Get CDUID value
     * @return \StructType\EANDeviceID|null
     */
    public function getCDUID()
    {
        return $this->CDUID;
    }
    /**
     * Set CDUID value
     * @param \StructType\EANDeviceID $cDUID
     * @return \StructType\CancelVendReq
     */
    public function setCDUID(\StructType\EANDeviceID $cDUID = null)
    {
        $this->CDUID = $cDUID;
        return $this;
    }
    /**
     * Get CancellationReasonCode value
     * @return string|null
     */
    public function getCancellationReasonCode()
    {
        return $this->CancellationReasonCode;
    }
    /**
     * Set CancellationReasonCode value
     * @param string $cancellationReasonCode
     * @return \StructType\CancelVendReq
     */
    public function setCancellationReasonCode($cancellationReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationReasonCode) && !is_string($cancellationReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cancellationReasonCode)), __LINE__);
        }
        $this->CancellationReasonCode = $cancellationReasonCode;
        return $this;
    }
    /**
     * Get token value
     * @return \StructType\STS1Token|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param \StructType\STS1Token $token
     * @return \StructType\CancelVendReq
     */
    public function setToken(\StructType\STS1Token $token = null)
    {
        $this->token = $token;
        return $this;
    }
    /**
     * Get DocumentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->DocumentNumber;
    }
    /**
     * Set DocumentNumber value
     * @param string $documentNumber
     * @return \StructType\CancelVendReq
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->DocumentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get OriginalUniqueNumber value
     * @return string|null
     */
    public function getOriginalUniqueNumber()
    {
        return $this->OriginalUniqueNumber;
    }
    /**
     * Set OriginalUniqueNumber value
     * @param string $originalUniqueNumber
     * @return \StructType\CancelVendReq
     */
    public function setOriginalUniqueNumber($originalUniqueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($originalUniqueNumber) && !is_string($originalUniqueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originalUniqueNumber)), __LINE__);
        }
        $this->OriginalUniqueNumber = $originalUniqueNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelVendReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
